/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.builder;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.php.PHPEditorPlugin;
import com.aptana.editor.php.internal.builder.AbstractBuildPath;
import com.aptana.editor.php.internal.builder.FileSystemDirectory;
import com.aptana.editor.php.internal.builder.FileSystemModule;
import com.aptana.editor.php.internal.builder.FolderFilteringManager;
import com.aptana.editor.php.internal.builder.PHPFileSystemModuleFactory;
import com.aptana.editor.php.internal.core.builder.IBuildPathResource;
import com.aptana.editor.php.internal.core.builder.IDirectory;
import com.aptana.editor.php.internal.core.builder.IModule;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;

public class FileSystemBuildPath
extends AbstractBuildPath {
    private File file;
    private Map<File, IModule> modules = new HashMap<File, IModule>();
    private Map<File, IDirectory> directories = new HashMap<File, IDirectory>();

    public FileSystemBuildPath(File file) {
        this.file = file;
        this.collectInitialResources();
    }

    public void close() {
    }

    public IModule getModule(Object moduleResource) {
        return this.modules.get(moduleResource);
    }

    public List<IModule> getModules() {
        ArrayList<IModule> result = new ArrayList<IModule>();
        result.addAll(this.modules.values());
        return result;
    }

    public File getFile() {
        return this.file;
    }

    public IModule getModuleByPath(IPath path) {
        Path basePath = new Path(this.file.getAbsolutePath());
        IPath modulePath = basePath.append(path);
        File file = new File(modulePath.toOSString());
        return this.modules.get(file);
    }

    public boolean isPassive() {
        return true;
    }

    public List<IModule> getModulesByPath(IPath path) {
        Path basePath = new Path(this.file.getAbsolutePath());
        IPath containerPath = basePath.append(path);
        File file = new File(containerPath.toOSString());
        if (!file.exists()) {
            return null;
        }
        if (!file.isDirectory()) {
            return null;
        }
        File[] childFiles = file.listFiles();
        ArrayList<IModule> result = new ArrayList<IModule>();
        File[] fileArray = childFiles;
        int n = childFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File childFile = fileArray[n2];
            IModule currentmodule = this.getModule(childFile);
            if (currentmodule != null) {
                result.add(currentmodule);
            }
            ++n2;
        }
        return result;
    }

    public List<IDirectory> getSubdirectoriesByPath(IPath path) {
        Path basePath = new Path(this.file.getAbsolutePath());
        IPath containerPath = basePath.append(path);
        File file = new File(containerPath.toOSString());
        if (!file.exists()) {
            return null;
        }
        if (!file.isDirectory()) {
            return null;
        }
        File[] childFiles = file.listFiles();
        ArrayList<IDirectory> result = new ArrayList<IDirectory>();
        File[] fileArray = childFiles;
        int n = childFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File childFile = fileArray[n2];
            IDirectory currentDirectory = this.getDirectory(childFile);
            if (currentDirectory != null) {
                result.add(currentDirectory);
            }
            ++n2;
        }
        return result;
    }

    public IDirectory getDirectory(Object directoryResource) {
        if (!(directoryResource instanceof File)) {
            return null;
        }
        if (!((File)directoryResource).isDirectory()) {
            return null;
        }
        return this.directories.get(directoryResource);
    }

    public IDirectory getDirectoryByPath(IPath path) {
        Path basePath = new Path(this.file.getAbsolutePath());
        IPath modulePath = basePath.append(path);
        File file = new File(modulePath.toOSString());
        return this.directories.get(file);
    }

    public IPath getResourcePath(IBuildPathResource resource) {
        if (resource instanceof FileSystemModule) {
            Path moduleAbsolutePath;
            FileSystemModule fsModule = (FileSystemModule)resource;
            if (this.modules.get(fsModule.getFile()) == null) {
                return null;
            }
            Path basePath = new Path(this.file.getAbsolutePath());
            if (!basePath.isPrefixOf((IPath)(moduleAbsolutePath = new Path(resource.getFullPath())))) {
                return null;
            }
            IPath result = moduleAbsolutePath.removeFirstSegments(basePath.segmentCount());
            result = result.makeAbsolute();
            return result;
        }
        if (resource instanceof FileSystemDirectory) {
            Path moduleAbsolutePath;
            FileSystemDirectory fsDirectory = (FileSystemDirectory)resource;
            if (this.directories.get(fsDirectory.getDirectory()) == null) {
                return null;
            }
            Path basePath = new Path(this.file.getAbsolutePath());
            if (!basePath.isPrefixOf((IPath)(moduleAbsolutePath = new Path(resource.getFullPath())))) {
                return null;
            }
            IPath result = moduleAbsolutePath.removeFirstSegments(basePath.segmentCount());
            result = result.makeAbsolute();
            return result;
        }
        return null;
    }

    public boolean contains(IModule module) {
        if (!(module instanceof FileSystemModule)) {
            return false;
        }
        return this.getModule(((FileSystemModule)module).getFile()) != null;
    }

    private void collectInitialResources() {
        if (!this.file.exists()) {
            return;
        }
        long timeMillis = System.currentTimeMillis();
        this.addResourcesRecursively(this.file);
        IdeLog.logInfo((Plugin)PHPEditorPlugin.getDefault(), (String)("FileSystemBuildPath.collectInitialResources(" + this.file.getName() + ") -> " + (System.currentTimeMillis() - timeMillis) + "ms"), null, (String)"com.aptana.editor.php/debug");
    }

    private void addResourcesRecursively(File inputFile) {
        if (inputFile.isFile()) {
            IModule module = PHPFileSystemModuleFactory.getModule(inputFile, this);
            if (module != null) {
                this.modules.put(inputFile, module);
            }
        } else if (inputFile.isDirectory() && FolderFilteringManager.acceptFolder(inputFile)) {
            this.directories.put(inputFile, new FileSystemDirectory(inputFile, this));
            File[] listFiles = inputFile.listFiles();
            if (listFiles != null) {
                File[] fileArray = listFiles;
                int n = listFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File child = fileArray[n2];
                    this.addResourcesRecursively(child);
                    ++n2;
                }
            }
        }
    }

    public String getHandleIdentifier() {
        return this.file.getAbsolutePath();
    }

    public boolean equals(Object obj) {
        if (obj instanceof FileSystemBuildPath) {
            return ((FileSystemBuildPath)obj).file.equals(this.file);
        }
        return false;
    }

    public int hashCode() {
        return this.file.hashCode();
    }
}

