/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.builder.preferences;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.php.PHPEditorPlugin;
import com.aptana.editor.php.internal.builder.preferences.IProjectDependencyListener;
import com.aptana.editor.php.internal.builder.preferences.PHPExtension;
import com.aptana.editor.php.internal.builder.preferences.ProjectDependencies;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.QualifiedName;

public final class DependenciesManager {
    private static List<IProjectDependencyListener> listeners = new ArrayList<IProjectDependencyListener>();

    public static void addListener(IProjectDependencyListener listener) {
        listeners.add(listener);
    }

    public static void removeListener(IProjectDependencyListener listener) {
        listeners.remove(listener);
    }

    public static ProjectDependencies getDependencies(IProject project) {
        ProjectDependencies dependencies = new ProjectDependencies();
        if (!project.isAccessible()) {
            return dependencies;
        }
        try {
            String persistentProperty = project.getPersistentProperty(DependenciesManager.buildPathPropertyName());
            dependencies.load(persistentProperty);
            dependencies.loadLibs(project.getPersistentProperty(DependenciesManager.libsPropertyName()));
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)PHPEditorPlugin.getDefault(), (String)"Error loading project dependencies", (Throwable)e);
        }
        return dependencies;
    }

    public static void setDependencies(IProject project, ProjectDependencies dependencies) {
        try {
            project.setPersistentProperty(DependenciesManager.buildPathPropertyName(), dependencies.toString());
            project.setPersistentProperty(DependenciesManager.libsPropertyName(), dependencies.getLibString());
            DependenciesManager.notifyChanged(project, dependencies);
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)PHPEditorPlugin.getDefault(), (String)"Error setting project dependencies", (Throwable)e);
        }
    }

    public static void setExtensions(List<PHPExtension> extensions) {
        StringBuilder bld = new StringBuilder();
        for (PHPExtension e : extensions) {
            String eName = DependenciesManager.escape(e.getName());
            String ePath = DependenciesManager.escape(e.getPath());
            bld.append(eName);
            bld.append('\u0003');
            bld.append(ePath);
            bld.append(File.pathSeparatorChar);
        }
        if (bld.length() > 0) {
            bld.deleteCharAt(bld.length() - 1);
        }
        PHPEditorPlugin.getDefault().getPreferenceStore().setValue("php-extensions", bld.toString());
    }

    private static QualifiedName buildPathPropertyName() {
        return new QualifiedName("com.aptana.editor.php", "phpbuildpath");
    }

    private static QualifiedName libsPropertyName() {
        return new QualifiedName("com.aptana.editor.php", "libs");
    }

    public static List<PHPExtension> getExtensions() {
        String string = PHPEditorPlugin.getDefault().getPreferenceStore().getString("php-extensions");
        String[] split = string.split(File.pathSeparator);
        ArrayList<PHPExtension> result = new ArrayList<PHPExtension>();
        String[] stringArray = split;
        int n = split.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.length() > 0) {
                PHPExtension e = new PHPExtension();
                int indexOf = s.indexOf(3);
                String name = s.substring(0, indexOf);
                String path = s.substring(indexOf + 1);
                e.setName(DependenciesManager.descape(name));
                e.setPath(DependenciesManager.descape(path));
                result.add(e);
            }
            ++n2;
        }
        return result;
    }

    static String descape(String substring) {
        String replace = substring.replace('\u0002', File.pathSeparatorChar);
        return replace;
    }

    static String escape(String absolutePath) {
        String replace = absolutePath.replace(File.pathSeparatorChar, '\u0002');
        return replace;
    }

    private static void notifyChanged(IProject project, ProjectDependencies dependencies) {
        for (IProjectDependencyListener listener : listeners) {
            listener.dependenciesChanged(project, dependencies);
        }
    }

    private DependenciesManager() {
    }
}

