/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.contentAssist;

import com.aptana.editor.php.epl.PHPEplPlugin;
import com.aptana.editor.php.internal.contentAssist.Messages;
import com.aptana.editor.php.internal.indexer.language.PHPBuiltins;
import com.aptana.editor.php.internal.parser.nodes.IPHPParseNode;
import com.aptana.editor.php.internal.parser.nodes.PHPFunctionParseNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org2.eclipse.php.internal.core.documentModel.phpElementData.IPHPDocBlock;
import org2.eclipse.php.internal.core.documentModel.phpElementData.IPHPDocTag;

public class ContentAssistUtils {
    private static final int MAX_SYMBOLS_IN_DOC_LINE = 80;
    private static final int BR_DELTA = 2;
    private static Map<Character, List<BuiltinInfo>> index = null;
    private static Boolean filterByNamespace;
    private static final Map<Pattern, String> htmlStrippingMap;

    static {
        htmlStrippingMap = new HashMap<Pattern, String>();
        htmlStrippingMap.put(Pattern.compile("<b>|</b>"), "");
        htmlStrippingMap.put(Pattern.compile("<p>|</p>"), "\n");
        htmlStrippingMap.put(Pattern.compile("<br>|</br>"), "\n");
        htmlStrippingMap.put(Pattern.compile("&lt"), "<");
        htmlStrippingMap.put(Pattern.compile("&gt"), ">");
    }

    public static void cleanIndex() {
        index = null;
    }

    public static synchronized List<Object> selectModelElements(String name, boolean eq) {
        ArrayList<Object> toReturn;
        block8: {
            Character firstCharacter;
            String lowerCaseName;
            block7: {
                if (index == null || index.isEmpty()) {
                    Collection<Object> builtins = PHPBuiltins.getInstance().getBuiltins();
                    if (builtins == null || PHPBuiltins.getInstance().isInitializing()) {
                        return null;
                    }
                    ContentAssistUtils.initializeBuiltinsIndex(builtins);
                }
                if (name == null) {
                    return null;
                }
                toReturn = new ArrayList<Object>();
                if (name.length() == 0) {
                    toReturn = new ArrayList();
                    toReturn.addAll(PHPBuiltins.getInstance().getBuiltins());
                    return toReturn;
                }
                lowerCaseName = name.toLowerCase();
                firstCharacter = Character.valueOf(lowerCaseName.charAt(0));
                if (!eq) break block7;
                List<BuiltinInfo> lst = index.get(firstCharacter);
                if (lst == null) break block8;
                for (BuiltinInfo info : lst) {
                    if (!ContentAssistUtils.acceptsNodeEquals(info, lowerCaseName)) continue;
                    toReturn.add(info.builtIn);
                }
                break block8;
            }
            List<BuiltinInfo> lst = index.get(firstCharacter);
            if (lst != null) {
                for (BuiltinInfo info : lst) {
                    if (!ContentAssistUtils.acceptsNodeStartingWith(info, lowerCaseName)) continue;
                    toReturn.add(info.builtIn);
                }
            }
        }
        return toReturn;
    }

    public static boolean acceptsNodeStartingWith(BuiltinInfo info, String name) {
        return info.lowerCaseName.startsWith(name);
    }

    public static boolean acceptsNodeEquals(BuiltinInfo info, String name) {
        return info.lowerCaseName.equals(name);
    }

    public static String truncateLineIfNeeded(String line) {
        if (line.length() > 80) {
            int endPos = 77;
            Pattern pattern = Pattern.compile("<br>");
            Matcher matcher = pattern.matcher(line);
            while (matcher.find()) {
                int start = matcher.start();
                int end = matcher.end();
                if (start <= endPos && end >= endPos) {
                    endPos = start - 1;
                    break;
                }
                if (start > endPos) break;
                if (end < endPos - 2) continue;
                endPos = start - 1;
                break;
            }
            if (endPos < 0) {
                endPos = 0;
            }
            String subString = line.substring(0, endPos);
            return String.valueOf(subString) + "...";
        }
        return line;
    }

    public static String getDocumentation(IPHPParseNode node, String name) {
        String additionalInfo = Messages.ContentAssistUtils_noAvailableDocumentation;
        StringBuffer buf = new StringBuffer();
        IPHPDocBlock documentation = node.getDocumentation();
        if (!(node instanceof PHPFunctionParseNode)) {
            buf.append("<b>" + name + "</b><br>");
        } else {
            buf.append("<b>" + ((PHPFunctionParseNode)node).getSignature() + "</b><br>");
        }
        if (documentation != null) {
            String longDescription = documentation.getLongDescription();
            if (longDescription.length() > 0) {
                buf.append(longDescription);
            } else {
                buf.append(documentation.getShortDescription());
            }
            IPHPDocTag[] tagsAsArray = documentation.getTagsAsArray();
            buf.append("<br>");
            int a = 0;
            while (a < tagsAsArray.length) {
                buf.append("<br>");
                buf.append(tagsAsArray[a].toString());
                ++a;
            }
        } else {
            buf.append(additionalInfo);
        }
        additionalInfo = buf.toString();
        return additionalInfo;
    }

    public static String stripBasicHTML(String content) {
        for (Pattern strippingPattern : htmlStrippingMap.keySet()) {
            content = strippingPattern.matcher(content).replaceAll(htmlStrippingMap.get(strippingPattern));
        }
        return content;
    }

    public static boolean isFilterByNamespace() {
        if (filterByNamespace == null) {
            filterByNamespace = PHPEplPlugin.getDefault().getPreferenceStore().getBoolean("com.aptana.editor.php.epl.strictNamespaceCodeAssist");
            PHPEplPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    if ("com.aptana.editor.php.epl.strictNamespaceCodeAssist".equals(event.getProperty())) {
                        filterByNamespace = (Boolean)event.getNewValue();
                    }
                }
            });
        }
        return filterByNamespace;
    }

    private static void initializeBuiltinsIndex(Collection<Object> builtins) {
        index = new HashMap<Character, List<BuiltinInfo>>();
        for (Object builtin : builtins) {
            String lowercaseName;
            if (!(builtin instanceof IPHPParseNode) || (lowercaseName = ((IPHPParseNode)builtin).getNodeName().toLowerCase()).length() == 0) continue;
            Character firstCharacter = Character.valueOf(lowercaseName.charAt(0));
            List<BuiltinInfo> charList = index.get(firstCharacter);
            if (charList == null) {
                charList = new ArrayList<BuiltinInfo>();
                index.put(firstCharacter, charList);
            }
            BuiltinInfo info = new BuiltinInfo();
            info.builtIn = builtin;
            info.lowerCaseName = lowercaseName;
            charList.add(info);
        }
    }

    public static class BuiltinInfo {
        public Object builtIn;
        public String lowerCaseName;
    }
}

