/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.contentAssist;

import com.aptana.editor.common.contentassist.CommonCompletionProposal;
import com.aptana.editor.php.internal.contentAssist.IDocumentationResolver;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.InclusivePositionUpdater;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class PHPCompletionProposal
extends CommonCompletionProposal {
    private int fObjectType;
    private IRegion fSelectedRegion;
    private InclusivePositionUpdater fUpdater;
    private IDocumentationResolver resolver;
    protected ITextViewer viewer;
    private List<Position> positions;
    private int exitCaretOffset;

    public PHPCompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, Image image, String displayString, IContextInformation contextInformation, String additionalProposalInfo, int objectType, String fileLocation, Image[] userAgentImages) {
        super(replacementString, replacementOffset, replacementLength, cursorPosition, image, displayString, contextInformation, additionalProposalInfo);
        this.fObjectType = objectType;
        this.setFileLocation(fileLocation);
        this.setUserAgentImages(userAgentImages);
    }

    public static String padToColumn(String stringToPad, int columnWidth) {
        String blanks = "                             ";
        if (stringToPad.length() > columnWidth) {
            return stringToPad.substring(0, columnWidth);
        }
        int blankLength = columnWidth - stringToPad.length();
        return String.valueOf(stringToPad) + blanks.substring(0, blankLength);
    }

    public int getObjectType() {
        return this.fObjectType;
    }

    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        if (offset < this._replacementOffset) {
            return false;
        }
        String proposalContent = null;
        if (this.resolver != null) {
            proposalContent = this.resolver.getProposalContent();
        }
        if (proposalContent == null) {
            proposalContent = this.getDisplayString();
        }
        int overlapIndex = proposalContent.length() - this._replacementString.length();
        overlapIndex = Math.max(0, overlapIndex);
        String endPortion = proposalContent.substring(overlapIndex);
        boolean validated = this.isValidPrefix(this.getPrefix(document, offset), endPortion);
        if (validated && event != null) {
            int newLength;
            int delta = (event.fText == null ? 0 : event.fText.length()) - event.fLength;
            this._replacementLength = newLength = Math.max(this._replacementLength + delta, 0);
        }
        return validated;
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        IDocument document = viewer.getDocument();
        try {
            document.replace(this._replacementOffset, this._replacementLength, this._replacementString);
            if (viewer != null) {
                LinkedModeModel model = new LinkedModeModel();
                boolean positionsAdded = false;
                this.ensurePositionCategoryInstalled(document, model);
                if (this.positions != null && this.positions.size() != 0) {
                    for (Position pos : this.positions) {
                        try {
                            document.addPosition(this.getCategory(), pos);
                            LinkedPositionGroup group = new LinkedPositionGroup();
                            group.addPosition(new LinkedPosition(document, pos.offset, pos.length));
                            model.addGroup(group);
                            positionsAdded = true;
                        }
                        catch (BadPositionCategoryException badPositionCategoryException) {
                            this.ensurePositionCategoryRemoved(document);
                            return;
                        }
                    }
                }
                if (positionsAdded) {
                    model.forceInstall();
                    LinkedModeUI ui = new LinkedModeUI(model, viewer);
                    ui.setExitPosition(viewer, this.exitCaretOffset, 0, Integer.MAX_VALUE);
                    ui.enter();
                    this.fSelectedRegion = ui.getSelectedRegion();
                } else {
                    this.ensurePositionCategoryRemoved(document);
                }
            } else {
                this.ensurePositionCategoryRemoved(document);
            }
        }
        catch (BadLocationException badLocationException) {
            this.ensurePositionCategoryRemoved(document);
        }
    }

    public void setViewer(ITextViewer viewer) {
        this.viewer = viewer;
    }

    public Point getSelection(IDocument document) {
        if (this.fSelectedRegion == null) {
            return new Point(this._replacementOffset, 0);
        }
        return new Point(this.fSelectedRegion.getOffset(), this.fSelectedRegion.getLength());
    }

    public String getAdditionalProposalInfo() {
        if (this.resolver != null) {
            return this.resolver.resolveDocumentation();
        }
        return super.getAdditionalProposalInfo();
    }

    public IDocumentationResolver getResolver() {
        return this.resolver;
    }

    public void setResolver(IDocumentationResolver resolver) {
        this.resolver = resolver;
    }

    public void setPositions(List<Position> positions, int exitCaretOffset) {
        this.positions = positions;
        this.exitCaretOffset = exitCaretOffset;
    }

    private void ensurePositionCategoryInstalled(final IDocument document, LinkedModeModel model) {
        if (!document.containsPositionCategory(this.getCategory())) {
            document.addPositionCategory(this.getCategory());
            this.fUpdater = new InclusivePositionUpdater(this.getCategory());
            document.addPositionUpdater((IPositionUpdater)this.fUpdater);
            model.addLinkingListener(new ILinkedModeListener(){

                public void left(LinkedModeModel environment, int flags) {
                    PHPCompletionProposal.this.ensurePositionCategoryRemoved(document);
                }

                public void suspend(LinkedModeModel environment) {
                }

                public void resume(LinkedModeModel environment, int flags) {
                }
            });
        }
    }

    private void ensurePositionCategoryRemoved(IDocument document) {
        if (document.containsPositionCategory(this.getCategory())) {
            try {
                document.removePositionCategory(this.getCategory());
            }
            catch (BadPositionCategoryException badPositionCategoryException) {}
            document.removePositionUpdater((IPositionUpdater)this.fUpdater);
        }
        this.fSelectedRegion = new Region(this._replacementOffset + this._replacementString.length(), 0);
    }

    private String getCategory() {
        return "PHPProposalCategory_" + this.toString();
    }

    public int getReplacementLength() {
        return this._replacementLength;
    }

    public String getReplacementString() {
        return this._replacementString;
    }

    public void setReplacementLength(int replacementLength) {
        this._replacementLength = replacementLength;
    }

    public int compareTo(PHPCompletionProposal otherProposal) {
        String otherReplacement;
        String replacement = this.getReplacementString();
        if (replacement.startsWith(otherReplacement = otherProposal.getReplacementString())) {
            return 1;
        }
        return replacement.compareTo(otherReplacement);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{PHPCompletionProposal");
        builder.append(", Replacement: ");
        builder.append(this.getReplacementString());
        builder.append(", Display: ");
        builder.append(this.getDisplayString());
        builder.append(", Relevance: ");
        builder.append(this.getRelevance());
        builder.append('}');
        return builder.toString();
    }
}

