/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.indexer;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class CallPath {
    private static final int[] _masks = new int[]{Integer.MIN_VALUE, 0x40000000, 0x20000000, 0x10000000, 0x8000000, 0x4000000, 0x2000000, 0x1000000, 0x800000, 0x400000, 0x200000, 0x100000, 524288, 262144, 131072, 65536, 32768, 16384, 8192, 4096, 2048, 1024, 512, 256, 128, 64, 32, 16, 8, 4, 2, 1};
    private List<String> names = new ArrayList<String>(1);
    private int types;
    private boolean firstEntryOfClassType = false;
    private List<Boolean> typesArray = null;

    public int getSize() {
        return this.names.size();
    }

    public void setClassEntry(String name) {
        if (this.names.size() != 0) {
            throw new IllegalArgumentException("Only the first entry might have Class type");
        }
        this.firstEntryOfClassType = true;
        this.names.add(name);
    }

    public void addVariableEntry(String name) {
        if (this.names.size() == 31) {
            this.typesArray = new ArrayList<Boolean>(32);
            this.typesArray.add(true);
        } else if (this.names.size() > 31) {
            this.typesArray.add(true);
        } else {
            this.types |= _masks[this.names.size()];
        }
        this.names.add(name);
    }

    public void addMethodEntry(String name) {
        if (this.names.size() == 31) {
            this.typesArray = new ArrayList<Boolean>(32);
            this.typesArray.add(false);
        } else if (this.names.size() > 31) {
            this.typesArray.add(false);
        }
        this.names.add(name);
    }

    public void addPath(CallPath path) {
        for (Entry entry : path.getEntries()) {
            if (entry instanceof ClassEntry) {
                throw new IllegalArgumentException("Class entry must start the path, so path containing Class entry can not be added.");
            }
            if (entry instanceof MethodEntry) {
                this.addMethodEntry(entry.getName());
                continue;
            }
            if (entry instanceof VariableEntry) {
                this.addVariableEntry(entry.getName());
                continue;
            }
            throw new IllegalArgumentException("Unknown entry type: " + entry.getClass().getCanonicalName());
        }
    }

    public void insertVariableEntry(String name) {
        if (this.names.size() == 31) {
            this.typesArray = new ArrayList<Boolean>(32);
            this.typesArray.add(0, true);
        } else if (this.names.size() > 31) {
            this.typesArray.add(0, true);
        } else {
            this.types >>>= 1;
            this.types |= _masks[0];
        }
        this.names.add(0, name);
    }

    public void insertMethodEntry(String name) {
        if (this.names.size() == 31) {
            this.typesArray = new ArrayList<Boolean>(32);
            this.typesArray.add(0, false);
        } else if (this.names.size() > 31) {
            this.typesArray.add(0, false);
        } else {
            this.types >>>= 1;
        }
        this.names.add(0, name);
    }

    public CallPath subPath(int start) {
        if (start >= this.names.size()) {
            return new CallPath();
        }
        CallPath result = new CallPath();
        List<Entry> entries = this.getEntries();
        int i = start;
        while (i < entries.size()) {
            Entry entry = entries.get(i);
            if (entry instanceof VariableEntry) {
                result.addVariableEntry(entry.getName());
            } else {
                result.addMethodEntry(entry.getName());
            }
            ++i;
        }
        return result;
    }

    public List<Entry> getEntries() {
        ArrayList<Entry> result = new ArrayList<Entry>(this.names.size());
        int i = 0;
        while (i < this.names.size()) {
            if (i == 0 && this.firstEntryOfClassType) {
                result.add(new ClassEntry(this.names.get(i)));
            } else if (this.getType(i)) {
                result.add(new VariableEntry(this.names.get(i)));
            } else {
                result.add(new MethodEntry(this.names.get(i)));
            }
            ++i;
        }
        return result;
    }

    private boolean getType(int i) {
        if (this.names.size() > 31) {
            return this.typesArray.get(i);
        }
        return (this.types & _masks[i]) != 0;
    }

    public String toString() {
        return this.getEntries().toString();
    }

    public boolean compare(CallPath other) {
        if (this.names.size() != other.names.size()) {
            return false;
        }
        if (this.typesArray != null) {
            if (other.typesArray == null) {
                return false;
            }
            if (!this.typesArray.equals(other.typesArray)) {
                return false;
            }
        } else if (this.types != other.types) {
            return false;
        }
        return this.names.equals(other.names);
    }

    public void write(DataOutputStream da) throws IOException {
        int size = this.names.size();
        da.writeInt(size);
        da.writeInt(this.types);
        da.writeBoolean(this.firstEntryOfClassType);
        for (String s : this.names) {
            da.writeUTF(s);
        }
        da.writeBoolean(this.typesArray != null);
        if (this.typesArray != null) {
            da.writeInt(this.typesArray.size());
            for (Boolean b : this.typesArray) {
                da.writeBoolean(b);
            }
        }
    }

    public CallPath() {
    }

    public CallPath(DataInputStream di) throws IOException {
        int readInt = di.readInt();
        this.names = new ArrayList<String>(readInt);
        this.types = di.readInt();
        this.firstEntryOfClassType = di.readBoolean();
        int a = 0;
        while (a < readInt) {
            this.names.add(di.readUTF().intern());
            ++a;
        }
        if (di.readBoolean()) {
            int sz = di.readInt();
            this.typesArray = new ArrayList<Boolean>(sz);
            int a2 = 0;
            while (a2 < sz) {
                this.typesArray.add(di.readBoolean());
                ++a2;
            }
        }
    }

    public static final class ClassEntry
    extends Entry {
        public ClassEntry(String name) {
            super(name);
        }

        public String toString() {
            return "class: " + this.getName();
        }
    }

    public static abstract class Entry {
        private String name;

        protected Entry(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Entry other = (Entry)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }
    }

    public static final class MethodEntry
    extends Entry {
        public MethodEntry(String name) {
            super(name);
        }

        public String toString() {
            return "func: " + this.getName();
        }
    }

    public static final class VariableEntry
    extends Entry {
        public VariableEntry(String name) {
            super(name);
        }

        public String toString() {
            return "var: " + this.getName();
        }
    }
}

