/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.indexer;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.php.PHPEditorPlugin;
import com.aptana.editor.php.indexer.IElementEntry;
import com.aptana.editor.php.indexer.IElementsIndex;
import com.aptana.editor.php.internal.core.builder.IBuildPath;
import com.aptana.editor.php.internal.core.builder.IModule;
import com.aptana.editor.php.internal.indexer.BuildPathElementEntriesFilter;
import com.aptana.editor.php.internal.indexer.IElementEntriesFilter;
import com.aptana.editor.php.internal.indexer.IncludePHPEntryValue;
import com.aptana.editor.php.internal.indexer.PHPModuleBasedEntriesFilter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;

public final class ElementsIndexingUtils {
    public static String getFirstNameInPath(String path) {
        if (path == null) {
            return null;
        }
        int delimiterIndex = path.indexOf(47);
        if (delimiterIndex == -1) {
            return path;
        }
        return path.substring(0, delimiterIndex);
    }

    public static String getLastNameInPath(String path) {
        if (path == null) {
            return null;
        }
        int delimiterIndex = path.lastIndexOf(47);
        if (delimiterIndex == -1 || delimiterIndex == path.length() - 1) {
            return path;
        }
        return path.substring(delimiterIndex + 1, path.length());
    }

    public static IElementEntriesFilter createIncludeFilter(IModule module, IElementsIndex index) {
        if (!ElementsIndexingUtils.includeFilteringEnabled()) {
            return new BuildPathElementEntriesFilter(module);
        }
        List<IElementEntry> includeEntries = index.getEntries(5, "");
        HashMap<IModule, Set<String>> includes = new HashMap<IModule, Set<String>>();
        for (IElementEntry includeEntry : includeEntries) {
            IncludePHPEntryValue value;
            String includePath;
            Object val = includeEntry.getValue();
            if (val == null || !(val instanceof IncludePHPEntryValue) || (includePath = (value = (IncludePHPEntryValue)val).getIncludePath()) == null || includePath.length() == 0) continue;
            IModule currentModule = includeEntry.getModule();
            HashSet<String> moduleIncludes = (HashSet<String>)includes.get(currentModule);
            if (moduleIncludes == null) {
                moduleIncludes = new HashSet<String>();
                includes.put(currentModule, moduleIncludes);
            }
            moduleIncludes.add(includePath);
        }
        HashSet<IModule> includedModules = new HashSet<IModule>();
        ElementsIndexingUtils.addModulesIncluded(includes, module, includedModules);
        includedModules.add(module);
        return new PHPModuleBasedEntriesFilter(includedModules);
    }

    private static void addModulesIncluded(Map<IModule, Set<String>> index, IModule module, Set<IModule> result) {
        Set<String> includes = index.get(module);
        if (includes == null || includes.isEmpty()) {
            return;
        }
        IBuildPath buildPath = module.getBuildPath();
        for (String include : includes) {
            try {
                IModule includedModule;
                Path path = new Path(include);
                if (path.isAbsolute() || (includedModule = buildPath.resolveRelativePath(module, (IPath)path)) == null || result.contains(includedModule)) continue;
                result.add(includedModule);
                ElementsIndexingUtils.addModulesIncluded(index, includedModule, result);
            }
            catch (Throwable th) {
                IdeLog.logWarning((Plugin)PHPEditorPlugin.getDefault(), (String)"PHP elements indexing - Error while including modules (addModulesIncluded)", (Throwable)th, (String)"com.aptana.editor.php/debug/indexer");
            }
        }
    }

    private static boolean includeFilteringEnabled() {
        return "com.aptana.editor.php.contentassist.CONTENT_ASSIST_EXPLICIT_INCLUDE".equals(PHPEditorPlugin.getDefault().getPreferenceStore().getString("com.aptana.editor.php.contentassist.CONTENT_ASSIST_FILTER_TYPE"));
    }

    private ElementsIndexingUtils() {
    }
}

