/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.indexer;

import com.aptana.editor.php.indexer.IElementEntry;
import com.aptana.editor.php.indexer.IElementsIndex;
import com.aptana.editor.php.internal.core.builder.IModule;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ModuleSubstitutionIndex
implements IElementsIndex {
    private IModule module;
    private IElementsIndex handler;
    private IElementsIndex mainIndex;

    public ModuleSubstitutionIndex(IModule module, IElementsIndex handler, IElementsIndex mainIndex) {
        this.module = module;
        this.handler = handler;
        this.mainIndex = mainIndex;
    }

    @Override
    public synchronized List<IElementEntry> getEntries(int category, String path) {
        ArrayList<IElementEntry> result = new ArrayList<IElementEntry>();
        result.addAll(this.handler.getEntries(category, path));
        List<IElementEntry> mainEntries = this.mainIndex.getEntries(category, path);
        Iterator<IElementEntry> it = mainEntries.iterator();
        while (it.hasNext()) {
            IElementEntry entry = it.next();
            if (!this.module.equals(entry.getModule())) continue;
            it.remove();
        }
        result.addAll(mainEntries);
        return result;
    }

    @Override
    public synchronized List<IElementEntry> getEntriesStartingWith(int category, String path) {
        ArrayList<IElementEntry> result = new ArrayList<IElementEntry>();
        result.addAll(this.handler.getEntriesStartingWith(category, path));
        List<IElementEntry> mainEntries = this.mainIndex.getEntriesStartingWith(category, path);
        Iterator<IElementEntry> it = mainEntries.iterator();
        while (it.hasNext()) {
            IElementEntry entry = it.next();
            if (!this.module.equals(entry.getModule())) continue;
            it.remove();
        }
        result.addAll(mainEntries);
        return result;
    }

    @Override
    public synchronized List<IElementEntry> getModuleEntries(IModule module) {
        if (this.module.equals(module)) {
            return this.handler.getModuleEntries(module);
        }
        return this.mainIndex.getModuleEntries(module);
    }

    @Override
    public Set<IModule> getModules() {
        return this.mainIndex.getModules();
    }
}

