/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.indexer.language;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.editor.php.PHPEditorPlugin;
import com.aptana.editor.php.epl.PHPEplPlugin;
import com.aptana.editor.php.internal.indexer.language.Messages;
import com.aptana.editor.php.internal.parser.PHPParser;
import com.aptana.editor.php.internal.parser.nodes.IPHPParseNode;
import com.aptana.editor.php.internal.parser.nodes.PHPBaseParseNode;
import com.aptana.editor.php.internal.parser.nodes.PHPClassParseNode;
import com.aptana.editor.php.internal.parser.nodes.PHPConstantNode;
import com.aptana.editor.php.internal.parser.nodes.PHPFunctionParseNode;
import com.aptana.editor.php.internal.parser.nodes.PHPVariableParseNode;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org2.eclipse.php.internal.core.PHPVersion;
import org2.eclipse.php.internal.core.documentModel.phpElementData.IPHPDocBlock;
import org2.eclipse.php.internal.core.documentModel.phpElementData.IPHPDocTag;
import org2.eclipse.php.internal.core.documentModel.phpElementData.PHPDocBlockImp;

public final class PHPBuiltins {
    public static final String LANGUAGE_LIBRARY_PATH_BASE = "Resources/language/php";
    public static final String PHP4_LANGUAGE_LIBRARY_PATH = "Resources/language/php4";
    public static final String PHP5_LANGUAGE_LIBRARY_PATH = "Resources/language/php5";
    public static final String PHP53_LANGUAGE_LIBRARY_PATH = "Resources/language/php5.3";
    public static final String PHP54_LANGUAGE_LIBRARY_PATH = "Resources/language/php5.4";
    private static final int INITIAL_CAPACITY = 5000;
    private static final IPHPDocTag[] NO_TAGS = new IPHPDocTag[0];
    private static final PHPBuiltins instance = new PHPBuiltins();
    private static final Set<String> PHP4_RESTRICTED = CollectionsUtil.newSet((Object[])new String[]{"namespace", "using", "goto", "use"});
    private Object mutex = new Object();
    private Map<PHPVersion, Set<String>> phpNames;
    private Map<String, String> builtInFunctions = new HashMap<String, String>();
    private Map<String, String> builtInClasses = new HashMap<String, String>();
    private Map<String, String> builtInConstants = new HashMap<String, String>();
    private SortedSet<Object> builtins;
    private boolean initializing;

    private void addKeywords() {
        this.addKeyword("cfunction", "cfunction", new PHPVersion[0]);
        this.addKeyword("stdClass", "stdClass", new PHPVersion[0]);
        this.addMagicMethod("__construct", "__construct", PHPVersion.PHP5, PHPVersion.PHP5_3);
        this.addMagicMethod("__destruct", "__destruct", PHPVersion.PHP5, PHPVersion.PHP5_3);
        this.addMagicMethod("__call", "__call", PHPVersion.PHP5, PHPVersion.PHP5_3);
        this.addMagicMethod("__callStatic", "__callStatic", PHPVersion.PHP5, PHPVersion.PHP5_3);
        this.addMagicMethod("__get", "__get", PHPVersion.PHP5, PHPVersion.PHP5_3);
        this.addMagicMethod("__set", "__set", PHPVersion.PHP5, PHPVersion.PHP5_3);
        this.addMagicMethod("__isset", "__isset", PHPVersion.PHP5, PHPVersion.PHP5_3);
        this.addMagicMethod("__unset", "__unset", PHPVersion.PHP5, PHPVersion.PHP5_3);
        this.addMagicMethod("__sleep", "__sleep", PHPVersion.PHP5, PHPVersion.PHP5_3);
        this.addMagicMethod("__wakeup", "__wakeup", PHPVersion.PHP5, PHPVersion.PHP5_3);
        this.addMagicMethod("__toString", "__toString", PHPVersion.PHP5, PHPVersion.PHP5_3);
        this.addMagicMethod("__invoke", "__invoke", PHPVersion.PHP5_3);
        this.addMagicMethod("__set_state", "__set_state", PHPVersion.PHP5, PHPVersion.PHP5_3);
        this.addMagicMethod("__clone", "__clone", PHPVersion.PHP5, PHPVersion.PHP5_3);
        this.addMagicConstant("__LINE__", "__LINE__", PHPVersion.PHP5, PHPVersion.PHP5_3);
        this.addMagicConstant("__FILE__", "__FILE__", PHPVersion.PHP5, PHPVersion.PHP5_3);
        this.addMagicConstant("__FUNCTION__", "__FUNCTION__", PHPVersion.PHP5, PHPVersion.PHP5_3);
        this.addMagicConstant("__CLASS__", "__CLASS__", PHPVersion.PHP5, PHPVersion.PHP5_3);
        this.addMagicConstant("__METHOD__", "__METHOD__", PHPVersion.PHP5, PHPVersion.PHP5_3);
        this.addSuperGlobal("$PHP_SELF", "$PHP_SELF");
        this.addSuperGlobal("$GLOBALS", "$GLOBALS");
        this.addSuperGlobal("$_SERVER", "$_SERVER");
        this.addSuperGlobal("$_GET", "$_GET");
        this.addSuperGlobal("$_POST", "$_POST");
        this.addSuperGlobal("$_COOKIE", "$_COOKIE");
        this.addSuperGlobal("$_FILES", "$_FILES");
        this.addSuperGlobal("$_ENV", "$_ENV");
        this.addSuperGlobal("$_REQUEST", "$_REQUEST");
        this.addSuperGlobal("$_SESSION", "$_SESSION");
        this.addSuperGlobal("$HTTP_POST_VARS", "$HTTP_POST_VARS");
        this.addSuperGlobal("$HTTP_GET_VARS", "$HTTP_GET_VARS");
        this.addSuperGlobal("$HTTP_ENV_VARS", "$HTTP_ENV_VARS");
        this.addSuperGlobal("$HTTP_SERVER_VARS", "$HTTP_SERVER_VARS");
        this.addSuperGlobal("$HTTP_COOKIE_VARS", "$HTTP_COOKIE_VARS");
        this.addKeyword("abstract", "abstract", PHPVersion.PHP5, PHPVersion.PHP5_3);
        this.addKeyword("array", "array", new PHPVersion[0]);
        this.addBuiltin("KEYWORD", "ARRAY_CAST", "Array Cast", new PHPVersion[0]);
        this.addKeyword("as", "as", new PHPVersion[0]);
        this.addBuiltin("KEYWORD", "BOOL_CAST", "Boolean Cast", new PHPVersion[0]);
        this.addKeyword("break", "break", new PHPVersion[0]);
        this.addKeyword("case", "case", new PHPVersion[0]);
        this.addKeyword("catch", "catch", new PHPVersion[0]);
        this.addKeyword("class", "class", new PHPVersion[0]);
        this.addKeyword("clone", "clone", new PHPVersion[0]);
        this.addKeyword("const", "const", new PHPVersion[0]);
        this.addKeyword("continue", "continue", new PHPVersion[0]);
        this.addKeyword("declare", "declare", new PHPVersion[0]);
        this.addKeyword("default", "default", new PHPVersion[0]);
        this.addKeyword("do", "do", new PHPVersion[0]);
        this.addBuiltin("KEYWORD", "DOUBLE_CAST", "Double Cast", new PHPVersion[0]);
        this.addKeyword("echo", "echo", new PHPVersion[0]);
        this.addKeyword("else", "else", new PHPVersion[0]);
        this.addKeyword("elseif", "elseif", new PHPVersion[0]);
        this.addKeyword("empty", "empty", new PHPVersion[0]);
        this.addKeyword("enddeclare", "enddeclare", new PHPVersion[0]);
        this.addKeyword("endfor", "endfor", new PHPVersion[0]);
        this.addKeyword("endforeach", "endforeach", new PHPVersion[0]);
        this.addKeyword("endif", "endif", new PHPVersion[0]);
        this.addKeyword("endswitch", "endswitch", new PHPVersion[0]);
        this.addKeyword("endwhile", "endwhile", new PHPVersion[0]);
        this.addKeyword("eval", "eval", new PHPVersion[0]);
        this.addKeyword("exception", "exception", new PHPVersion[0]);
        this.addKeyword("exit", "exit", new PHPVersion[0]);
        this.addBuiltin("die", "EXIT", "exit", new PHPVersion[0]);
        this.addKeyword("extends", "extends", new PHPVersion[0]);
        this.addKeyword("final", "final", PHPVersion.PHP5, PHPVersion.PHP5_3);
        this.addKeyword("for", "for", new PHPVersion[0]);
        this.addKeyword("foreach", "foreach", new PHPVersion[0]);
        this.addKeyword("function", "function", new PHPVersion[0]);
        this.addKeyword("global", "global", new PHPVersion[0]);
        this.addBuiltin("__halt_compiler", "HALT_COMPILER", "Halt compiler", new PHPVersion[0]);
        this.addKeyword("if", "if", new PHPVersion[0]);
        this.addKeyword("implements", "implements", new PHPVersion[0]);
        this.addKeyword("include", "include", new PHPVersion[0]);
        this.addKeyword("include_once", "include_once", new PHPVersion[0]);
        this.addKeyword("instanceof", "instanceof", new PHPVersion[0]);
        this.addBuiltin("KEYWORD", "INT_CAST", "Integer Cast", new PHPVersion[0]);
        this.addKeyword("interface", "interface", PHPVersion.PHP5, PHPVersion.PHP5_3);
        this.addKeyword("isset", "isset", new PHPVersion[0]);
        this.addKeyword("list", "list", new PHPVersion[0]);
        this.addBuiltin("and", "LOGICAL_AND", "Logical and", new PHPVersion[0]);
        this.addBuiltin("or", "LOGICAL_OR", "Logical or", new PHPVersion[0]);
        this.addBuiltin("xor", "LOGICAL_XOR", "Logical xor", new PHPVersion[0]);
        this.addKeyword("new", "new", new PHPVersion[0]);
        this.addBuiltin("KEYWORD", "OBJECT_CAST", "Object Cast", new PHPVersion[0]);
        this.addKeyword("print", "print", new PHPVersion[0]);
        this.addKeyword("private", "private", PHPVersion.PHP5, PHPVersion.PHP5_3);
        this.addKeyword("protected", "protected", PHPVersion.PHP5, PHPVersion.PHP5_3);
        this.addKeyword("public", "public", PHPVersion.PHP5, PHPVersion.PHP5_3);
        this.addKeyword("require", "require", new PHPVersion[0]);
        this.addKeyword("require_once", "require_once", new PHPVersion[0]);
        this.addKeyword("return", "return", new PHPVersion[0]);
        this.addKeyword("static", "static", new PHPVersion[0]);
        this.addBuiltin("KEYWORD", "STRING_CAST", "String Cast", new PHPVersion[0]);
        this.addKeyword("switch", "switch", new PHPVersion[0]);
        this.addKeyword("throw", "throw", new PHPVersion[0]);
        this.addKeyword("try", "try", new PHPVersion[0]);
        this.addKeyword("unset", "unset", new PHPVersion[0]);
        this.addBuiltin("KEYWORD", "UNSET_CAST", "Unset Case", new PHPVersion[0]);
        this.addKeyword("var", "var", new PHPVersion[0]);
        this.addKeyword("while", "while", new PHPVersion[0]);
        this.addKeyword("namespace", "namespace", PHPVersion.PHP5_3);
        this.addKeyword("goto", "goto", PHPVersion.PHP5_3);
        this.addKeyword("use", "use", PHPVersion.PHP5_3);
        this.addKeyword("trait", "trait", PHPVersion.PHP5_4);
        this.addKeyword("callable", "callable", PHPVersion.PHP5_4);
        this.addKeyword("insteadof", "insteadof", PHPVersion.PHP5_4);
        this.addKeyword("false", "false", new PHPVersion[0]);
        this.addKeyword("null", "null", new PHPVersion[0]);
        this.addKeyword("old_function", "old_function", new PHPVersion[0]);
        this.addKeyword("parent", "parent", new PHPVersion[0]);
        this.addKeyword("php_user_filter", "php_user_filter", new PHPVersion[0]);
        this.addKeyword("$this", "$this", new PHPVersion[0]);
        this.addKeyword("self", "self", new PHPVersion[0]);
        this.addKeyword("true", "true", new PHPVersion[0]);
    }

    private void addBuiltin(String string, String nodeName, String description, PHPVersion ... phpVersions) {
        this.addBuiltin(string, nodeName, description, (short)4505, phpVersions);
    }

    private void addBuiltin(String string, String nodeName, String description, short nodeType, PHPVersion ... phpVersions) {
        PHPBaseParseNode node = new PHPBaseParseNode(nodeType, 0, -1, -1, nodeName);
        this.builtins.add(node);
        node.setDocumentation((IPHPDocBlock)new PHPDocBlockImp(description, "", NO_TAGS, 0));
        if (phpVersions != null && phpVersions.length > 0) {
            PHPVersion[] pHPVersionArray = phpVersions;
            int n = phpVersions.length;
            int n2 = 0;
            while (n2 < n) {
                PHPVersion version = pHPVersionArray[n2];
                this.phpNames.get(version).add(string);
                ++n2;
            }
        } else {
            for (PHPVersion version : EnumSet.allOf(PHPVersion.class)) {
                this.phpNames.get(version).add(string);
            }
        }
    }

    private void addKeyword(String string, String nodeName, PHPVersion ... phpVersions) {
        this.addBuiltin(string, nodeName, MessageFormat.format(Messages.KEYWORD_LABEL, nodeName), phpVersions);
    }

    private void addMagicConstant(String string, String nodeName, PHPVersion ... phpVersions) {
        this.addBuiltin(string, nodeName, MessageFormat.format(Messages.MAGIC_CONSTANT_LABEL, nodeName), phpVersions);
    }

    private void addMagicMethod(String string, String nodeName, PHPVersion ... phpVersions) {
        this.addBuiltin(string, nodeName, MessageFormat.format(Messages.MAGIC_METHOD_LABEL, nodeName), phpVersions);
    }

    private void addPredefinedConstant(String string, String nodeName, PHPVersion phpVersion) {
        this.addBuiltin(string, nodeName, MessageFormat.format(Messages.PREDEFINED_CONSTANT_LABEL, nodeName), phpVersion);
    }

    private void addSuperGlobal(String string, String nodeName) {
        this.addBuiltin(string, nodeName, MessageFormat.format(Messages.SUPERGLOBAL_LABEL, nodeName), (short)4503, new PHPVersion[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection<Object> getBuiltins() {
        if (this.builtins == null) {
            Object object = this.mutex;
            synchronized (object) {
                if (this.initializing) {
                    return null;
                }
            }
            Job parseBuiltins = new Job(Messages.PHPBuiltins_indexingLibraries){

                protected IStatus run(IProgressMonitor monitor) {
                    PHPBuiltins.this.clean(monitor);
                    return Status.OK_STATUS;
                }
            };
            parseBuiltins.setPriority(40);
            parseBuiltins.schedule();
        }
        return this.builtins;
    }

    public boolean existsIn(PHPVersion version, IPHPParseNode node) {
        if (node == null || version == null) {
            return false;
        }
        if (version.equals((Object)PHPVersion.PHP4) && node.getClass() == PHPBaseParseNode.class && PHP4_RESTRICTED.contains(node.getNodeName())) {
            return false;
        }
        return this.phpNames.get(version).contains(node.getNodeName());
    }

    public boolean isBuiltinFunction(String name) {
        return this.builtInFunctions.containsKey(name);
    }

    public boolean isBuiltinClassOrConstant(String name) {
        return this.builtInClasses.containsKey(name) || this.builtInConstants.containsKey(name);
    }

    public boolean isBuiltinConstant(String name) {
        return this.builtInConstants.containsKey(name);
    }

    public boolean isBuiltinClass(String name) {
        return this.builtInClasses.containsKey(name);
    }

    public InputStream getBuiltinResourceStream(String entry) throws IOException {
        String path = null;
        if (this.isBuiltinFunction(entry)) {
            path = this.builtInFunctions.get(entry);
        } else if (this.isBuiltinClassOrConstant(entry) && (path = this.builtInClasses.get(entry)) == null) {
            path = this.builtInConstants.get(entry);
        }
        if (path != null) {
            try {
                URL url = new URL(path);
                return url.openStream();
            }
            catch (MalformedURLException e) {
                IdeLog.logWarning((Plugin)PHPEditorPlugin.getDefault(), (String)"Error retrieving the built-in resource", (Throwable)e, (String)"com.aptana.editor.php/debug/indexer");
            }
        }
        return null;
    }

    private void initBuiltins(IProgressMonitor monitor) {
        try {
            IdeLog.logInfo((Plugin)PHPEditorPlugin.getDefault(), (String)"Indexing the PHP API libraries...", null, (String)"com.aptana.editor.php/debug/indexer");
            this.builtins = new TreeSet<Object>(new Comparator<Object>(){

                @Override
                public int compare(Object arg0, Object arg1) {
                    PHPBaseParseNode node0 = (PHPBaseParseNode)arg0;
                    PHPBaseParseNode node1 = (PHPBaseParseNode)arg1;
                    if (node0.getClass() == node1.getClass()) {
                        return node0.getNodeName().toLowerCase().compareTo(node1.getNodeName().toLowerCase());
                    }
                    return node0.getNodeName().compareTo(node1.getNodeName());
                }
            });
            HashMap<Object, Object> builtins = new HashMap<Object, Object>(5000);
            long start = System.currentTimeMillis();
            for (PHPVersion version : EnumSet.allOf(PHPVersion.class)) {
                long timeMillis = System.currentTimeMillis();
                monitor.setTaskName(MessageFormat.format(Messages.PHPBuiltins_languageSupportTaskName, version.getAlias()));
                this.initPHPBuiltins(version, builtins);
                if (!PHPEditorPlugin.INDEXER_DEBUG) continue;
                IdeLog.logInfo((Plugin)PHPEditorPlugin.getDefault(), (String)MessageFormat.format("Parsed {0} built-ins ({1}ms)", version.getAlias(), System.currentTimeMillis() - timeMillis), null, (String)"com.aptana.editor.php/debug/indexer");
                timeMillis = System.currentTimeMillis();
            }
            this.builtins.addAll(builtins.values());
            this.addKeywords();
            IdeLog.logInfo((Plugin)PHPEditorPlugin.getDefault(), (String)MessageFormat.format("Loaded all PHP built-ins ({0}ms)", System.currentTimeMillis() - start), null, (String)"com.aptana.editor.php/debug/indexer");
        }
        catch (Throwable t) {
            IdeLog.logError((Plugin)PHPEditorPlugin.getDefault(), (String)"Error loading the PHP Built-in API", (Throwable)t);
        }
    }

    private void initPHPBuiltins(PHPVersion version, Map<Object, Object> builtins) {
        PHPParser parser = new PHPParser(version, false);
        try {
            URL[] urls;
            URL[] uRLArray = urls = PHPBuiltins.getBuiltinsURLs(this.getLibraryPath(version));
            int n = urls.length;
            int n2 = 0;
            while (n2 < n) {
                URL url = uRLArray[n2];
                try {
                    IParseRootNode parseNode = parser.parse(url.openStream());
                    Set<String> names = this.phpNames.get(version);
                    for (IParseNode node : parseNode) {
                        String name = node.getNameNode().getName().intern();
                        names.add(name);
                        if (node instanceof PHPFunctionParseNode) {
                            this.builtInFunctions.put(name, url.toString().intern());
                        } else {
                            this.addBuiltinClassOrConstant(node, url);
                        }
                        if (node instanceof PHPConstantNode) continue;
                        builtins.put(name, node);
                    }
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)PHPEditorPlugin.getDefault(), (String)("Error loading the built-in PHP API for " + url.getFile()), (Throwable)e);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)PHPEditorPlugin.getDefault(), (String)"Error loading the built-in PHP API.", (Throwable)e);
        }
    }

    private String getLibraryPath(PHPVersion version) {
        switch (version) {
            case PHP4: {
                return PHP4_LANGUAGE_LIBRARY_PATH;
            }
            case PHP5: {
                return PHP5_LANGUAGE_LIBRARY_PATH;
            }
            case PHP5_3: {
                return PHP53_LANGUAGE_LIBRARY_PATH;
            }
            case PHP5_4: {
                return PHP54_LANGUAGE_LIBRARY_PATH;
            }
        }
        IdeLog.logError((Plugin)PHPEditorPlugin.getDefault(), (String)("Unknows PHPVersion " + version));
        return null;
    }

    private void addBuiltinClassOrConstant(IParseNode child, URL url) {
        if (child instanceof PHPClassParseNode) {
            IParseNode[] children;
            this.builtInClasses.put(child.getNameNode().getName(), url.toString().intern());
            IParseNode[] iParseNodeArray = children = child.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IParseNode node = iParseNodeArray[n2];
                if (node instanceof PHPFunctionParseNode || node instanceof PHPVariableParseNode || node instanceof PHPConstantNode) {
                    this.builtInClasses.put(String.valueOf(child.getNameNode().getName()) + '/' + node.getNameNode().getName(), url.toString().intern());
                }
                ++n2;
            }
        } else if (child instanceof PHPConstantNode || child.getNodeType() == 4505 || child.getNodeType() == 4503) {
            this.addAsKeyword(child, url);
        }
    }

    private void addAsKeyword(IParseNode child, URL url) {
        String parentName;
        PHPBaseParseNode phpChild = (PHPBaseParseNode)child;
        IPHPDocBlock documentation = phpChild.getDocumentation();
        if (documentation == null || "".equals(documentation.getShortDescription())) {
            documentation = new PHPDocBlockImp(MessageFormat.format(Messages.PREDEFINED_CONSTANT_LABEL, child.getNameNode().getName()), "", NO_TAGS, 0);
        }
        short type = child.getNodeType() == 4505 ? (short)4505 : 4503;
        PHPBaseParseNode node = new PHPBaseParseNode(type, phpChild.getModifiers(), child.getStartingOffset(), child.getEndingOffset(), phpChild.getNameNode().getName());
        node.setDocumentation(documentation);
        this.builtins.add(node);
        String string = parentName = child.getParent() != null ? child.getParent().getNameNode().getName() : "";
        if (parentName == null) {
            parentName = "";
        } else if (parentName.length() > 0) {
            parentName = String.valueOf(parentName) + '/';
        }
        this.builtInConstants.put(String.valueOf(parentName) + child.getNameNode().getName(), url.toString().intern());
    }

    private static URL[] getBuiltinsURLs(String libraryPath) {
        ArrayList<URL> urls = new ArrayList<URL>();
        PHPEplPlugin plugin = PHPEplPlugin.getDefault();
        if (plugin != null) {
            try {
                Enumeration entries = plugin.getBundle().findEntries(libraryPath, "*.php", true);
                while (entries.hasMoreElements()) {
                    urls.add((URL)entries.nextElement());
                }
                return urls.toArray(new URL[urls.size()]);
            }
            catch (IllegalStateException illegalStateException) {}
        }
        return new URL[0];
    }

    private static File getFile(URL url) throws IOException {
        String path;
        if ("file".equals(url.getProtocol())) {
            return new File(url.getPath());
        }
        if ("jar".equals(url.getProtocol()) && (path = url.getPath()).startsWith("file:")) {
            path = path.substring(5, path.length() - 2);
            return new File(path);
        }
        throw new IOException("Unknown protocol");
    }

    private PHPBuiltins() {
        this.initNames();
    }

    public static PHPBuiltins getInstance() {
        return instance;
    }

    public synchronized void clean(IProgressMonitor monitor) {
        long start = System.currentTimeMillis();
        this.initializing = true;
        this.initNames();
        this.builtInFunctions = new HashMap<String, String>();
        this.builtInClasses = new HashMap<String, String>();
        this.builtInConstants = new HashMap<String, String>();
        if (monitor == null) {
            this.initializing = false;
            throw new IllegalArgumentException("The progress monitor should not be null");
        }
        if (this.builtins == null) {
            this.initBuiltins(monitor);
        }
        this.initializing = false;
        IdeLog.logInfo((Plugin)PHPEditorPlugin.getDefault(), (String)("Built-ins clean: " + (System.currentTimeMillis() - start) + "ms"), null, (String)"com.aptana.editor.php/debug/indexer");
    }

    private void initNames() {
        this.phpNames = new HashMap<PHPVersion, Set<String>>();
        for (PHPVersion version : EnumSet.allOf(PHPVersion.class)) {
            this.phpNames.put(version, new HashSet());
        }
    }

    public synchronized boolean isInitializing() {
        return this.initializing;
    }
}

