/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.model.impl;

import com.aptana.editor.php.core.model.IModelElement;
import com.aptana.editor.php.internal.core.builder.IBuildPath;
import com.aptana.editor.php.internal.core.builder.IBuildPathResource;
import com.aptana.editor.php.internal.core.builder.IDirectory;
import com.aptana.editor.php.internal.core.builder.IModule;
import com.aptana.editor.php.internal.model.ISourceFolder;
import com.aptana.editor.php.internal.model.impl.AbstractResourceElement;
import com.aptana.editor.php.internal.model.impl.SourceModule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SourceFolder
extends AbstractResourceElement
implements ISourceFolder {
    public SourceFolder(IDirectory directory) {
        super((IBuildPathResource)directory);
    }

    public int getElementType() {
        return 4;
    }

    public List<IModelElement> getChildren() {
        IBuildPath buildPath = this.getBPResource().getBuildPath();
        if (buildPath == null) {
            return Collections.emptyList();
        }
        List subdirectories = buildPath.getSubdirectoriesByPath(this.getBPResource().getPath());
        List modules = buildPath.getModulesByPath(this.getBPResource().getPath());
        ArrayList<IModelElement> result = new ArrayList<IModelElement>();
        if (subdirectories != null) {
            for (IDirectory subdirectory : subdirectories) {
                SourceFolder folder = new SourceFolder(subdirectory);
                result.add(folder);
            }
        }
        if (modules != null) {
            for (IModule module : modules) {
                SourceModule mdl = new SourceModule(module);
                result.add(mdl);
            }
        }
        return result;
    }

    public boolean hasChildren() {
        IBuildPath buildPath = this.getBPResource().getBuildPath();
        if (buildPath == null) {
            return false;
        }
        List subdirectories = buildPath.getSubdirectoriesByPath(this.getBPResource().getPath());
        List modules = buildPath.getModulesByPath(this.getBPResource().getPath());
        if (subdirectories != null && subdirectories.size() > 0) {
            return true;
        }
        return modules != null && modules.size() > 0;
    }

    protected IDirectory getDirectory() {
        return (IDirectory)this.getBPResource();
    }
}

