/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.model.impl;

import com.aptana.editor.php.core.model.IModelElement;
import com.aptana.editor.php.core.model.ISourceProject;
import com.aptana.editor.php.internal.builder.ProjectBuildPath;
import com.aptana.editor.php.internal.core.builder.IDirectory;
import com.aptana.editor.php.internal.core.builder.IModule;
import com.aptana.editor.php.internal.model.ModelManager;
import com.aptana.editor.php.internal.model.impl.AbstractModelElement;
import com.aptana.editor.php.internal.model.impl.SourceFolder;
import com.aptana.editor.php.internal.model.impl.SourceModule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class SourceProject
extends AbstractModelElement
implements ISourceProject {
    private ProjectBuildPath buildPath;

    public SourceProject(ProjectBuildPath buildPath) {
        this.buildPath = buildPath;
    }

    public IProject getProject() {
        return this.buildPath.getProject();
    }

    public boolean exists() {
        return this.buildPath.getProject().exists();
    }

    public String getElementName() {
        return this.buildPath.getProject().getName();
    }

    public int getElementType() {
        return 2;
    }

    public IModelElement getParent() {
        return ModelManager.getInstance().getModel();
    }

    public List<IModelElement> getChildren() {
        try {
            IResource[] members = this.buildPath.getProject().members();
            ArrayList<IModelElement> result = new ArrayList<IModelElement>();
            IResource[] iResourceArray = members;
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IDirectory dir;
                IResource member = iResourceArray[n2];
                if (member instanceof IFile) {
                    IModule module = this.buildPath.getModule(member);
                    if (module != null) {
                        result.add(new SourceModule(module));
                    }
                } else if (member instanceof IFolder && (dir = this.buildPath.getDirectory(member)) != null) {
                    result.add(new SourceFolder(dir));
                }
                ++n2;
            }
            return result;
        }
        catch (CoreException coreException) {
            return Collections.emptyList();
        }
    }

    public boolean hasChildren() {
        try {
            return this.buildPath.getProject().members().length != 0;
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.buildPath == null ? 0 : this.buildPath.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SourceProject other = (SourceProject)obj;
        return !(this.buildPath == null ? other.buildPath != null : !this.buildPath.equals(other.buildPath));
    }

    @Override
    public ISourceProject getSourceProject() {
        return this;
    }
}

