/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.text.reconciler;

import com.aptana.core.build.ReconcileContext;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.php.core.PHPVersionProvider;
import com.aptana.editor.php.core.model.ISourceModule;
import com.aptana.editor.php.internal.core.builder.IModule;
import com.aptana.editor.php.internal.parser.PHPParseState;
import com.aptana.editor.php.internal.ui.editor.PHPSourceEditor;
import com.aptana.parsing.IParseState;
import com.aptana.parsing.ParseResult;
import com.aptana.parsing.ast.IParseRootNode;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org2.eclipse.php.internal.core.PHPVersion;

public class PHPReconcileContext
extends ReconcileContext {
    private PHPSourceEditor editor;

    public PHPReconcileContext(AbstractThemeableEditor editor, IFile file, String contents) {
        super(editor.getContentType(), file, contents);
        if (editor instanceof PHPSourceEditor) {
            this.editor = (PHPSourceEditor)editor;
        }
    }

    public IParseRootNode getAST() throws CoreException {
        IModule module = null;
        ISourceModule sourceModule = null;
        if (this.editor != null) {
            module = this.editor.getModule();
            sourceModule = this.editor.getSourceModule();
        }
        IFile file = this.getFile();
        PHPVersion phpVersion = null;
        if (file != null) {
            phpVersion = PHPVersionProvider.getPHPVersion(file.getProject());
        }
        PHPParseState parseState = new PHPParseState(this.getContents(), 0, phpVersion, module, sourceModule);
        return this.getAST(parseState).getRootNode();
    }

    public synchronized ParseResult getAST(IParseState parseState) throws CoreException {
        Assert.isTrue((boolean)(parseState instanceof PHPParseState));
        return super.getAST(parseState);
    }
}

