/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.ui.editor;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.CommonSourceViewerConfiguration;
import com.aptana.editor.common.text.reconciler.IFoldingComputer;
import com.aptana.editor.html.HTMLEditor;
import com.aptana.editor.php.Messages;
import com.aptana.editor.php.PHPEditorPlugin;
import com.aptana.editor.php.core.IPHPVersionListener;
import com.aptana.editor.php.core.PHPVersionProvider;
import com.aptana.editor.php.core.model.ISourceModule;
import com.aptana.editor.php.epl.PHPEplPlugin;
import com.aptana.editor.php.internal.builder.BuildPathManager;
import com.aptana.editor.php.internal.builder.FileSystemModule;
import com.aptana.editor.php.internal.builder.SingleFileBuildPath;
import com.aptana.editor.php.internal.contentAssist.mapping.PHPOffsetMapper;
import com.aptana.editor.php.internal.core.builder.IModule;
import com.aptana.editor.php.internal.core.model.ISourceModuleProviderEditor;
import com.aptana.editor.php.internal.model.utils.ModelUtils;
import com.aptana.editor.php.internal.parser.PHPParseState;
import com.aptana.editor.php.internal.parser.nodes.PHPExtendsNode;
import com.aptana.editor.php.internal.ui.actions.OpenDeclarationAction;
import com.aptana.editor.php.internal.ui.editor.OccurrencesUpdater;
import com.aptana.editor.php.internal.ui.editor.PHPDocumentProvider;
import com.aptana.editor.php.internal.ui.editor.PHPFoldingComputer;
import com.aptana.editor.php.internal.ui.editor.PHPSourceViewerConfiguration;
import com.aptana.editor.php.internal.ui.editor.outline.PHPDecoratingLabelProvider;
import com.aptana.editor.php.internal.ui.editor.outline.PHPOutlineItem;
import com.aptana.editor.php.internal.ui.editor.outline.PHTMLOutlineContentProvider;
import com.aptana.editor.php.util.EditorUtils;
import com.aptana.parsing.IParseState;
import com.aptana.parsing.ParserPoolFactory;
import com.aptana.parsing.ast.ILanguageNode;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org2.eclipse.php.internal.core.PHPVersion;

public class PHPSourceEditor
extends HTMLEditor
implements ILanguageNode,
IPHPVersionListener,
ISourceModuleProviderEditor {
    public static final String PHP_EDITOR_CONTEXT = "com.aptana.editor.php.editorContext";
    public static final String PHP_EDITOR_ID = "com.aptana.editor.php";
    private static final char[] PAIR_MATCHING_CHARS = new char[]{'(', ')', '{', '}', '[', ']', '`', '`', '\'', '\'', '\"', '\"'};
    private Object mutex = new Object();
    private IProject project;
    private PHPDocumentProvider documentProvider;
    private IModule module;
    private ISourceModule sourceModule;
    private boolean isOutOfWorkspace;
    private String sourceUri;
    private PHPOffsetMapper offsetMapper;
    private PHPVersion phpVersionCache;
    private OccurrencesUpdater occurrencesUpdater;

    static {
        EditorUtils.setOccurrenceColors();
    }

    protected void initializeEditor() {
        super.initializeEditor();
        this.module = null;
        this.sourceModule = null;
        this.isOutOfWorkspace = false;
        ChainedPreferenceStore store = new ChainedPreferenceStore(new IPreferenceStore[]{PHPEditorPlugin.getDefault().getPreferenceStore(), PHPEplPlugin.getDefault().getPreferenceStore(), CommonEditorPlugin.getDefault().getPreferenceStore(), EditorsPlugin.getDefault().getPreferenceStore()});
        this.setPreferenceStore((IPreferenceStore)store);
        this.setSourceViewerConfiguration((SourceViewerConfiguration)new PHPSourceViewerConfiguration(this.getPreferenceStore(), (AbstractThemeableEditor)this));
        this.documentProvider = PHPEditorPlugin.getDefault().getPHPDocumentProvider();
        this.setDocumentProvider((IDocumentProvider)this.documentProvider);
    }

    public IFoldingComputer createFoldingComputer(IDocument document) {
        return new PHPFoldingComputer((AbstractThemeableEditor)this, document);
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        contextService.activateContext(PHP_EDITOR_CONTEXT);
    }

    public String getContentType() {
        return "com.aptana.contenttype.php";
    }

    public IParseRootNode getAST() {
        try {
            PHPParseState phpParseState = new PHPParseState(this.getDocument().get(), 0, this.phpVersionCache, this.getModule(), this.getSourceModule());
            return ParserPoolFactory.parse((String)this.getContentType(), (IParseState)phpParseState).getRootNode();
        }
        catch (Exception e) {
            IdeLog.logTrace((Plugin)PHPEditorPlugin.getDefault(), (String)"Failed to parse PHP editor contents", (Throwable)e, (String)"com.aptana.parsing/debug/parsing");
            return null;
        }
    }

    protected void installOccurrencesUpdater() {
        this.occurrencesUpdater = new OccurrencesUpdater(this);
        this.occurrencesUpdater.initialize(this.getPreferenceStore());
    }

    protected void createActions() {
        super.createActions();
        OpenDeclarationAction action = new OpenDeclarationAction(Messages.getResourceBundle(), (ITextEditor)this);
        action.setActionDefinitionId("com.aptana.editor.php.openDeclaration");
        this.setAction("com.aptana.editor.php.openDeclaration", (IAction)action);
    }

    protected void handleCursorPositionChanged() {
        super.handleCursorPositionChanged();
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        boolean shouldRefresh;
        super.doSetInput(input);
        IResource resource = (IResource)input.getAdapter(IResource.class);
        PHPVersionProvider phpVersionProvider = PHPVersionProvider.getInstance();
        boolean bl = shouldRefresh = this.sourceUri != null;
        if (shouldRefresh) {
            this.module = null;
            this.sourceModule = null;
            this.project = null;
            this.sourceUri = null;
            phpVersionProvider.removePHPVersionListener(this);
            phpVersionProvider.removePHPVersionListener(this.documentProvider);
        }
        if (resource != null) {
            this.sourceUri = resource.getLocationURI().toString();
            this.project = resource.getProject();
            this.phpVersionCache = PHPVersionProvider.getPHPVersion(this.project);
            this.documentProvider.phpVersionChanged(this.phpVersionCache);
            phpVersionProvider.addPHPVersionListener(this.project, this.documentProvider);
            phpVersionProvider.addPHPVersionListener(this.project, this);
        } else {
            this.phpVersionCache = null;
            this.documentProvider.phpVersionChanged(null);
            if (input instanceof FileStoreEditorInput) {
                FileStoreEditorInput fsInput = (FileStoreEditorInput)input;
                this.sourceUri = fsInput.getURI().toString();
            }
        }
    }

    public void dispose() {
        PHPVersionProvider.getInstance().removePHPVersionListener(this);
        PHPVersionProvider.getInstance().removePHPVersionListener(this.documentProvider);
        if (this.occurrencesUpdater != null) {
            this.occurrencesUpdater.dispose();
        }
        super.dispose();
    }

    public ITreeContentProvider getOutlineContentProvider() {
        return new PHTMLOutlineContentProvider((AbstractThemeableEditor)this);
    }

    public ILabelProvider getOutlineLabelProvider() {
        return new PHPDecoratingLabelProvider();
    }

    public char[] getPairMatchingCharacters() {
        return PAIR_MATCHING_CHARS;
    }

    protected Object getOutlineElementAt(int caret) {
        if (this.hasOutlinePageCreated()) {
            IParseRootNode parseResult = this.getOutlinePage().getCurrentAst();
            if (parseResult != null) {
                IParseNode node = parseResult.getNodeAtOffset(caret);
                if (node instanceof PHPExtendsNode) {
                    node = node.getParent();
                }
                if (node != null) {
                    return new PHPOutlineItem(node.getNameNode().getNameRange(), node);
                }
            }
            return super.getOutlineElementAt(caret);
        }
        return null;
    }

    public String getLanguage() {
        return "com.aptana.contenttype.php";
    }

    @Override
    public void phpVersionChanged(PHPVersion newVersion) {
        this.phpVersionCache = newVersion;
        UIJob refreshJob = new UIJob("Refresh document"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                SourceViewerConfiguration svc = PHPSourceEditor.this.getSourceViewerConfiguration();
                if (svc instanceof CommonSourceViewerConfiguration) {
                    CommonSourceViewerConfiguration csvc = (CommonSourceViewerConfiguration)svc;
                    csvc.forceReconcile();
                }
                return Status.OK_STATUS;
            }
        };
        refreshJob.setSystem(true);
        refreshJob.schedule(500L);
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        IAction action = this.getAction("com.aptana.editor.php.openDeclaration");
        if (action != null) {
            menu.appendToGroup("group.open", action);
        }
    }

    public boolean isOutOfWorkspace() {
        return this.isOutOfWorkspace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PHPOffsetMapper getOffsetMapper() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.offsetMapper == null) {
                this.offsetMapper = new PHPOffsetMapper(this);
            }
        }
        return this.offsetMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISourceModule getSourceModule() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.sourceModule == null) {
                this.sourceModule = ModelUtils.convertModule(this.getModule());
            }
        }
        return this.sourceModule;
    }

    public String getEditorID() {
        return PHP_EDITOR_ID;
    }

    public boolean isActiveEditor() {
        IWorkbenchPartSite site = this.getSite();
        if (site == null) {
            return false;
        }
        IWorkbenchWindow window = site.getWorkbenchWindow();
        IPartService service = window.getPartService();
        IWorkbenchPart part = service.getActivePart();
        return part != null && part.equals(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IModule getModule() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.module != null) {
                return this.module;
            }
            return this.computeModule(this.sourceUri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IModule computeModule(String sourceURI) {
        Object object = this.mutex;
        synchronized (object) {
            URI uri;
            block20: {
                block19: {
                    block17: {
                        if (sourceURI != null) break block17;
                        IdeLog.logWarning((Plugin)PHPEditorPlugin.getDefault(), (String)"PHPSourceEditor::computeModule() - sourceUri was null. Returning null", (String)"com.aptana.editor.php/debug");
                        return null;
                    }
                    String struri = sourceURI;
                    uri = null;
                    try {
                        uri = new URI(struri);
                    }
                    catch (URISyntaxException e) {
                        try {
                            int fileNameStart = struri.lastIndexOf(47);
                            if (fileNameStart > -1 && fileNameStart < struri.length() - 1) {
                                String fileName = struri.substring(fileNameStart + 1);
                                String encoded = URLEncoder.encode(fileName, "UTF-8");
                                uri = new URI(String.valueOf(struri.substring(0, fileNameStart + 1)) + encoded);
                            }
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                        }
                        catch (URISyntaxException uRISyntaxException) {}
                        if (uri != null) break block19;
                        IdeLog.logError((Plugin)PHPEditorPlugin.getDefault(), (String)"PHPSourceEditor::computeModule() - malformed URI", (Throwable)e);
                        return null;
                    }
                }
                if (uri.isAbsolute()) break block20;
                return null;
            }
            IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(uri);
            if (files == null || files.length == 0) {
                return this.createSystemFileModule(uri, false);
            }
            this.isOutOfWorkspace = false;
            if (this.module == null) {
                try {
                    if (files[0].getProject().getNature("com.aptana.editor.php.phpNature") == null) {
                        return this.createSystemFileModule(uri, true);
                    }
                }
                catch (CoreException e) {
                    IdeLog.logWarning((Plugin)PHPEditorPlugin.getDefault(), (String)"PHP Source Editor error in computing module(computeModule)", (Throwable)e, (String)"com.aptana.editor.php/debug");
                }
            }
            this.module = BuildPathManager.getInstance().getModuleByResource(files[0]);
            return this.module;
        }
    }

    protected IProgressMonitor getProgressMonitor() {
        return super.getProgressMonitor();
    }

    private IModule createSystemFileModule(URI uri, boolean isInWorkspace) {
        File file = new File(uri.getPath());
        FileSystemModule fileSystemModule = new FileSystemModule(file, new SingleFileBuildPath(file), isInWorkspace);
        this.isOutOfWorkspace = true;
        this.module = fileSystemModule;
        this.sourceModule = null;
        return fileSystemModule;
    }

    protected IPreferenceStore getPluginPreferenceStore() {
        return PHPEplPlugin.getDefault().getPreferenceStore();
    }
}

