/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.ui.editor.formatting;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.php.PHPEditorPlugin;
import com.aptana.editor.php.internal.ui.editor.PHPSourceViewerConfiguration;
import com.aptana.editor.php.internal.ui.editor.formatting.AbstractPHPAutoEditStrategy;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.source.ISourceViewer;

public class BlockEndingSyntaxAutoEditStrategy
extends AbstractPHPAutoEditStrategy {
    private Map<Character, List<String>> suffixToIncompleteWords;
    private StringBuilder buffer = new StringBuilder();
    private Map<String, Set<String>> sameIndentMatch;

    public BlockEndingSyntaxAutoEditStrategy(String contentType, PHPSourceViewerConfiguration configuration, ISourceViewer sourceViewer) {
        super(contentType, configuration, sourceViewer);
        this.suffixToIncompleteWords = new HashMap<Character, List<String>>();
        this.suffixToIncompleteWords.put(Character.valueOf('f'), Arrays.asList("endi", "elsei"));
        this.suffixToIncompleteWords.put(Character.valueOf('e'), Arrays.asList("endwhil", "els"));
        this.suffixToIncompleteWords.put(Character.valueOf('r'), Arrays.asList("endfo"));
        this.suffixToIncompleteWords.put(Character.valueOf('h'), Arrays.asList("endforeac", "endswitc"));
        this.sameIndentMatch = new HashMap<String, Set<String>>();
        this.sameIndentMatch.put("endif", new HashSet<String>(Arrays.asList("PHP_IF", "PHP_ELSE", "PHP_ELSEIF")));
        this.sameIndentMatch.put("else", new HashSet<String>(Arrays.asList("PHP_IF", "PHP_ELSEIF")));
        this.sameIndentMatch.put("elseif", new HashSet<String>(Arrays.asList("PHP_IF", "PHP_ELSEIF")));
        this.sameIndentMatch.put("endwhile", new HashSet<String>(Arrays.asList("PHP_WHILE")));
        this.sameIndentMatch.put("endfor", new HashSet<String>(Arrays.asList("PHP_FOR")));
        this.sameIndentMatch.put("endforeach", new HashSet<String>(Arrays.asList("PHP_FOREACH")));
        this.sameIndentMatch.put("endswitch", new HashSet<String>(Arrays.asList("PHP_SWITCH")));
    }

    @Override
    protected boolean isValidAutoInsertLocation(IDocument document, DocumentCommand command) {
        if (command.text == null || command.text.length() == 0) {
            return false;
        }
        return this.suffixToIncompleteWords.containsKey(Character.valueOf(command.text.charAt(command.text.length() - 1)));
    }

    @Override
    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        try {
            char lastChar = command.text.charAt(command.text.length() - 1);
            List<String> incompleteWords = this.suffixToIncompleteWords.get(Character.valueOf(lastChar));
            String incompleteWord = null;
            String completeWord = null;
            for (String word : incompleteWords) {
                incompleteWord = word;
                int length = incompleteWord.length();
                if (command.offset < length + 1 || !document.get(command.offset - length, length).equals(incompleteWord)) continue;
                completeWord = String.valueOf(incompleteWord) + lastChar;
            }
            if (completeWord == null) {
                return;
            }
            String type = document.getContentType(command.offset);
            if (!"__php__dftl_partition_content_type".equals(type)) {
                return;
            }
            this.indentBlockEnding(completeWord, document, command);
        }
        catch (BadLocationException e) {
            IdeLog.logError((Plugin)PHPEditorPlugin.getDefault(), (String)"Error customizing a PHP block-ending command", (Throwable)e);
        }
    }

    private void indentBlockEnding(String completeWord, IDocument document, DocumentCommand command) throws BadLocationException {
        int startOffset = command.offset - completeWord.length() + 1;
        int lineNumber = document.getLineOfOffset(command.offset);
        IRegion lineInfo = document.getLineInformation(lineNumber);
        int lineOffset = lineInfo.getOffset();
        String startLine = document.get(lineOffset, startOffset - lineOffset);
        if (startLine.trim().length() == 0) {
            this.buffer.setLength(0);
            this.matchIndent(document, this.buffer, lineNumber, startOffset, this.sameIndentMatch.get(completeWord), Collections.EMPTY_SET);
            String bufferString = this.buffer.toString();
            if (!bufferString.equals(startLine)) {
                command.length += command.offset - lineOffset;
                command.offset = lineOffset;
                command.text = String.valueOf(bufferString) + completeWord;
            }
        }
    }
}

