/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.ui.editor.outline;

import com.aptana.core.util.StringUtil;
import com.aptana.editor.php.PHPEditorPlugin;
import com.aptana.editor.php.internal.indexer.AbstractPHPEntryValue;
import com.aptana.editor.php.internal.parser.nodes.PHPBaseParseNode;
import com.aptana.editor.php.internal.parser.nodes.PHPClassParseNode;
import com.aptana.editor.php.internal.parser.nodes.PHPConstantNode;
import com.aptana.editor.php.internal.parser.nodes.PHPFunctionParseNode;
import com.aptana.editor.php.internal.parser.nodes.PHPIncludeNode;
import com.aptana.editor.php.internal.parser.nodes.PHPNamespaceNode;
import com.aptana.editor.php.internal.parser.nodes.PHPVariableParseNode;
import com.aptana.editor.php.internal.ui.editor.outline.PHPOutlineItem;
import com.aptana.parsing.ast.INameNode;
import com.aptana.parsing.ast.IParseNode;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org2.eclipse.php.core.compiler.PHPFlags;

public class PHPOutlineLabelProvider
extends LabelProvider {
    public static final Image PROPERTY_ICON = PHPEditorPlugin.getImage("icons/full/obj16/php_property.png");
    public static final Image FUNCTION_ICON = PHPEditorPlugin.getImage("icons/full/obj16/php_function.png");
    public static final Image CLASS_ICON = PHPEditorPlugin.getImage("icons/full/obj16/php_class.png");
    public static final Image TRAIT_ICON = PHPEditorPlugin.getImage("icons/full/obj16/php_trait.png");
    public static final Image INTERFACE_ICON = PHPEditorPlugin.getImage("icons/full/obj16/php_interface.png");
    public static final Image PRIVATE_METHOD_ICON = PHPEditorPlugin.getImage("icons/full/obj16/methpri_obj.png");
    public static final Image PROTECTED_METHOD_ICON = PHPEditorPlugin.getImage("icons/full/obj16/methpro_obj.png");
    public static final Image PUBLIC_METHOD_ICON = PHPEditorPlugin.getImage("icons/full/obj16/methpub_obj.png");
    public static final Image PRIVATE_FIELD_ICON = PHPEditorPlugin.getImage("icons/full/obj16/field_private_obj.png");
    public static final Image PROTECTED_FIELD_ICON = PHPEditorPlugin.getImage("icons/full/obj16/field_protected_obj.png");
    public static final Image DEFAULT_FIELD_ICON = PHPEditorPlugin.getImage("icons/full/obj16/field_default_obj.png");
    public static final Image PUBLIC_FIELD_ICON = PHPEditorPlugin.getImage("icons/full/obj16/field_public_obj.png");
    public static final Image LOCALVARIABLE_ICON = PHPEditorPlugin.getImage("icons/full/obj16/localvariable_obj.png");
    public static final Image NAMESPACE_ICON = PHPEditorPlugin.getImage("icons/full/obj16/namespace_obj.png");
    public static final Image IMPORT_ICON = PHPEditorPlugin.getImage("icons/full/obj16/imp_obj.png");
    public static final Image BLOCK_ICON = PHPEditorPlugin.getImage("icons/full/obj16/php.gif");
    private static final String EMPTY_STRING = "";
    private static final PHPBaseParseNode classParseNodeTemplate = new PHPClassParseNode(0, 0, 0, "");
    private static final PHPBaseParseNode constantParseNodeTemplate = new PHPConstantNode(0, 0, "");
    private static final PHPBaseParseNode functionParseNodeTemplate = new PHPFunctionParseNode(0, 0, 0, "");
    private static final PHPBaseParseNode namespaceParseNodeTemplate = new PHPNamespaceNode(0, 0, "", "");
    private static final PHPBaseParseNode includeParseNodeTemplate = new PHPIncludeNode(0, 0, "", "");
    private static final PHPBaseParseNode variableParseNodeTemplate = new PHPVariableParseNode(0, 0, 0, "", true);

    public String getText(Object element) {
        PHPBaseParseNode parseNode = this.getParseNode(element);
        if (parseNode != null) {
            INameNode nameNode = parseNode.getNameNode();
            String name = nameNode.getName();
            if (StringUtil.isEmpty((String)name)) {
                return parseNode.getNodeName();
            }
            return name;
        }
        return super.getText(element);
    }

    public Image getImage(Object element) {
        Image result;
        PHPBaseParseNode parseNode = this.getParseNode(element);
        if (parseNode != null) {
            int modifiers = parseNode.getModifiers();
            switch (parseNode.getNodeType()) {
                case 4504: 
                case 4505: {
                    return BLOCK_ICON;
                }
                case 4506: 
                case 4507: {
                    return IMPORT_ICON;
                }
                case 4502: {
                    result = this.getVariableNodeImage(parseNode, modifiers);
                    break;
                }
                case 4501: {
                    result = this.getFunctionNodeImage(parseNode, modifiers);
                    break;
                }
                case 4508: {
                    result = NAMESPACE_ICON;
                    break;
                }
                case 4500: {
                    result = this.getClassNodeImage(modifiers);
                    break;
                }
                case 4519: {
                    result = TRAIT_ICON;
                    break;
                }
                default: {
                    result = this.getDefaultImage(element);
                    break;
                }
            }
        } else {
            result = this.getDefaultImage(element);
        }
        return result;
    }

    private Image getDefaultImage(Object element) {
        return BLOCK_ICON;
    }

    private PHPBaseParseNode getParseNode(Object element) {
        if (element instanceof PHPOutlineItem) {
            IParseNode referenceNode = ((PHPOutlineItem)((Object)element)).getReferenceNode();
            return (PHPBaseParseNode)referenceNode;
        }
        if (element instanceof AbstractPHPEntryValue) {
            AbstractPHPEntryValue value = (AbstractPHPEntryValue)element;
            PHPBaseParseNode result = null;
            switch (value.getKind()) {
                case 1: {
                    result = classParseNodeTemplate;
                    break;
                }
                case 4: {
                    result = constantParseNodeTemplate;
                    break;
                }
                case 2: {
                    result = functionParseNodeTemplate;
                    break;
                }
                case 5: {
                    result = includeParseNodeTemplate;
                    break;
                }
                case 6: {
                    result = namespaceParseNodeTemplate;
                    break;
                }
                case 3: {
                    result = variableParseNodeTemplate;
                }
            }
            if (result != null) {
                result.setModifiers(value.getModifiers());
                return result;
            }
        }
        return null;
    }

    private Image getVariableNodeImage(PHPBaseParseNode parseNode, int modifiers) {
        Image result = PROPERTY_ICON;
        PHPVariableParseNode fn = (PHPVariableParseNode)parseNode;
        if (fn.isParameter() || fn.isLocalVariable()) {
            return LOCALVARIABLE_ICON;
        }
        if (fn.isField()) {
            result = PHPFlags.isPublic((int)modifiers) ? PUBLIC_FIELD_ICON : (PHPFlags.isProtected((int)modifiers) ? PROTECTED_FIELD_ICON : (PHPFlags.isPrivate((int)modifiers) ? PRIVATE_FIELD_ICON : DEFAULT_FIELD_ICON));
        }
        return result;
    }

    private Image getClassNodeImage(int modifiers) {
        Image result = PHPFlags.isInterface((int)modifiers) ? INTERFACE_ICON : CLASS_ICON;
        return result;
    }

    private Image getFunctionNodeImage(PHPBaseParseNode parseNode, int modifiers) {
        PHPFunctionParseNode fn = (PHPFunctionParseNode)parseNode;
        Image result = FUNCTION_ICON;
        if (fn.isMethod()) {
            result = PHPFlags.isPublic((int)modifiers) ? PUBLIC_METHOD_ICON : (PHPFlags.isProtected((int)modifiers) ? PROTECTED_METHOD_ICON : (PHPFlags.isPrivate((int)modifiers) ? PRIVATE_METHOD_ICON : PUBLIC_METHOD_ICON));
        }
        return result;
    }
}

