/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.ui.editor.scanner.tokenMap;

import com.aptana.editor.php.internal.indexer.language.PHPBuiltins;
import com.aptana.editor.php.internal.parser.PHPTokenType;
import com.aptana.editor.php.internal.ui.editor.scanner.PHPCodeScanner;
import com.aptana.editor.php.internal.ui.editor.scanner.tokenMap.IPHPTokenMapper;
import com.aptana.editor.php.internal.ui.editor.scanner.tokenMap.PHPTokenMapperFactory;
import java_cup.runtime.Symbol;
import org.eclipse.jface.text.rules.IToken;
import org2.eclipse.php.internal.core.ast.scanner.php4.ParserConstants;

public class PHP4TokenMapper
implements IPHPTokenMapper,
ParserConstants {
    @Override
    public IToken mapToken(Symbol sym, PHPCodeScanner scanner) {
        switch (sym.sym) {
            case 15: 
            case 62: {
                return scanner.getToken(PHPTokenType.SUPPORT_FUNCTION_CONSTRUCT);
            }
            case 59: {
                return scanner.getToken(PHPTokenType.SUPPORT_FUNCTION_BUILTIN);
            }
            case 23: 
            case 24: 
            case 36: 
            case 39: 
            case 40: 
            case 41: 
            case 46: 
            case 47: 
            case 52: 
            case 53: 
            case 69: 
            case 119: {
                return scanner.getToken(PHPTokenType.KEYWORD);
            }
            case 2: 
            case 3: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 35: 
            case 120: 
            case 121: 
            case 122: {
                return scanner.getToken(PHPTokenType.KEYWORD_CONTROL);
            }
            case 123: {
                return scanner.getToken(PHPTokenType.STORAGE_MODIFIER_STATIC);
            }
            case 32: {
                return scanner.getToken(PHPTokenType.STORAGE_TYPE_FUNCTION);
            }
            case 42: {
                return scanner.getToken(PHPTokenType.STORAGE_TYPE_CLASS);
            }
            case 37: 
            case 38: {
                return scanner.getToken(PHPTokenType.STORAGE_TYPE);
            }
            case 43: {
                return scanner.getToken(PHPTokenType.KEYWORD_OTHER_CLASS);
            }
            case 60: 
            case 61: 
            case 63: 
            case 64: {
                return scanner.getToken(PHPTokenType.KEYWORD_CONTROL_IMPORT);
            }
            case 44: {
                return scanner.getToken(PHPTokenType.KEYWORD_OP_CLASS);
            }
            case 57: {
                return scanner.getToken(PHPTokenType.META_FUNCTION_CALL_STATIC);
            }
            case 25: 
            case 66: 
            case 67: 
            case 68: 
            case 116: {
                return scanner.getToken(PHPTokenType.KEYWORD_OP_LOGICAL);
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                return scanner.getToken(PHPTokenType.CONSTANT_LANGUAGE);
            }
            case 8: {
                String value = scanner.getSymbolValue(sym);
                if ("$this".equals(value)) {
                    return scanner.getToken(PHPTokenType.VARIABLE_LANGUAGE);
                }
                if (PHPTokenMapperFactory.GLOBALS.contains(value)) {
                    return scanner.getToken(PHPTokenType.VARIABLE_OTHER_GLOBAL);
                }
                if (PHPTokenMapperFactory.SAFER_GLOBALS.contains(value)) {
                    return scanner.getToken(PHPTokenType.VARIABLE_OTHER_GLOBAL_SAFER);
                }
                return scanner.getToken(PHPTokenType.VARIABLE_OTHER);
            }
            case 34: {
                return scanner.getToken(PHPTokenType.CONSTANT);
            }
            case 4: 
            case 5: {
                return scanner.getToken(PHPTokenType.CONSTANT_NUMERIC);
            }
            case 14: {
                return scanner.getToken(PHPTokenType.STRING_QUOTED);
            }
            case 6: {
                String tokenContent = scanner.getSymbolValue(sym);
                if ("self".equals(tokenContent) || "parent".equals(tokenContent)) {
                    return scanner.getToken(PHPTokenType.VARIABLE_LANGUAGE);
                }
                if ("true".equalsIgnoreCase(tokenContent) || "false".equalsIgnoreCase(tokenContent) || "null".equalsIgnoreCase(tokenContent) || "on".equalsIgnoreCase(tokenContent) || "off".equalsIgnoreCase(tokenContent) || "yes".equalsIgnoreCase(tokenContent) || "no".equalsIgnoreCase(tokenContent) || "nl".equalsIgnoreCase(tokenContent) || "br".equalsIgnoreCase(tokenContent) || "tab".equalsIgnoreCase(tokenContent)) {
                    return scanner.getToken(PHPTokenType.CONSTANT_LANGUAGE_OTHER);
                }
                PHPBuiltins builtins = PHPBuiltins.getInstance();
                if (builtins == null) break;
                if (builtins.isBuiltinFunction(tokenContent)) {
                    return scanner.getToken(PHPTokenType.SUPPORT_FUNCTION);
                }
                if (builtins.isBuiltinClass(tokenContent)) {
                    return scanner.getToken(PHPTokenType.SUPPORT_CLASS);
                }
                if (!builtins.isBuiltinConstant(tokenContent)) break;
                return scanner.getToken(PHPTokenType.SUPPORT_CONSTANT);
            }
        }
        return PHPTokenMapperFactory.mapDefaultToken(scanner, sym);
    }
}

