/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.ui.preferences;

import com.aptana.editor.php.internal.builder.IPHPLibrary;
import com.aptana.editor.php.internal.builder.UserLibrary;
import com.aptana.editor.php.internal.ui.preferences.Messages;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class PHPLibraryDialog
extends TitleAreaDialog {
    private Image titleImage;
    private Text nameText;
    private TableViewer viewer;
    private UserLibrary library;
    private IPHPLibrary[] existing;

    public PHPLibraryDialog(Shell parentShell, UserLibrary library, IPHPLibrary[] existing) {
        super(parentShell);
        this.library = library;
        this.existing = existing;
        this.titleImage = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.aptana.editor.php.epl", (String)"/icons/full/wizban/addlibrary_wiz.png").createImage();
    }

    protected Control createDialogArea(Composite parent) {
        Composite body = new Composite(parent, 0);
        body.setLayout((Layout)new GridLayout(2, false));
        body.setLayoutData((Object)new GridData(1808));
        Label label = new Label(body, 0);
        label.setText(Messages.PHPLibraryDialog_libraryName);
        this.nameText = new Text(body, 2048);
        this.nameText.setLayoutData((Object)new GridData(768));
        if (this.library != null) {
            this.nameText.setText(this.library.getName());
        }
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PHPLibraryDialog.this.validate();
            }
        });
        Group pComp = new Group(body, 0);
        pComp.setText(Messages.PHPLibraryDialog_libraryContent);
        pComp.setLayout((Layout)new GridLayout(2, false));
        GridData layoutData = new GridData(1808);
        layoutData.horizontalSpan = 2;
        layoutData.minimumHeight = 200;
        pComp.setLayoutData((Object)layoutData);
        this.viewer = new TableViewer((Composite)pComp, 2048);
        this.viewer.setComparator(new ViewerComparator());
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return element.toString();
            }

            public Image getImage(Object element) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
            }
        });
        Composite buttons = new Composite((Composite)pComp, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        if (this.library != null) {
            this.viewer.setInput((Object)this.library.getDirectories().toArray());
        } else {
            this.viewer.setInput((Object)new String[0]);
        }
        buttons.setLayout((Layout)layout);
        Button add = new Button(buttons, 0);
        add.setText(Messages.PHPLibraryDialog_addFolder);
        add.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog directoryDialog = new DirectoryDialog(Display.getCurrent().getActiveShell());
                directoryDialog.setText(Messages.PHPLibraryDialog_selectFolder);
                String open = directoryDialog.open();
                PHPLibraryDialog.this.viewer.add((Object)open);
            }
        });
        add.setLayoutData((Object)new GridData(768));
        Button remove = new Button(buttons, 0);
        remove.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)PHPLibraryDialog.this.viewer.getSelection();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    PHPLibraryDialog.this.viewer.remove(o);
                    ++n2;
                }
            }
        });
        remove.setText(Messages.PHPLibraryDialog_removeSelected);
        remove.setLayoutData((Object)new GridData(768));
        buttons.setLayoutData((Object)new GridData(1040));
        this.viewer.getControl().setLayoutData((Object)new GridData(1808));
        Control createDialogArea = super.createDialogArea(parent);
        this.setMessage(Messages.PHPLibraryDialog_libraryConfigureMessage);
        this.setTitleImage(this.titleImage);
        this.setTitle(Messages.PHPLibraryDialog_libraryConfigureTitle);
        buttons.setLayoutData((Object)new GridData(1040));
        return createDialogArea;
    }

    protected Control createButtonBar(Composite parent) {
        Control createButtonBar = super.createButtonBar(parent);
        this.validate();
        return createButtonBar;
    }

    protected void validate() {
        String text = this.nameText.getText().trim();
        Button button = this.getButton(0);
        if (text.length() == 0) {
            this.setErrorMessage(Messages.PHPLibraryDialog_emptyLibraryNameError);
            button.setEnabled(false);
            return;
        }
        IPHPLibrary[] iPHPLibraryArray = this.existing;
        int n = this.existing.length;
        int n2 = 0;
        while (n2 < n) {
            IPHPLibrary l = iPHPLibraryArray[n2];
            if (l != this.library && l.getId().equals(text)) {
                this.setErrorMessage(Messages.PHPLibraryDialog_uniqueLibraryNameError);
                button.setEnabled(false);
                return;
            }
            ++n2;
        }
        this.setErrorMessage(null);
        button.setEnabled(true);
    }

    public boolean close() {
        String[] dirs = new String[this.viewer.getTable().getItemCount()];
        int a = 0;
        while (a < dirs.length) {
            dirs[a] = (String)this.viewer.getElementAt(a);
            ++a;
        }
        this.library = new UserLibrary(this.nameText.getText(), dirs);
        boolean close = super.close();
        this.titleImage.dispose();
        return close;
    }

    public UserLibrary getResult() {
        return this.library;
    }
}

