/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.ui.preferences;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.php.PHPEditorPlugin;
import com.aptana.editor.php.internal.ui.preferences.Messages;
import com.aptana.editor.php.internal.ui.preferences.PHPCoreOptionsConfigurationBlock;
import com.aptana.editor.php.ui.preferences.IStatusChangeListener;
import com.aptana.editor.php.util.Key;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org2.eclipse.php.internal.core.PHPVersion;
import org2.eclipse.php.util.StatusInfo;

public class PHPVersionConfigurationBlock
extends PHPCoreOptionsConfigurationBlock {
    public static final List<String> PHP_ALIASES = Arrays.asList(PHPVersion.PHP4.getAlias(), PHPVersion.PHP5.getAlias(), PHPVersion.PHP5_3.getAlias(), PHPVersion.PHP5_4.getAlias());
    public static final List<String> PHP_VERSION_NAMES = Arrays.asList(Messages.PHPDevelopmentPage_php4, Messages.PHPDevelopmentPage_php5, Messages.PHPDevelopmentPage_php53, Messages.PHPDevelopmentPage_php54);
    private static final Key PREF_PHP_VERSION = PHPVersionConfigurationBlock.getPHPCoreKey("phpVersion");
    private Combo fPHPVersions;

    public PHPVersionConfigurationBlock(IStatusChangeListener context, IProject project, IWorkbenchPreferenceContainer container) {
        super(context, project, PHPVersionConfigurationBlock.getKeys(), container);
    }

    public void setEnabled(boolean isEnabled) {
        this.fPHPVersions.setEnabled(isEnabled);
    }

    private static Key[] getKeys() {
        return new Key[]{PREF_PHP_VERSION};
    }

    @Override
    public Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        this.createVersionContent(composite);
        this.unpackPHPVersion();
        this.validateSettings(null, null, null);
        return composite;
    }

    private Composite createVersionContent(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        Group group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(768));
        group.setText(Messages.PHPDevelopmentPage_compatibility);
        Label label = new Label((Composite)group, 0);
        label.setText(Messages.PHPDevelopmentPage_phpVersion);
        this.fPHPVersions = new Combo((Composite)group, 2060);
        this.initialize();
        this.fPHPVersions.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PHPVersionConfigurationBlock.this.setPhpVersion(PHPVersionConfigurationBlock.this.getSelectedVersion());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void initialize() {
        this.fPHPVersions.setItems(PHP_VERSION_NAMES.toArray(new String[PHP_VERSION_NAMES.size()]));
    }

    private String getSelectedVersion() {
        String selectedVersion = this.fPHPVersions.getText();
        int index = PHP_VERSION_NAMES.indexOf(selectedVersion);
        String selectedAlias = PHP_ALIASES.get(index);
        return selectedAlias;
    }

    private void selectVersion(String phpAlias) {
        int index = PHP_ALIASES.indexOf(phpAlias);
        if (index < 0) {
            IdeLog.logWarning((Plugin)PHPEditorPlugin.getDefault(), (String)("Unresolved PHP version: " + phpAlias), (Throwable)new Exception("Unresolved PHP version"), (String)"com.aptana.editor.php/debug");
            index = 0;
        }
        this.fPHPVersions.select(index);
    }

    @Override
    protected void validateSettings(Key changedKey, String oldValue, String newValue) {
        this.fContext.statusChanged((IStatus)new StatusInfo());
    }

    private void setPhpVersion(String value) {
        this.setValue(PREF_PHP_VERSION, value);
        this.validateSettings(PREF_PHP_VERSION, null, null);
    }

    @Override
    protected String[] getFullBuildDialogStrings(boolean workspaceSettings) {
        String title = Messages.PHPVersionConfigurationBlock_needsbuild_title;
        String message = workspaceSettings ? Messages.PHPVersionConfigurationBlock_needsfullbuild_message : Messages.PHPVersionConfigurationBlock_needsprojectbuild_message;
        return new String[]{title, message};
    }

    protected void updateControls() {
        this.unpackPHPVersion();
    }

    public void useProjectSpecificSettings(boolean enable) {
        super.useProjectSpecificSettings(enable);
        if (this.fProject != null && this.fPHPVersions != null) {
            this.unpackPHPVersion();
        }
    }

    private void unpackPHPVersion() {
        String version = this.getValue(PREF_PHP_VERSION);
        this.selectVersion(version);
    }

    public String getPHPVersionValue() {
        return this.getValue(PREF_PHP_VERSION);
    }
}

