/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.ui.wizard;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.projects.templates.TemplateType;
import com.aptana.editor.php.PHPEditorPlugin;
import com.aptana.editor.php.internal.ui.wizard.Messages;
import com.aptana.editor.php.internal.ui.wizard.PHPWizardNewProjectCreationPage;
import com.aptana.projects.wizards.AbstractNewProjectWizard;
import com.aptana.projects.wizards.IWizardProjectCreationPage;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizard;

public class NewPHPProjectWizard
extends AbstractNewProjectWizard
implements IExecutableExtension {
    public static final String PHP_WIZARD_ID = "com.aptana.editor.php.NewPHPProjectWizard";
    private static final String PHP_PROJ_IMAGE_PATH = "/icons/full/wizban/new_project.png";
    private String selectedVersion;

    protected void initDialogSettings() {
        IDialogSettings workbenchSettings = PHPEditorPlugin.getDefault().getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection("BasicNewProjectResourceWizard");
        if (section == null) {
            section = workbenchSettings.addNewSection("BasicNewProjectResourceWizard");
        }
        this.setDialogSettings(section);
    }

    protected IWizardProjectCreationPage createMainPage() {
        PHPWizardNewProjectCreationPage mainPage = new PHPWizardNewProjectCreationPage("phpProjectPage", this.selectedTemplate);
        mainPage.setTitle(Messages.NewPHPProjectWizard_projectWizardTitle);
        mainPage.setDescription(Messages.NewPHPProjectWizard_projectWizardDescription);
        mainPage.setWizard((IWizard)this);
        mainPage.setPageComplete(false);
        return mainPage;
    }

    protected TemplateType[] getProjectTemplateTypes() {
        return new TemplateType[]{TemplateType.PHP};
    }

    protected void initializeDefaultPageImageDescriptor() {
        this.setDefaultPageImageDescriptor(PHPEditorPlugin.getImageDescriptor(PHP_PROJ_IMAGE_PATH));
    }

    protected String getProjectCreationDescription() {
        return Messages.NewPHPProjectWizard_projectWizardTitle;
    }

    public String getID() {
        return PHP_WIZARD_ID;
    }

    protected String[] getProjectNatures() {
        return new String[]{"com.aptana.editor.php.phpNature", "com.aptana.projects.webnature"};
    }

    protected String[] getProjectBuilders() {
        return new String[]{"com.aptana.editor.php.aptanaPhpBuilder", "com.aptana.ide.core.unifiedBuilder"};
    }

    public boolean performFinish() {
        PHPWizardNewProjectCreationPage pcp = (PHPWizardNewProjectCreationPage)this.mainPage;
        this.selectedVersion = pcp.getSelectedVersion();
        return super.performFinish();
    }

    protected IProject createNewProject(IProgressMonitor monitor) throws InvocationTargetException {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IProject project = super.createNewProject((IProgressMonitor)sub.newChild(90));
        this.setPhpLangOptions(project, (IProgressMonitor)sub.newChild(10));
        sub.done();
        return project;
    }

    protected void setPhpLangOptions(IProject project, IProgressMonitor monitor) {
        IEclipsePreferences preferences = new ProjectScope(project).getNode("com.aptana.editor.php");
        preferences.put("phpVersion", this.selectedVersion);
        try {
            preferences.flush();
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)PHPEditorPlugin.getDefault(), (String)"Error saving the project's PHP Version settings", (Throwable)e);
        }
    }

    protected String getProjectCreateEventName() {
        return "project.create.php";
    }
}

