/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.preview.ui.properties;

import com.aptana.core.CoreStrings;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.preview.PreviewPlugin;
import com.aptana.preview.ui.properties.Messages;
import com.aptana.ui.IPropertyDialog;
import com.aptana.ui.PropertyDialogsRegistry;
import com.aptana.ui.util.UIUtils;
import com.aptana.webserver.core.IServer;
import com.aptana.webserver.core.IServerType;
import com.aptana.webserver.core.WebServerCorePlugin;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.SameShellProvider;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.ListDialog;

public class PreviewSettingComposite
extends Composite
implements SelectionListener {
    private ComboViewer fServersCombo;
    private Button fEditButton;
    private Button fNewButton;
    private Set<Listener> fListeners;
    private IServer fSelectedServer;

    public PreviewSettingComposite(Composite parent) {
        super(parent, 0);
        this.setLayout((Layout)GridLayoutFactory.fillDefaults().spacing(5, 0).numColumns(3).create());
        this.fListeners = new LinkedHashSet<Listener>();
        this.fServersCombo = new ComboViewer((Composite)this, 12);
        this.fServersCombo.getControl().setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).create());
        this.fServersCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.fServersCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IServer) {
                    return ((IServer)element).getName();
                }
                return super.getText(element);
            }
        });
        this.fServersCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PreviewSettingComposite.this.updateStates();
                PreviewSettingComposite.this.firePreviewSettingModified();
            }
        });
        this.fEditButton = new Button((Composite)this, 8);
        this.fEditButton.setText(StringUtil.ellipsify((String)CoreStrings.EDIT));
        this.fEditButton.setLayoutData((Object)GridDataFactory.swtDefaults().hint(PreviewSettingComposite.getButtonWidthHint(this.fEditButton), -1).create());
        this.fEditButton.addSelectionListener((SelectionListener)this);
        this.fNewButton = new Button((Composite)this, 8);
        this.fNewButton.setText(StringUtil.ellipsify((String)CoreStrings.NEW));
        this.fNewButton.setLayoutData((Object)GridDataFactory.swtDefaults().hint(PreviewSettingComposite.getButtonWidthHint(this.fNewButton), -1).create());
        this.fNewButton.addSelectionListener((SelectionListener)this);
        this.updateServersContentJob();
    }

    public void addListener(Listener listener) {
        this.fListeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.fListeners.remove(listener);
    }

    public Control getServersCombo() {
        return this.fServersCombo.getControl();
    }

    public Control getEditButton() {
        return this.fEditButton;
    }

    public Control getNewButton() {
        return this.fNewButton;
    }

    public IServer getSelectedServer() {
        Object selection = ((IStructuredSelection)this.fServersCombo.getSelection()).getFirstElement();
        if (selection instanceof IServer) {
            return (IServer)selection;
        }
        return null;
    }

    public void setSelectedServer(IServer server) {
        this.fSelectedServer = server;
        if (this.fSelectedServer == null || this.fSelectedServer == PreviewSettingComposite.getBuiltInServer()) {
            this.fServersCombo.setSelection((ISelection)new StructuredSelection((Object)PreviewSettingComposite.getBuiltInServer()));
        } else {
            this.fServersCombo.setSelection((ISelection)new StructuredSelection((Object)this.fSelectedServer));
        }
        this.updateStates();
    }

    public void widgetSelected(SelectionEvent e) {
        Object source = e.getSource();
        if (source == this.fEditButton) {
            this.editSelectedServer();
        } else if (source == this.fNewButton) {
            this.createNewServer();
        }
        IServer server = this.getSelectedServer();
        if (this.fSelectedServer != server) {
            this.fSelectedServer = server;
            this.firePreviewSettingModified();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private void updateStates() {
        Object selectedElement = ((IStructuredSelection)this.fServersCombo.getSelection()).getFirstElement();
        this.fEditButton.setEnabled(selectedElement != PreviewSettingComposite.getBuiltInServer());
    }

    private void createNewServer() {
        Object[] result;
        ListDialog dialog = new ListDialog(this.getShell());
        dialog.setContentProvider((IStructuredContentProvider)ArrayContentProvider.getInstance());
        dialog.setLabelProvider((ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IServerType) {
                    return ((IServerType)element).getName();
                }
                return super.getText(element);
            }
        });
        dialog.setInput((Object)WebServerCorePlugin.getDefault().getServerManager().getServerTypes());
        dialog.setTitle(Messages.ProjectPreviewPropertyPage_ChooseServerType);
        if (dialog.open() == 0 && (result = dialog.getResult()) != null && result.length == 1) {
            String typeId = ((IServerType)result[0]).getId();
            try {
                IServer newConfiguration = WebServerCorePlugin.getDefault().getServerManager().createServer(typeId);
                if (newConfiguration != null && this.editServerConfiguration(newConfiguration)) {
                    WebServerCorePlugin.getDefault().getServerManager().add(newConfiguration);
                    this.updateServersContent(false);
                    this.fServersCombo.setSelection((ISelection)new StructuredSelection((Object)newConfiguration));
                    this.updateStates();
                }
            }
            catch (CoreException e) {
                PreviewPlugin.log(Messages.ProjectPreviewPropertyPage_ERR_FailToCreateServer, e);
            }
        }
    }

    private void editSelectedServer() {
        Object selection = ((IStructuredSelection)this.fServersCombo.getSelection()).getFirstElement();
        if (selection instanceof IServer && this.editServerConfiguration((IServer)selection)) {
            this.fServersCombo.refresh();
        }
    }

    private boolean editServerConfiguration(IServer serverConfiguration) {
        try {
            Dialog dialog = PropertyDialogsRegistry.getInstance().createPropertyDialog((Object)serverConfiguration, (IShellProvider)new SameShellProvider((Control)this.getShell()));
            if (dialog != null) {
                if (dialog instanceof IPropertyDialog) {
                    ((IPropertyDialog)dialog).setPropertySource((Object)serverConfiguration);
                }
                return dialog.open() == 0;
            }
        }
        catch (CoreException e) {
            UIUtils.showErrorMessage((String)Messages.ProjectPreviewPropertyPage_ERR_FailToOpenServerDialog, (Throwable)e);
        }
        return false;
    }

    private void firePreviewSettingModified() {
        Listener[] listeners;
        Listener[] listenerArray = listeners = this.fListeners.toArray(new Listener[this.fListeners.size()]);
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Listener listener = listenerArray[n2];
            listener.previewSettingModified();
            ++n2;
        }
    }

    private void updateServersContentJob() {
        Job job = new Job("Updating servers content..."){

            public IStatus run(IProgressMonitor monitor) {
                PreviewSettingComposite.this.updateServersContent(true);
                return Status.OK_STATUS;
            }
        };
        EclipseUtil.setSystemForJob((Job)job);
        job.schedule();
    }

    private void updateServersContent(boolean async) {
        final ArrayList<IServer> servers = new ArrayList<IServer>();
        servers.add(PreviewSettingComposite.getBuiltInServer());
        servers.addAll(WebServerCorePlugin.getDefault().getServerManager().getServers());
        Runnable runnable = new Runnable(){

            public void run() {
                if (!PreviewSettingComposite.this.isDisposed()) {
                    ISelection selection = PreviewSettingComposite.this.fServersCombo.getSelection();
                    PreviewSettingComposite.this.fServersCombo.setInput((Object)servers);
                    PreviewSettingComposite.this.fServersCombo.setSelection(selection);
                    if (PreviewSettingComposite.this.fServersCombo.getSelection().isEmpty()) {
                        PreviewSettingComposite.this.fServersCombo.setSelection((ISelection)new StructuredSelection(servers.get(0)));
                    }
                }
            }
        };
        if (async) {
            UIUtils.getDisplay().asyncExec(runnable);
        } else {
            UIUtils.getDisplay().syncExec(runnable);
        }
    }

    private static IServer getBuiltInServer() {
        return WebServerCorePlugin.getDefault().getBuiltinWebServer();
    }

    private static int getButtonWidthHint(Button button) {
        PixelConverter converter = new PixelConverter((Control)button);
        int widthHint = converter.convertHorizontalDLUsToPixels(61);
        return Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
    }

    public static interface Listener {
        public void previewSettingModified();
    }
}

