/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ui.io;

import com.aptana.core.io.vfs.IExtendedFileInfo;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.ProgressMonitorInterrupter;
import com.aptana.ide.ui.io.internal.FetchFileInfoJob;
import com.aptana.ide.ui.io.internal.FetchFileInfoStatus;
import java.net.URI;
import java.util.ArrayList;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.TreePath;

public final class FileSystemUtils {
    private FileSystemUtils() {
    }

    public static IFileInfo getFileInfo(Object object) {
        if (object instanceof IFileInfo) {
            return (IFileInfo)object;
        }
        if (object instanceof IAdaptable) {
            return (IFileInfo)((IAdaptable)object).getAdapter(IFileInfo.class);
        }
        return null;
    }

    public static IFileStore getFileStore(Object object) {
        if (object instanceof IFileStore) {
            return (IFileStore)object;
        }
        if (object instanceof IAdaptable) {
            return (IFileStore)((IAdaptable)object).getAdapter(IFileStore.class);
        }
        return null;
    }

    public static boolean isDirectory(Object object) {
        IFileInfo fileInfo = FileSystemUtils.getFileInfo(object);
        if (fileInfo != null) {
            return fileInfo.isDirectory();
        }
        return false;
    }

    public static boolean isSymlink(Object object) {
        IFileInfo fileInfo = FileSystemUtils.getFileInfo(object);
        if (fileInfo != null) {
            return fileInfo.getAttribute(32);
        }
        return false;
    }

    public static boolean isPrivate(Object object) {
        IFileInfo fileInfo = FileSystemUtils.getFileInfo(object);
        if (fileInfo != null && fileInfo instanceof IExtendedFileInfo) {
            return ((IExtendedFileInfo)fileInfo).getPermissions() == 0L;
        }
        return false;
    }

    public static URI getURI(Object object) {
        IFileStore fileStore = FileSystemUtils.getFileStore(object);
        if (fileStore != null) {
            return fileStore.toURI();
        }
        return null;
    }

    public static TreePath createTreePath(IFileStore fileStore) {
        ArrayList<IFileStore> list = new ArrayList<IFileStore>();
        while (fileStore != null) {
            list.add(0, fileStore);
            fileStore = fileStore.getParent();
        }
        return new TreePath(list.toArray());
    }

    public static IFileInfo fetchFileInfo(IFileStore fileStore, int options) throws OperationCanceledException {
        FetchFileInfoJob job = new FetchFileInfoJob(fileStore, options);
        job.setPriority(20);
        EclipseUtil.setSystemForJob((Job)job);
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException e) {
            return null;
        }
        IStatus result = job.getResult();
        if (result instanceof FetchFileInfoStatus) {
            return ((FetchFileInfoStatus)result).getFileInfo();
        }
        if (Status.CANCEL_STATUS.equals(result)) {
            return null;
        }
        return null;
    }

    public static IFileInfo[] childInfos(IFileStore fileStore, int options, IProgressMonitor monitor) throws CoreException {
        ProgressMonitorInterrupter interrupter = new ProgressMonitorInterrupter(monitor);
        try {
            IFileInfo[] iFileInfoArray = fileStore.childInfos(options, monitor);
            return iFileInfoArray;
        }
        finally {
            interrupter.dispose();
        }
    }
}

