/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ui.io;

import com.aptana.core.io.efs.SyncUtils;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.EclipseUtil;
import com.aptana.ide.core.io.ConnectionPointType;
import com.aptana.ide.core.io.CoreIOPlugin;
import com.aptana.ide.core.io.IConnectionPoint;
import com.aptana.ide.core.io.IConnectionPointCategory;
import com.aptana.ide.core.io.IConnectionPointManager;
import com.aptana.ide.core.io.events.ConnectionPointEvent;
import com.aptana.ide.core.io.events.IConnectionPointListener;
import com.aptana.ide.ui.io.ImageUtils;
import com.aptana.ide.ui.io.internal.UniformFileStoreEditorInput;
import com.aptana.ide.ui.io.navigator.FileSystemElementComparer;
import com.aptana.ide.ui.io.navigator.actions.Messages;
import com.aptana.ui.util.UIUtils;
import java.io.File;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.OpenResourceAction;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.resources.ProjectExplorer;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class IOUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.aptana.ui.io";
    private static IOUIPlugin plugin;
    private Map<IEditorInput, Job> saveRemoteJobs;
    private IConnectionPointListener connectionListener;
    private IEclipsePreferences.IPreferenceChangeListener themeChangeListener;
    private final IPartListener fPartListener = new IPartListener(){

        public void partActivated(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
            if (part instanceof ProjectExplorer) {
                IOUIPlugin.this.handleProjectExplorerListeners(part);
            } else if (part instanceof IEditorPart) {
                IOUIPlugin.this.attachSaveListener((IEditorPart)part);
            }
        }
    };
    private final IWindowListener fWindowListener = new IWindowListener(){

        public void windowActivated(IWorkbenchWindow window) {
        }

        public void windowClosed(IWorkbenchWindow window) {
            IPartService partService = window.getPartService();
            if (partService != null) {
                partService.removePartListener(IOUIPlugin.this.fPartListener);
            }
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void windowOpened(IWorkbenchWindow window) {
            IPartService partService = window.getPartService();
            if (partService != null) {
                partService.addPartListener(IOUIPlugin.this.fPartListener);
            }
        }
    };

    private void handleProjectExplorerListeners(IWorkbenchPart part) {
        CommonViewer viewer = ((ProjectExplorer)part).getCommonViewer();
        viewer.setComparer((IElementComparer)new FileSystemElementComparer());
        final Tree tree = viewer.getTree();
        viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Object element = selection.getFirstElement();
                if (selection.size() == 1 && element instanceof IResource && ((IResource)element).getType() == 4) {
                    OpenResourceAction openResourceAction = new OpenResourceAction((IShellProvider)PlatformUI.getWorkbench().getActiveWorkbenchWindow());
                    openResourceAction.selectionChanged((IStructuredSelection)event.getViewer().getSelection());
                    if (openResourceAction.isEnabled()) {
                        openResourceAction.run();
                    }
                }
            }
        });
        tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (tree.getItem(new Point(e.x, e.y)) == null) {
                    tree.deselectAll();
                    tree.notifyListeners(13, new Event());
                }
            }
        });
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        Job job = new Job(MessageFormat.format("Initializing {0} Plugin", PLUGIN_ID)){

            protected IStatus run(IProgressMonitor monitor) {
                IOUIPlugin.this.connectionListener = new IConnectionPointListener(){

                    public void connectionPointChanged(ConnectionPointEvent event) {
                        IConnectionPoint connection = event.getConnectionPoint();
                        IConnectionPointManager manager = CoreIOPlugin.getConnectionPointManager();
                        ConnectionPointType type = manager.getType(connection);
                        if (type == null) {
                            return;
                        }
                        switch (event.getKind()) {
                            case 1: {
                                IOUIPlugin.refreshNavigatorViewAndSelect(manager.getConnectionPointCategory(type.getCategory().getId()), connection);
                                break;
                            }
                            case 2: {
                                IOUIPlugin.refreshNavigatorView(manager.getConnectionPointCategory(type.getCategory().getId()));
                                break;
                            }
                            case 4: {
                                IOUIPlugin.refreshNavigatorView(connection);
                            }
                        }
                    }
                };
                CoreIOPlugin.getConnectionPointManager().addConnectionPointListener(IOUIPlugin.this.connectionListener);
                IOUIPlugin.this.themeChangeListener = new IEclipsePreferences.IPreferenceChangeListener(){

                    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                        if (event.getKey().equals("THEME_CHANGED")) {
                            ImageUtils.themeChanged();
                        }
                    }
                };
                InstanceScope.INSTANCE.getNode("com.aptana.theme").addPreferenceChangeListener(IOUIPlugin.this.themeChangeListener);
                IOUIPlugin.this.saveRemoteJobs = new HashMap();
                IOUIPlugin.this.addPartListener();
                return Status.OK_STATUS;
            }
        };
        EclipseUtil.setSystemForJob((Job)job);
        job.schedule();
    }

    public void stop(BundleContext context) throws Exception {
        if (this.connectionListener != null) {
            CoreIOPlugin.getConnectionPointManager().removeConnectionPointListener(this.connectionListener);
            this.connectionListener = null;
        }
        if (this.themeChangeListener != null) {
            InstanceScope.INSTANCE.getNode("com.aptana.theme").removePreferenceChangeListener(this.themeChangeListener);
            this.themeChangeListener = null;
        }
        this.removePartListener();
        if (this.saveRemoteJobs != null) {
            Collection<Job> jobs = this.saveRemoteJobs.values();
            for (Job job : jobs) {
                job.cancel();
            }
            this.saveRemoteJobs.clear();
            this.saveRemoteJobs = null;
        }
        plugin = null;
        super.stop(context);
    }

    public static IOUIPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static Image getImage(String path) {
        ImageRegistry registry = plugin.getImageRegistry();
        Image image = registry.get(path);
        if (image == null) {
            ImageDescriptor id = IOUIPlugin.getImageDescriptor(path);
            if (id == null) {
                return null;
            }
            registry.put(path, id);
            image = registry.get(path);
        }
        return image;
    }

    public static void refreshNavigatorView(Object element) {
        IOUIPlugin.refreshNavigatorViewAndSelect(element, null);
    }

    public static void refreshNavigatorViewAndSelect(final Object element, final Object selection) {
        UIUtils.getDisplay().asyncExec(new Runnable(){

            public void run() {
                try {
                    IViewPart view = IOUIPlugin.findView("org.eclipse.ui.navigator.ProjectExplorer");
                    IOUIPlugin.refreshNavigatorInternal(view, element, selection);
                    view = IOUIPlugin.findView("com.aptana.ui.io.remoteview");
                    if (view != null) {
                        if (element instanceof IConnectionPointCategory && ((IConnectionPointCategory)element).isRemote()) {
                            Object input = ((CommonNavigator)view).getCommonViewer().getInput();
                            IOUIPlugin.refreshNavigatorInternal(view, input, selection);
                        } else {
                            IOUIPlugin.refreshNavigatorInternal(view, element, selection);
                        }
                    }
                }
                catch (PartInitException partInitException) {
                    // empty catch block
                }
            }
        });
    }

    private static void refreshNavigatorInternal(IViewPart viewPart, Object element, Object selection) {
        CommonViewer viewer;
        if (viewPart == null) {
            return;
        }
        if (viewPart instanceof CommonNavigator) {
            viewer = ((CommonNavigator)viewPart).getCommonViewer();
            if (element == null) {
                System.err.println("FIXME: full refresh for " + viewer.getClass().getSimpleName());
                viewer.refresh();
            } else {
                Object data;
                Widget widget = viewer.testFindItem(element);
                if (widget != null && (data = widget.getData()) != null) {
                    viewer.refresh(data);
                }
            }
        }
        if (selection != null && viewPart instanceof CommonNavigator) {
            viewer = ((CommonNavigator)viewPart).getCommonViewer();
            viewer.expandToLevel(element, 1);
            viewer.setSelection((ISelection)new StructuredSelection(selection));
        }
    }

    private static IViewPart findView(String viewID) throws PartInitException {
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            return page.findView(viewID);
        }
        return null;
    }

    private void addPartListener() {
        IWorkbench workbench = null;
        try {
            workbench = PlatformUI.getWorkbench();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (workbench != null) {
            IWorkbenchWindow[] windows;
            IWorkbenchWindow[] iWorkbenchWindowArray = windows = workbench.getWorkbenchWindows();
            int n = windows.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchWindow window;
                final IWorkbenchWindow workbenchWindow = window = iWorkbenchWindowArray[n2];
                UIUtils.getDisplay().syncExec(new Runnable(){

                    public void run() {
                        IViewPart projectExplorer = null;
                        projectExplorer = workbenchWindow.getActivePage().findView("org.eclipse.ui.navigator.ProjectExplorer");
                        if (projectExplorer != null) {
                            IOUIPlugin.this.handleProjectExplorerListeners((IWorkbenchPart)projectExplorer);
                        }
                    }
                });
                IPartService partService = window.getPartService();
                if (partService != null) {
                    partService.addPartListener(this.fPartListener);
                }
                ++n2;
            }
            PlatformUI.getWorkbench().addWindowListener(this.fWindowListener);
        }
    }

    private void removePartListener() {
        IWorkbench workbench = null;
        try {
            workbench = PlatformUI.getWorkbench();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (workbench != null) {
            IWorkbenchWindow[] windows;
            IWorkbenchWindow[] iWorkbenchWindowArray = windows = workbench.getWorkbenchWindows();
            int n = windows.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                IPartService partService = window.getPartService();
                if (partService != null) {
                    partService.removePartListener(this.fPartListener);
                }
                ++n2;
            }
            PlatformUI.getWorkbench().removeWindowListener(this.fWindowListener);
        }
    }

    private void attachSaveListener(IEditorPart editorPart) {
        final IEditorInput editorInput = editorPart.getEditorInput();
        if (!(editorInput instanceof UniformFileStoreEditorInput) || !((UniformFileStoreEditorInput)editorInput).isRemote()) {
            return;
        }
        editorPart.addPropertyListener(new IPropertyListener(){

            public void propertyChanged(Object source, int propId) {
                if (propId == 257 && source instanceof EditorPart) {
                    EditorPart ed = (EditorPart)source;
                    if (ed.isDirty()) {
                        return;
                    }
                    Job job = (Job)IOUIPlugin.this.saveRemoteJobs.get(editorInput);
                    if (job != null) {
                        return;
                    }
                    job = new Job(String.valueOf(Messages.EditorUtils_MSG_RemotelySaving) + ed.getPartName()){

                        protected IStatus run(final IProgressMonitor monitor) {
                            UniformFileStoreEditorInput input = (UniformFileStoreEditorInput)editorInput;
                            final IFileStore localCacheFile = input.getLocalFileStore();
                            IFileStore originalFile = input.getFileStore();
                            IFileInfo originalFileInfo = input.getFileInfo();
                            try {
                                IFileInfo currentFileInfo = originalFile.fetchInfo(0, monitor);
                                if (currentFileInfo.exists() && (currentFileInfo.getLastModified() != originalFileInfo.getLastModified() || currentFileInfo.getLength() != originalFileInfo.getLength()) && !UIUtils.showPromptDialog((String)Messages.EditorUtils_OverwritePrompt_Title, (String)MessageFormat.format(Messages.EditorUtils_OverwritePrompt_Message, originalFile.getName()))) {
                                    IStatus iStatus = Status.CANCEL_STATUS;
                                    return iStatus;
                                }
                                try {
                                    SyncUtils.copy((IFileStore)localCacheFile, null, (IFileStore)originalFile, (int)0, (IProgressMonitor)monitor);
                                }
                                catch (CoreException e) {
                                    final String filename = originalFile.getName();
                                    UIUtils.getDisplay().asyncExec(new Runnable(){

                                        public void run() {
                                            if (MessageDialog.openConfirm((Shell)UIUtils.getActiveShell(), (String)MessageFormat.format(Messages.IOUIPlugin_ErrorSavingRemoteFile_Title, filename), (String)MessageFormat.format(Messages.IOUIPlugin_ErrorSavingRemoteFile_Message, e.getLocalizedMessage()))) {
                                                FileDialog dialog = new FileDialog(UIUtils.getActiveShell(), 8192);
                                                dialog.setFileName(filename);
                                                String filepath = dialog.open();
                                                if (filepath != null) {
                                                    IFileStore localFileStore = EFS.getLocalFileSystem().fromLocalFile(new File(filepath));
                                                    try {
                                                        SyncUtils.copy((IFileStore)localCacheFile, null, (IFileStore)localFileStore, (int)0, (IProgressMonitor)monitor);
                                                    }
                                                    catch (CoreException e1) {
                                                        UIUtils.showErrorMessage((String)MessageFormat.format(Messages.IOUIPlugin_ErrorSavingRemoteFile_Title, filename), (Throwable)e);
                                                    }
                                                }
                                            }
                                        }
                                    });
                                }
                            }
                            finally {
                                try {
                                    input.setFileInfo(originalFile.fetchInfo(0, monitor));
                                }
                                catch (CoreException e) {
                                    IdeLog.logWarning((Plugin)IOUIPlugin.getDefault(), (Throwable)e);
                                }
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    IOUIPlugin.this.saveRemoteJobs.put(editorInput, job);
                    job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                        public void done(IJobChangeEvent event) {
                            IOUIPlugin.this.saveRemoteJobs.remove(editorInput);
                        }
                    });
                    job.schedule();
                }
            }
        });
    }
}

