/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ui.io;

import com.aptana.core.io.efs.EFSUtils;
import com.aptana.ide.ui.io.FileSystemUtils;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;

public class Utils {
    public static IFileStore getFileStore(Object adaptable) {
        IResource resource;
        if (adaptable instanceof IAdaptable && (resource = (IResource)((IAdaptable)adaptable).getAdapter(IResource.class)) != null) {
            return EFSUtils.getFileStore((IResource)resource);
        }
        return FileSystemUtils.getFileStore(adaptable);
    }

    public static IFileInfo getDetailedFileInfo(IAdaptable adaptable) {
        return Utils.getFileInfo(adaptable, 1024);
    }

    public static boolean exists(IAdaptable adaptable) {
        return Utils.getFileInfo(adaptable, 2048).exists();
    }

    public static boolean isDirectory(IAdaptable adaptable) {
        return Utils.getFileInfo(adaptable, 2048).isDirectory();
    }

    public static IFileInfo getFileInfo(IAdaptable adaptable, int options) {
        IFileStore fileStore;
        IFileInfo fileInfo = (IFileInfo)adaptable.getAdapter(IFileInfo.class);
        if (fileInfo == null && (fileStore = Utils.getFileStore(adaptable)) != null) {
            fileInfo = FileSystemUtils.fetchFileInfo(fileStore, options);
        }
        return fileInfo;
    }
}

