/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ui.io.internal;

import com.aptana.core.io.efs.SyncUtils;
import com.aptana.core.util.FileUtil;
import com.aptana.ide.ui.io.internal.UniformFileStoreEditorInput;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ide.FileStoreEditorInput;

public class UniformFileStoreEditorInputFactory
implements IElementFactory {
    static final String ID = "com.aptana.ui.io.UniformFileStoreEditorInputFactory";
    private static final String URI = "uri";

    public IAdaptable createElement(IMemento memento) {
        URI uri;
        String uriString = memento.getString(URI);
        if (uriString == null) {
            return null;
        }
        try {
            uri = new URI(uriString);
        }
        catch (URISyntaxException e) {
            return null;
        }
        try {
            return UniformFileStoreEditorInputFactory.getUniformEditorInput(EFS.getStore((URI)uri), (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public static IEditorInput getUniformEditorInput(IFileStore fileStore, IProgressMonitor monitor) throws CoreException {
        if (fileStore.getFileSystem() == EFS.getLocalFileSystem()) {
            return new FileStoreEditorInput(fileStore);
        }
        IFileInfo remoteFileInfo = fileStore.fetchInfo(0, monitor);
        IFileStore localFileStore = UniformFileStoreEditorInputFactory.toLocalFileStore(fileStore, remoteFileInfo, monitor);
        return new UniformFileStoreEditorInput(localFileStore, fileStore, remoteFileInfo);
    }

    static void saveState(IMemento memento, UniformFileStoreEditorInput input) {
        memento.putString(URI, input.getFileStore().toURI().toString());
    }

    private static IFileStore toLocalFileStore(IFileStore fileStore, IFileInfo fileInfo, IProgressMonitor monitor) throws CoreException {
        File file = fileStore.toLocalFile(0, monitor);
        if (file != null) {
            return fileStore;
        }
        try {
            StringBuilder prefix = new StringBuilder(fileStore.getFileSystem().getScheme());
            while (prefix.length() < 3) {
                prefix.append('_');
            }
            String prefixStr = prefix.toString();
            File destDir = new File(FileUtil.getTempDirectory().toOSString(), prefixStr);
            destDir.mkdirs();
            file = File.createTempFile(prefixStr, fileStore.getName(), destDir);
        }
        catch (IOException e) {
            return fileStore;
        }
        IFileStore localFileStore = EFS.getLocalFileSystem().fromLocalFile(file);
        SyncUtils.copy((IFileStore)fileStore, (IFileInfo)fileInfo, (IFileStore)localFileStore, (int)0, (IProgressMonitor)monitor);
        file.deleteOnExit();
        return localFileStore;
    }
}

