/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ui.io.navigator.actions;

import com.aptana.ide.ui.io.navigator.actions.Messages;
import com.aptana.ide.ui.io.navigator.actions.NewExternalFileWizard;
import com.aptana.scripting.model.TemplateElement;
import com.aptana.ui.util.UIUtils;
import java.io.InputStream;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class NewFileAction
extends BaseSelectionListenerAction {
    private IAdaptable fSelectedElement;
    private String fInitialFilename;
    private TemplateElement fTemplate;

    public NewFileAction() {
        this("");
    }

    public NewFileAction(String initialName) {
        this(initialName, null);
    }

    public NewFileAction(String initialName, TemplateElement template) {
        super(Messages.NewFileAction_Text);
        this.fInitialFilename = initialName;
        this.fTemplate = template;
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE"));
        this.setToolTipText(Messages.NewFileAction_ToolTip);
    }

    public void run() {
        if (this.fSelectedElement == null) {
            return;
        }
        NewExternalFileWizard wizard = new NewExternalFileWizard(this.fInitialFilename, this.getInitialContents(), this.fSelectedElement, this.fTemplate);
        WizardDialog dialog = new WizardDialog(UIUtils.getActiveShell(), (IWizard)wizard);
        dialog.open();
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        Object element;
        this.fSelectedElement = null;
        if (selection != null && !selection.isEmpty() && (element = selection.getFirstElement()) instanceof IAdaptable) {
            this.fSelectedElement = (IAdaptable)element;
        }
        return super.updateSelection(selection) && this.fSelectedElement != null;
    }

    protected InputStream getInitialContents() {
        return null;
    }
}

