/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.snippets.ui.views;

import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.dnd.SnippetTransfer;
import com.aptana.editor.common.scripting.commands.CommandExecutionUtils;
import com.aptana.editor.common.scripting.commands.TextEditorUtils;
import com.aptana.scripting.model.BundleManager;
import com.aptana.scripting.model.CommandElement;
import com.aptana.scripting.model.CommandResult;
import com.aptana.scripting.model.InvocationType;
import com.aptana.scripting.model.LoadCycleListener;
import com.aptana.scripting.model.SnippetCategoryElement;
import com.aptana.scripting.model.SnippetElement;
import com.aptana.scripting.ui.ScriptingUIPlugin;
import com.aptana.snippets.ui.views.Messages;
import com.aptana.snippets.ui.views.SnippetPopupDialog;
import com.aptana.snippets.ui.views.SnippetsFilter;
import com.aptana.theme.ColorManager;
import com.aptana.theme.Theme;
import com.aptana.ui.util.UIUtils;
import com.aptana.ui.widgets.SearchComposite;
import java.io.File;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.search.internal.core.text.PatternConstructor;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ExpandEvent;
import org.eclipse.swt.events.ExpandListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.ITextEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnippetsView
extends ViewPart {
    private static final String ICONS_FULL_ELCL16_EXPANDALL_GIF = "icons/full/elcl16/expandall.gif";
    public static final String ID = "com.aptana.snippets.ui.views.SnippetsView";
    private Image informationImage = ScriptingUIPlugin.getImage((String)"icons/full/obj16/information.png");
    private Image genericSnippetImage = ScriptingUIPlugin.getImage((String)"icons/snippet.png");
    private Image genericDisabledSnippetImage = new Image(this.genericSnippetImage.getDevice(), this.genericSnippetImage, 1);
    private Image insertSnippetImage = ScriptingUIPlugin.getImage((String)"icons/full/elcl16/insert_snippet_tsk.png");
    private Map<String, ExpandItem> expandItems = new HashMap<String, ExpandItem>();
    private ScrolledComposite scrolledComposite;
    private ExpandBar expandBar;
    private SearchComposite search;
    private SnippetsFilter filter;
    private Map<String, SnippetCategoryElement> snippetCategories = new LinkedHashMap<String, SnippetCategoryElement>();
    private HashMap<String, List<SnippetData>> sortedSnippets = new LinkedHashMap<String, List<SnippetData>>();
    private Map<SnippetData, SnippetItem> snippetItems = new HashMap<SnippetData, SnippetItem>();
    private Map<String, List<ToolItem>> toolItemMap = new HashMap<String, List<ToolItem>>();
    private Font defaultFont;
    private Font themeFont;
    private ImageRegistry imageRegistry;
    private ImageRegistry disabledImageRegistry;
    private ImageRegistry hotTagImageRegistry;
    private ColorManager colorManager;
    private IEclipsePreferences.IPreferenceChangeListener themeListener;
    private RGB defaultTagHotFg = new RGB(135, 160, 208);
    private RGB defaultTagHotBg = new RGB(192, 201, 219);
    private RGB defaultTagBg = new RGB(222, 231, 249);
    private RGB defaultTagFg = new RGB(165, 190, 238);
    private List<String> collapsedCategories = new ArrayList<String>();
    private String currentScope;
    private SnippetPopupDialog snippetDialog;
    private SnippetBundleListener snippetBundleListener;
    private int tagWidth = -1;
    private static Pattern descriptionReplacePattern = Pattern.compile("[\r\n\t]+");
    private ISelectionListener selectionListener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            if (selection instanceof ITextSelection) {
                SnippetsView.this.updateBasedOnPart(part);
            }
        }
    };
    Comparator<SnippetCategoryElement> snippetCategoryElementComparator = new Comparator<SnippetCategoryElement>(){

        @Override
        public int compare(SnippetCategoryElement arg0, SnippetCategoryElement arg1) {
            if (arg0 == null && arg1 == null || arg0 != null && arg0.getDisplayName() == null && arg1 != null && arg1.getDisplayName() == null) {
                return 0;
            }
            if (arg0 == null || arg0.getDisplayName() == null) {
                return 1;
            }
            if (arg1 == null || arg1.getDisplayName() == null) {
                return -1;
            }
            return arg0.getDisplayName().compareTo(arg1.getDisplayName());
        }
    };
    FilterSnippetsJob filterSnippetsJob = null;
    private IPartListener partListener = new IPartListener(){

        public void partOpened(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partActivated(IWorkbenchPart part) {
            SnippetsView.this.updateBasedOnPart(part);
        }
    };

    public SnippetsView() {
        this.setPartName(Messages.SnippetsView_partName);
        this.imageRegistry = new ImageRegistry();
        this.disabledImageRegistry = new ImageRegistry();
        this.hotTagImageRegistry = new ImageRegistry();
        this.colorManager = new ColorManager();
        this.snippetBundleListener = new SnippetBundleListener();
    }

    private void updateThemeFont() {
        this.themeFont = this.defaultFont;
    }

    private void updateThemeColors() {
        this.updateThemeFont();
        int height = -1;
        for (String tagName : this.toolItemMap.keySet()) {
            List<ToolItem> toolItems = this.toolItemMap.get(tagName);
            for (ToolItem toolItem : toolItems) {
                toolItem.setImage(null);
                toolItem.setHotImage(null);
            }
            this.imageRegistry.remove(tagName);
            this.hotTagImageRegistry.remove(tagName);
            for (ToolItem toolItem : toolItems) {
                height = this.createTagImagesForToolItem(toolItem.getParent(), height, tagName, toolItem);
            }
        }
        for (SnippetItem item : this.snippetItems.values()) {
            item.applyVisualEnablement();
        }
        this.updateSnippetDrawers();
    }

    protected Font getFont() {
        return JFaceResources.getTextFont();
    }

    private synchronized void closeSnippetDialog() {
        if (this.snippetDialog != null) {
            this.snippetDialog.close();
            this.snippetDialog = null;
        }
    }

    public void createPartControl(Composite parent) {
        IWorkbenchPage page;
        this.filter = new SnippetsFilter();
        this.defaultFont = parent.getFont();
        this.updateThemeColors();
        this.themeListener = new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                String key = event.getKey();
                if ("THEME_CHANGED".equals(key)) {
                    SnippetsView.this.updateThemeColors();
                }
            }
        };
        parent.setLayout((Layout)GridLayoutFactory.fillDefaults().margins(0, 1).spacing(0, 0).create());
        this.search = new SearchComposite(parent, 0, false, new SearchComposite.Client(){

            public void search(String text, boolean isCaseSensitive, boolean isRegularExpression) {
                Pattern pattern = PatternConstructor.createPattern((String)text, (boolean)isCaseSensitive, (boolean)isRegularExpression);
                SnippetsView.this.filter.setPattern(pattern);
                ArrayList<SnippetElement> snippets = new ArrayList<SnippetElement>();
                HashMap<SnippetElement, SnippetData> mapping = new HashMap<SnippetElement, SnippetData>();
                for (List list : SnippetsView.this.sortedSnippets.values()) {
                    for (SnippetData data : list) {
                        snippets.add(data.snippet);
                        mapping.put(data.snippet, data);
                    }
                }
                Object[] filtered = SnippetsView.this.filter.filter(null, null, snippets.toArray(new SnippetElement[snippets.size()]));
                ArrayList<SnippetData> snippetDatas = new ArrayList<SnippetData>();
                Object[] objectArray = filtered;
                int n = filtered.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    snippetDatas.add((SnippetData)mapping.get(object));
                    ++n2;
                }
                if (SnippetsView.this.filterSnippetsJob != null) {
                    SnippetsView.this.filterSnippetsJob.cancel();
                }
                SnippetsView.this.filterSnippetsJob = new FilterSnippetsJob(snippetDatas);
                SnippetsView.this.filterSnippetsJob.schedule(750L);
            }
        });
        this.search.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.search.setSearchOnEnter(false);
        this.search.setInitialText(Messages.SnippetsView_Initial_filter_text);
        this.scrolledComposite = new ScrolledComposite(parent, 2816);
        this.scrolledComposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.scrolledComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().spacing(0, 0).create());
        this.scrolledComposite.getVerticalBar().setIncrement(6);
        this.expandBar = new ExpandBar((Composite)this.scrolledComposite, 0);
        this.expandBar.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.scrolledComposite.setContent((Control)this.expandBar);
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(true);
        this.createSnippetDrawers();
        this.expandBar.addExpandListener(new ExpandListener(){

            public void itemExpanded(ExpandEvent e) {
                SnippetsView.this.expandDrawer((String)((ExpandItem)e.item).getData(), false);
                SnippetsView.this.updateScrollMinSize((ExpandItem)e.item, true);
                SnippetsView.this.collapsedCategories.remove((String)e.item.getData());
            }

            public void itemCollapsed(ExpandEvent e) {
                SnippetsView.this.updateScrollMinSize((ExpandItem)e.item, false);
                SnippetsView.this.collapsedCategories.add((String)e.item.getData());
            }
        });
        this.initializeToolBar();
        IPartService service = (IPartService)this.getSite().getService(IPartService.class);
        if (service != null) {
            service.addPartListener(this.partListener);
        }
        if ((page = this.getSite().getPage()) != null) {
            this.updateBasedOnPart((IWorkbenchPart)page.getActiveEditor());
        }
        this.getSite().getWorkbenchWindow().getSelectionService().addPostSelectionListener(this.selectionListener);
    }

    private void updateBasedOnPart(IWorkbenchPart part) {
        if (part instanceof AbstractThemeableEditor) {
            AbstractThemeableEditor textEditor = (AbstractThemeableEditor)part;
            String scope = null;
            try {
                ISourceViewer viewer = TextEditorUtils.getSourceViewer((ITextEditor)textEditor);
                int caretOffset = textEditor.getCaretOffset();
                if (viewer == null) {
                    IDocument document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
                    scope = CommonEditorPlugin.getDefault().getDocumentScopeManager().getScopeAtOffset(document, caretOffset);
                } else {
                    scope = CommonEditorPlugin.getDefault().getDocumentScopeManager().getScopeAtOffset((ITextViewer)viewer, caretOffset);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.currentScope == null || !this.currentScope.equals(scope)) {
                this.updateSnippetEnablement(scope);
            }
        } else if (part instanceof IEditorPart) {
            this.updateSnippetEnablement(null);
        }
    }

    private void updateScrollMinSize(ExpandItem item, boolean expanded) {
        if (item == null) {
            Point size = this.expandBar.computeSize(-1, -1);
            this.scrolledComposite.setMinSize(size.x, size.y);
        } else {
            int minHeight = this.scrolledComposite.getMinHeight();
            minHeight = expanded ? minHeight + item.getHeight() : minHeight - item.getHeight();
            this.scrolledComposite.setMinHeight(minHeight);
        }
    }

    protected void showSnippets(List<SnippetData> snippets) {
        HashMap<String, ArrayList<SnippetElement>> localSnippets = new HashMap<String, ArrayList<SnippetElement>>();
        for (SnippetData snippetData : snippets) {
            String category = this.getSnippetCategoryName(snippetData.snippet);
            ArrayList<SnippetElement> snippetList = (ArrayList<SnippetElement>)localSnippets.get(category);
            if (snippetList == null) {
                snippetList = new ArrayList<SnippetElement>();
                localSnippets.put(category, snippetList);
            }
            snippetList.add(snippetData.snippet);
        }
        HashMap<String, ArrayList<SnippetItem>> changedSnippets = new HashMap<String, ArrayList<SnippetItem>>();
        for (String category : this.sortedSnippets.keySet()) {
            List<SnippetData> datas = this.sortedSnippets.get(category);
            for (SnippetData data : datas) {
                ExpandItem expandItem;
                SnippetItem item = this.snippetItems.get(data);
                boolean newExclude = !snippets.contains(data);
                boolean oldExclude = data.filtered;
                data.filtered = newExclude;
                boolean itemChanged = false;
                if (item != null) {
                    if (newExclude != oldExclude) {
                        itemChanged = true;
                    }
                    item.setFiltered(newExclude);
                } else if (!newExclude && (expandItem = this.expandItems.get(category)).getExpanded()) {
                    this.expandDrawer(category, false);
                    itemChanged = true;
                    item = this.snippetItems.get(data);
                    if (item != null) {
                        item.setFiltered(newExclude);
                    }
                }
                if (!itemChanged) continue;
                ArrayList<SnippetItem> list = (ArrayList<SnippetItem>)changedSnippets.get(category);
                if (list == null) {
                    list = new ArrayList<SnippetItem>();
                    changedSnippets.put(category, list);
                }
                list.add(item);
            }
        }
        for (String category : this.expandItems.keySet()) {
            int size = 0;
            List sortedSnippets = (List)localSnippets.get(category);
            if (sortedSnippets != null) {
                size = sortedSnippets.size();
            }
            ExpandItem expandItem = this.expandItems.get(category);
            expandItem.setText(MessageFormat.format(Messages.SnippetsView_Snippet_drawer_title, category != null ? category : Messages.SnippetsView_Snippet_drawer_other, String.valueOf(size)));
            List list = (List)changedSnippets.get(category);
            if (CollectionsUtil.isEmpty((Collection)list)) continue;
            ((Composite)expandItem.getControl()).layout(list.toArray(new Control[list.size()]));
            expandItem.setHeight(expandItem.getControl().computeSize((int)-1, (int)-1).y);
        }
        this.updateScrollMinSize(null, false);
    }

    protected String getSnippetCategoryName(SnippetElement snippet) {
        return snippet.getCategory() != null ? snippet.getCategory() : snippet.getOwningBundle().getDisplayName();
    }

    protected void createSnippetDrawers() {
        this.snippetItems.clear();
        this.toolItemMap.clear();
        this.currentScope = null;
        InstanceScope.INSTANCE.getNode("com.aptana.theme").removePreferenceChangeListener(this.themeListener);
        ArrayList<String> expandedDrawers = new ArrayList<String>();
        for (ExpandItem item : this.expandItems.values()) {
            if (item.isDisposed()) continue;
            if (item.getExpanded()) {
                expandedDrawers.add((String)item.getData());
            }
            item.getControl().dispose();
            item.dispose();
        }
        this.expandItems.clear();
        this.updateCategoriesAndSnippets(expandedDrawers);
        this.updateScrollMinSize(null, false);
        this.scrolledComposite.layout(true, true);
        this.updateSnippetDrawers();
        InstanceScope.INSTANCE.getNode("com.aptana.theme").addPreferenceChangeListener(this.themeListener);
    }

    private void expandDrawer(String category, boolean shouldExpand) {
        ExpandItem expandItem = this.expandItems.get(category);
        if (expandItem != null) {
            boolean adjustHeight = false;
            Composite composite = (Composite)expandItem.getControl();
            List<SnippetData> elements = this.sortedSnippets.get(category);
            if (!CollectionsUtil.isEmpty(elements)) {
                for (SnippetData element : elements) {
                    if (this.snippetItems.get(element) != null) continue;
                    this.snippetItems.put(element, new SnippetItem(composite, element));
                    adjustHeight = true;
                }
            }
            if (adjustHeight) {
                expandItem.setHeight(composite.computeSize((int)-1, (int)-1).y);
            }
            if (shouldExpand) {
                expandItem.setExpanded(true);
            }
        }
    }

    private void updateSnippetEnablement(String scope) {
        this.currentScope = scope;
        for (List<SnippetData> datas : this.sortedSnippets.values()) {
            for (SnippetData data : datas) {
                boolean matches = data.snippet.getScopeSelector().matches(scope);
                SnippetItem item = this.snippetItems.get(data);
                if (item != null) {
                    item.setVisualEnabled(matches);
                    continue;
                }
                data.visuallyEnabled = matches;
            }
        }
        this.updateSnippetDrawers();
    }

    private void updateCategoriesAndSnippets(List<String> expandedDrawers) {
        this.snippetCategories.clear();
        for (SnippetCategoryElement category : BundleManager.getInstance().getSnippetCategories(null)) {
            this.snippetCategories.put(category.getDisplayName(), category);
        }
        List snippets = BundleManager.getInstance().getSnippets(null);
        if (CollectionsUtil.isEmpty((Collection)snippets)) {
            this.currentScope = null;
        }
        this.snippetItems.clear();
        this.sortedSnippets.clear();
        this.toolItemMap.clear();
        HashSet tags = new HashSet();
        for (SnippetElement snippet : snippets) {
            List<SnippetData> snippetList;
            String category = this.getSnippetCategoryName(snippet);
            if (!this.snippetCategories.containsKey(category)) {
                SnippetCategoryElement snippetCategoryElement = new SnippetCategoryElement(null);
                snippetCategoryElement.setDisplayName(category);
                this.snippetCategories.put(category, snippetCategoryElement);
            }
            if ((snippetList = this.sortedSnippets.get(category)) == null) {
                snippetList = new ArrayList<SnippetData>();
                this.sortedSnippets.put(category, snippetList);
            }
            snippetList.add(new SnippetData(snippet));
            tags.addAll(snippet.getTags());
        }
        if ("win32".equals(Platform.getOS())) {
            this.tagWidth = -1;
            GC gc = new GC((Drawable)UIUtils.getDisplay());
            if (!CollectionsUtil.isEmpty(tags)) {
                for (String tag : tags) {
                    int extent;
                    if (StringUtil.isEmpty((String)tag) || (extent = gc.textExtent((String)MessageFormat.format((String)"__{0}__", (Object[])new Object[]{tag})).x) <= this.tagWidth) continue;
                    this.tagWidth = extent;
                }
            }
            gc.dispose();
        }
        ArrayList<SnippetCategoryElement> categories = new ArrayList<SnippetCategoryElement>();
        categories.addAll(this.snippetCategories.values());
        Collections.sort(categories, this.snippetCategoryElementComparator);
        for (SnippetCategoryElement category : categories) {
            List<SnippetData> snippetList;
            ExpandItem expandItem = this.createSnippetDrawer(this.expandBar, category, snippetList = this.sortedSnippets.get(category.getDisplayName()));
            if (!expandedDrawers.contains(expandItem.getData())) continue;
            this.expandDrawer((String)expandItem.getData(), true);
        }
    }

    private void updateSnippetDrawers() {
        for (ExpandItem item : this.expandItems.values()) {
            Composite control = (Composite)item.getControl();
            control.layout(true, true);
            item.setHeight(control.computeSize((int)-1, (int)-1).y);
        }
    }

    protected ExpandItem createSnippetDrawer(ExpandBar expandBar, SnippetCategoryElement category, List<SnippetData> snippets) {
        Composite composite = new Composite((Composite)expandBar, 0);
        composite.setForeground(UIUtils.getDisplay().getSystemColor(23));
        composite.setLayout((Layout)GridLayoutFactory.fillDefaults().spacing(0, 0).create());
        ExpandItem expandItem = new ExpandItem(expandBar, 0);
        int size = 0;
        if (snippets != null) {
            size = snippets.size();
        }
        expandItem.setText(MessageFormat.format(Messages.SnippetsView_Snippet_drawer_title, category.getDisplayName(), String.valueOf(size)));
        expandItem.setControl((Control)composite);
        expandItem.setImage(category != null && category.getIconURL() != null ? this.getImage(category.getIconURL()) : this.genericSnippetImage);
        expandItem.setData((Object)(category != null ? category.getDisplayName() : null));
        expandItem.setHeight(composite.computeSize((int)-1, (int)-1).y);
        this.expandItems.put(category != null ? category.getDisplayName() : null, expandItem);
        return expandItem;
    }

    private void insertSnippet(SnippetElement snippet) {
        CommandResult commandResult;
        IEditorPart activeEditor = UIUtils.getActiveEditor();
        ITextEditor textEditor = null;
        if (activeEditor instanceof MultiPageEditorPart) {
            Object selectedPage = ((MultiPageEditorPart)activeEditor).getSelectedPage();
            if (selectedPage instanceof ITextEditor) {
                textEditor = (ITextEditor)selectedPage;
            }
        } else if (activeEditor instanceof ITextEditor) {
            textEditor = (ITextEditor)activeEditor;
        }
        if (textEditor != null && (commandResult = CommandExecutionUtils.executeCommand((CommandElement)snippet, (InvocationType)InvocationType.MENU, (ITextEditor)textEditor)) != null) {
            CommandExecutionUtils.processCommandResult((CommandElement)snippet, (CommandResult)commandResult, (ITextEditor)textEditor);
            activeEditor.setFocus();
        }
    }

    private int createTagToolItem(ToolBar tagToolBar, int height, final String tag) {
        ToolItem item = new ToolItem(tagToolBar, 8);
        item.setData("tag", (Object)tag);
        height = this.createTagImagesForToolItem(tagToolBar, height, tag, item);
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SnippetsView.this.search.getTextControl().setFocus();
                SnippetsView.this.search.getTextControl().setText(tag);
            }
        });
        List<ToolItem> toolItems = this.toolItemMap.get(tag);
        if (toolItems == null) {
            toolItems = new ArrayList<ToolItem>();
            this.toolItemMap.put(tag, toolItems);
        }
        toolItems.add(item);
        return height;
    }

    private int createTagImagesForToolItem(ToolBar tagToolBar, int height, String tag, ToolItem item) {
        Image image;
        item.setHotImage(null);
        item.setImage(null);
        item.setText(MessageFormat.format("__{0}__", tag));
        Rectangle bounds = item.getBounds();
        int width = bounds.width;
        item.setText("");
        if (height < 0) {
            GC gc = new GC((Drawable)Display.getCurrent());
            gc.setFont(this.themeFont);
            Point textExtent = gc.textExtent("apt", 1);
            height = textExtent.y + (textExtent.y % 2 == 0 ? 4 : 5);
            gc.dispose();
        }
        if ((image = this.imageRegistry.get(tag)) == null) {
            image = this.createTagImage(tagToolBar, height, width, tag, false);
        }
        item.setImage(image);
        Image hotImage = this.hotTagImageRegistry.get(tag);
        if (hotImage == null) {
            hotImage = this.createTagImage(tagToolBar, height, width, tag, true);
        }
        item.setHotImage(hotImage);
        return height;
    }

    private Image createTagImage(ToolBar tagToolBar, int height, int width, String tagName, boolean isHot) {
        if (this.tagWidth > 0) {
            width = this.tagWidth;
        }
        Image image = new Image((Device)UIUtils.getDisplay(), width, height);
        GC gc = new GC((Drawable)image);
        gc.setAntialias(1);
        Color fg = gc.getForeground();
        Color bgColor = tagToolBar.getBackground();
        gc.setFont(this.themeFont);
        Point textSize = gc.textExtent(tagName);
        gc.setBackground(bgColor);
        gc.fillRectangle(0, 0, width, height);
        Color tempFg = null;
        Color tempBg = null;
        if (isHot) {
            tempFg = this.colorManager.getColor(this.defaultTagHotFg);
            tempBg = this.colorManager.getColor(this.defaultTagHotBg);
        } else {
            tempFg = this.colorManager.getColor(this.defaultTagFg);
            tempBg = this.colorManager.getColor(this.defaultTagBg);
        }
        gc.setForeground(tempFg);
        gc.setBackground(tempBg);
        gc.setAntialias(0);
        gc.fillRoundRectangle(1, 1, width - 2, height - 2, height - 2, height - 2);
        gc.setAntialias(1);
        gc.drawRoundRectangle(0, 0, width - 1, height - 1, height - 1, height - 1);
        gc.setForeground(fg);
        gc.drawText(tagName, (width - textSize.x) / 2, (height - textSize.y) / 2, true);
        ImageData imageData = image.getImageData();
        imageData.transparentPixel = imageData.palette.getPixel(bgColor.getRGB());
        image.dispose();
        gc.dispose();
        image = new Image((Device)UIUtils.getDisplay(), imageData);
        ImageRegistry registry = isHot ? this.hotTagImageRegistry : this.imageRegistry;
        registry.put(tagName, image);
        return image;
    }

    private Image getImage(URL url) {
        String urlString = url.toString();
        Image image = this.imageRegistry.get(urlString);
        if (image == null) {
            this.imageRegistry.put(urlString, ImageDescriptor.createFromURL((URL)url));
            image = this.imageRegistry.get(urlString);
        }
        return image;
    }

    private Image getDisabledImage(URL url) {
        String urlString = url.toString();
        Image image = this.disabledImageRegistry.get(urlString);
        if (image == null) {
            ImageDescriptor descriptor = this.imageRegistry.getDescriptor(urlString);
            this.disabledImageRegistry.put(urlString, ImageDescriptor.createWithFlags((ImageDescriptor)descriptor, (int)1));
            image = this.disabledImageRegistry.get(urlString);
        }
        return image;
    }

    private void initializeToolBar() {
        IToolBarManager toolbarManager = this.getViewSite().getActionBars().getToolBarManager();
        Action collapseAll = new Action(){

            public void run() {
                for (ExpandItem item : SnippetsView.this.expandItems.values()) {
                    boolean expanded = item.getExpanded();
                    item.setExpanded(false);
                    if (!expanded) continue;
                    SnippetsView.this.updateScrollMinSize(item, false);
                }
            }
        };
        collapseAll.setText(Messages.SnippetsView_Collapse_All_Action);
        collapseAll.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ELCL_COLLAPSEALL"));
        toolbarManager.add((IAction)collapseAll);
        Action expandAll = new Action(){

            public void run() {
                for (ExpandItem item : SnippetsView.this.expandItems.values()) {
                    boolean expanded = item.getExpanded();
                    SnippetsView.this.expandDrawer((String)item.getData(), true);
                    if (expanded) continue;
                    SnippetsView.this.updateScrollMinSize(item, true);
                }
            }
        };
        expandAll.setText(Messages.SnippetsView_Expand_All_Action);
        expandAll.setImageDescriptor(ScriptingUIPlugin.getImageDescriptor((String)ICONS_FULL_ELCL16_EXPANDALL_GIF));
        toolbarManager.add((IAction)expandAll);
    }

    public void dispose() {
        this.imageRegistry.dispose();
        this.disabledImageRegistry.dispose();
        this.hotTagImageRegistry.dispose();
        InstanceScope.INSTANCE.getNode("com.aptana.theme").removePreferenceChangeListener(this.themeListener);
        this.snippetBundleListener.dispose();
        super.dispose();
        this.colorManager.dispose();
        this.getSite().getWorkbenchWindow().getSelectionService().removePostSelectionListener(this.selectionListener);
        IPartService service = (IPartService)this.getSite().getService(IPartService.class);
        if (service != null) {
            service.removePartListener(this.partListener);
        }
    }

    public void setFocus() {
        this.expandBar.setFocus();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FilterSnippetsJob
    extends Job {
        List<SnippetData> snippets;

        public FilterSnippetsJob(List<SnippetData> newSnippets) {
            super("Filter snippets");
            this.snippets = new ArrayList<SnippetData>();
            this.snippets.addAll(newSnippets);
        }

        protected IStatus run(IProgressMonitor monitor) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    SnippetsView.this.showSnippets(FilterSnippetsJob.this.snippets);
                }
            });
            return Status.OK_STATUS;
        }
    }

    private class InsertSnippetListener
    extends MouseAdapter {
        private SnippetElement snippet;

        InsertSnippetListener(SnippetElement snippet) {
            this.snippet = snippet;
        }

        public void mouseDoubleClick(MouseEvent e) {
            SnippetsView.this.insertSnippet(this.snippet);
        }
    }

    class SnippetBundleListener
    implements LoadCycleListener {
        private final Job job = new Job("Force reconcile on bundle change"){

            protected IStatus run(IProgressMonitor monitor) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        if (SnippetsView.this.scrolledComposite != null && !SnippetsView.this.scrolledComposite.isDisposed()) {
                            SnippetsView.this.createSnippetDrawers();
                            SnippetsView.this.updateBasedOnPart((IWorkbenchPart)SnippetsView.this.getSite().getPage().getActiveEditor());
                        }
                    }
                });
                return Status.OK_STATUS;
            }
        };

        public SnippetBundleListener() {
            BundleManager.getInstance().addLoadCycleListener((LoadCycleListener)this);
        }

        public void dispose() {
            BundleManager.getInstance().removeLoadCycleListener((LoadCycleListener)this);
        }

        public void scriptLoaded(File script) {
            this.bundleFileChanged(script);
        }

        public void scriptReloaded(File script) {
            this.bundleFileChanged(script);
        }

        public void scriptUnloaded(File script) {
            this.bundleFileChanged(script);
        }

        private void bundleFileChanged(File script) {
            if (script == null || !script.getName().equals("bundle.rb") && (script.getParentFile() == null || !"snippets".equals(script.getParentFile().getName()))) {
                return;
            }
            this.job.cancel();
            EclipseUtil.setSystemForJob((Job)this.job);
            this.job.schedule(750L);
        }
    }

    private class SnippetData {
        private SnippetElement snippet;
        private boolean visuallyEnabled = true;
        private boolean filtered = false;

        SnippetData(SnippetElement snippet) {
            this.snippet = snippet;
        }
    }

    private class SnippetItem
    extends Composite {
        private SnippetData snippetData;
        private MouseListener mouseListener;
        private Label imageLabel;
        private Composite textComposite;
        private CLabel titleLabel;
        private CLabel descLabel;
        private ToolBar toolbar;
        private ToolBar tagToolBar;
        private String categoryName;
        final int SNIPPET_MARGIN = 5;

        SnippetItem(Composite parent, SnippetData snippetData) {
            super(parent, 0);
            this.SNIPPET_MARGIN = 5;
            this.snippetData = snippetData;
            this.mouseListener = new InsertSnippetListener(snippetData.snippet);
            this.categoryName = SnippetsView.this.getSnippetCategoryName(snippetData.snippet);
            this.setLayout((Layout)GridLayoutFactory.fillDefaults().extendedMargins(5, 5, 1, 5).spacing(2, 0).numColumns(3).create());
            GridData gridData = GridDataFactory.fillDefaults().grab(true, false).create();
            gridData.exclude = snippetData.filtered;
            this.setLayoutData(gridData);
            this.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    Color foreground = e.gc.getForeground();
                    e.gc.setForeground(SnippetsView.this.colorManager.getColor(Theme.alphaBlend((RGB)SnippetItem.this.getBackground().getRGB(), (RGB)SnippetItem.this.getForeground().getRGB(), (int)100)));
                    Rectangle clientArea = SnippetItem.this.getClientArea();
                    e.gc.drawLine(clientArea.x - 5, clientArea.y + clientArea.height - 2, clientArea.x + clientArea.width + 5, clientArea.y + clientArea.height - 2);
                    e.gc.drawLine(clientArea.x, clientArea.y, clientArea.x, clientArea.y + clientArea.height - 1);
                    e.gc.drawLine(clientArea.x + clientArea.width - 1, clientArea.y, clientArea.x + clientArea.width - 1, clientArea.y + clientArea.height - 1);
                    Point newPoint = UIUtils.getDisplay().map((Control)SnippetItem.this, (Control)SnippetItem.this.getParent(), new Point(clientArea.x, clientArea.y));
                    if (newPoint.y == 0) {
                        e.gc.drawLine(clientArea.x - 5, clientArea.y, clientArea.x + clientArea.width + 5, clientArea.y);
                    }
                    e.gc.setForeground(foreground);
                }
            });
            this.addMouseListener(this.mouseListener);
            this.addTitleAndDescriptionForSnippet(snippetData.snippet, this, this.mouseListener);
            this.addActionToobarForSnippet(snippetData.snippet, this);
            this.addTagToolbarForSnippet(snippetData.snippet, this);
            this.applyVisualEnablement();
        }

        protected void setFiltered(boolean filtered) {
            this.snippetData.filtered = filtered;
            this.applyFiltered();
        }

        protected void applyFiltered() {
            this.setVisible(!this.snippetData.filtered);
            ((GridData)this.getLayoutData()).exclude = this.snippetData.filtered;
        }

        protected void setVisualEnabled(boolean enabled) {
            this.snippetData.visuallyEnabled = enabled;
            this.applyVisualEnablement();
        }

        protected void applyVisualEnablement() {
            this.titleLabel.setForeground(this.descLabel.getForeground());
            if (this.tagToolBar != null && this.tagToolBar.isDisposed()) {
                this.tagToolBar.setEnabled(this.snippetData.visuallyEnabled);
            }
            this.imageLabel.setImage(this.getSnippetImage(this.snippetData.visuallyEnabled));
        }

        private void addTitleAndDescriptionForSnippet(SnippetElement snippet, Composite itemComposite, MouseListener mouseListener) {
            this.imageLabel = new Label(itemComposite, 0);
            this.imageLabel.setLayoutData((Object)GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).create());
            this.imageLabel.setImage(this.getSnippetImage(true));
            this.imageLabel.addMouseListener(mouseListener);
            this.textComposite = new Composite(itemComposite, 0);
            this.textComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().spacing(3, 0).numColumns(2).create());
            this.textComposite.setLayoutData((Object)GridDataFactory.fillDefaults().align(1, 0x1000000).grab(true, false).create());
            this.textComposite.addMouseListener(mouseListener);
            this.titleLabel = new CLabel(this.textComposite, 0);
            this.titleLabel.setText(snippet.getDisplayName());
            this.titleLabel.setLayoutData((Object)GridDataFactory.fillDefaults().align(1, 0x1000000).grab(false, false).create());
            this.titleLabel.addMouseListener(mouseListener);
            this.descLabel = new CLabel(this.textComposite, 0);
            String descText = snippet.getDescription();
            if (descText == null || StringUtil.isEmpty((String)descText)) {
                descText = descriptionReplacePattern.matcher(snippet.getExpansion()).replaceAll(" ");
            }
            this.descLabel.setText(descText);
            this.descLabel.setLayoutData((Object)GridDataFactory.fillDefaults().align(1, 0x1000000).grab(true, false).create());
            this.descLabel.addMouseListener(mouseListener);
            this.addDragDropForSnippet();
        }

        private void addActionToobarForSnippet(final SnippetElement snippet, final Composite itemComposite) {
            this.toolbar = new ToolBar(itemComposite, 256);
            this.toolbar.setLayoutData((Object)GridDataFactory.swtDefaults().align(1, 0x1000000).create());
            this.toolbar.setVisible(false);
            ToolItem insertItem = new ToolItem(this.toolbar, 0);
            insertItem.setImage(SnippetsView.this.insertSnippetImage);
            insertItem.setToolTipText(Messages.SnippetsView_Insert_Snippet_desc);
            insertItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SnippetsView.this.insertSnippet(snippet);
                }
            });
            ToolItem infoItem = new ToolItem(this.toolbar, 0);
            infoItem.setImage(SnippetsView.this.informationImage);
            infoItem.setToolTipText(Messages.SnippetsView_Show_Information_desc);
            infoItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SnippetsView.this.closeSnippetDialog();
                    SnippetsView.this.snippetDialog = new SnippetPopupDialog(SnippetItem.this.getShell(), snippet, (Control)SnippetItem.this.toolbar);
                    SnippetsView.this.snippetDialog.open();
                }
            });
            itemComposite.addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent e) {
                    boolean contains = itemComposite.getClientArea().contains(e.x, e.y);
                    if (contains) {
                        for (SnippetItem item : SnippetsView.this.snippetItems.values()) {
                            ToolBar tempToolbar = item.toolbar;
                            if (tempToolbar == SnippetItem.this.toolbar) continue;
                            tempToolbar.setVisible(false);
                        }
                    }
                    SnippetItem.this.toolbar.setVisible(contains);
                }
            });
        }

        private void addTagToolbarForSnippet(SnippetElement snippet, Composite itemComposite) {
            List tags = snippet.getTags();
            if (!CollectionsUtil.isEmpty((Collection)tags)) {
                new Label(itemComposite, 0);
                this.tagToolBar = new ToolBar(itemComposite, 320);
                this.tagToolBar.setLayoutData((Object)GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).grab(true, false).span(2, 1).create());
                int height = -1;
                for (String tag : tags) {
                    height = SnippetsView.this.createTagToolItem(this.tagToolBar, height, tag);
                }
            }
        }

        private void addDragDropForSnippet() {
            Control[] controls;
            int operations = 1;
            Transfer[] types = new Transfer[]{SnippetTransfer.getInstance()};
            DragSourceListener listener = new DragSourceListener(){

                public void dragStart(DragSourceEvent event) {
                    event.doit = true;
                    event.image = SnippetsView.this.insertSnippetImage;
                }

                public void dragSetData(DragSourceEvent event) {
                    event.data = SnippetItem.this.snippetData.snippet;
                }

                public void dragFinished(DragSourceEvent event) {
                }
            };
            Control[] controlArray = controls = new Control[]{this.imageLabel, this.titleLabel, this.descLabel};
            int n = controls.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                DragSource titleSource = new DragSource(control, operations);
                titleSource.setTransfer(types);
                titleSource.addDragListener(listener);
                ++n2;
            }
        }

        private Image getSnippetImage(boolean enabled) {
            URL iconURL = this.snippetData.snippet.getIconURL();
            Image image = null;
            image = enabled ? (iconURL != null ? SnippetsView.this.getImage(iconURL) : SnippetsView.this.genericSnippetImage) : (iconURL != null ? SnippetsView.this.getDisabledImage(iconURL) : SnippetsView.this.genericDisabledSnippetImage);
            return image;
        }
    }
}

