/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.workbench.hyperlink;

import com.aptana.terminal.hyperlink.IHyperlinkDetector;
import com.aptana.workbench.hyperlink.EditorLineHyperlink;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;

public class StacktraceHyperlinkDetector
implements IHyperlinkDetector {
    private static Pattern OPEN_TRACE_LINE_PATTERN = Pattern.compile("\\s*(\\S.+?):(\\d+):\\s+");

    public IHyperlink[] detectHyperlinks(String contents) {
        Matcher m = OPEN_TRACE_LINE_PATTERN.matcher(contents);
        if (m.find()) {
            String filepath = m.group(1);
            int lineNumber = Integer.parseInt(m.group(2));
            int start = m.start(1);
            int parenIndex = filepath.indexOf("(");
            if (parenIndex != -1) {
                filepath = filepath.substring(parenIndex + 1);
                start += parenIndex + 1;
            }
            int length = m.end(2) - start;
            return new IHyperlink[]{new EditorLineHyperlink(new Region(start, length), filepath, lineNumber)};
        }
        return new IHyperlink[0];
    }
}

