/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.syncing.ui.actions;

import com.aptana.core.io.efs.EFSUtils;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.StringUtil;
import com.aptana.ide.core.io.IConnectionPoint;
import com.aptana.ide.syncing.core.ISiteConnection;
import com.aptana.ide.syncing.core.old.ISyncEventHandler;
import com.aptana.ide.syncing.core.old.Synchronizer;
import com.aptana.ide.syncing.core.old.VirtualFileSyncPair;
import com.aptana.ide.syncing.ui.SyncingUIPlugin;
import com.aptana.ide.syncing.ui.actions.BaseSyncAction;
import com.aptana.ide.syncing.ui.actions.Messages;
import com.aptana.ide.syncing.ui.actions.SyncActionEventHandler;
import com.aptana.ide.syncing.ui.internal.SyncUtils;
import com.aptana.ide.ui.io.IOUIPlugin;
import com.aptana.ide.ui.io.Utils;
import com.aptana.ui.DialogUtils;
import com.aptana.usage.AnalyticsEvent;
import com.aptana.usage.FeatureEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;

public class DownloadAction
extends BaseSyncAction {
    private IJobChangeListener jobListener;
    private static String MESSAGE_TITLE = StringUtil.ellipsify((String)Messages.DownloadAction_MessageTitle);

    protected void performAction(final IAdaptable[] files, final ISiteConnection site) throws CoreException {
        final Synchronizer syncer = new Synchronizer();
        Job job = new Job(MESSAGE_TITLE){

            protected IStatus run(final IProgressMonitor monitor) {
                monitor.subTask(StringUtil.ellipsify((String)Messages.BaseSyncAction_RetrievingItems));
                try {
                    try {
                        IFileStore[] targetFiles;
                        IFileStore sourceRoot;
                        IConnectionPoint source = site.getSource();
                        IConnectionPoint target = site.getDestination();
                        IFileStore iFileStore = sourceRoot = DownloadAction.this.fSourceRoot == null ? source.getRoot() : DownloadAction.this.fSourceRoot;
                        if (!target.isConnected()) {
                            target.connect(monitor);
                        }
                        IFileStore targetRoot = DownloadAction.this.fDestinationRoot == null ? target.getRoot() : DownloadAction.this.fDestinationRoot;
                        syncer.setClientFileManager(source);
                        syncer.setServerFileManager(target);
                        syncer.setClientFileRoot(sourceRoot);
                        syncer.setServerFileRoot(targetRoot);
                        IFileStore[] fileStores = new IFileStore[files.length];
                        int i = 0;
                        while (i < fileStores.length) {
                            fileStores[i] = Utils.getFileStore((Object)files[i]);
                            ++i;
                        }
                        if (!DownloadAction.this.fSelectedFromSource) {
                            targetFiles = EFSUtils.getAllFiles((IFileStore[])fileStores, (boolean)true, (boolean)false, (IProgressMonitor)monitor);
                            ArrayList newFiles = new ArrayList();
                            IFileStore[] iFileStoreArray = fileStores;
                            int n = fileStores.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IFileStore fileStore = iFileStoreArray[n2];
                                if (!fileStore.equals(targetRoot)) {
                                    ArrayList<IFileStore> folders = new ArrayList<IFileStore>();
                                    IFileStore parent = fileStore.getParent();
                                    while (parent != null && !targetRoot.equals(parent)) {
                                        if (!newFiles.contains(parent)) {
                                            folders.add(0, parent);
                                        }
                                        parent = parent.getParent();
                                    }
                                    newFiles.addAll(folders);
                                }
                                ++n2;
                            }
                            newFiles.addAll(Arrays.asList(targetFiles));
                            targetFiles = newFiles.toArray(new IFileStore[newFiles.size()]);
                        } else {
                            targetFiles = SyncUtils.getDownloadFiles(source, target, fileStores, DownloadAction.this.fSelectedFromSource, true, monitor);
                        }
                        VirtualFileSyncPair[] items = syncer.createSyncItems(new IFileStore[0], targetFiles, monitor);
                        syncer.setEventHandler((ISyncEventHandler)new SyncActionEventHandler(Messages.DownloadAction_MessageTitle, items.length, monitor, new SyncActionEventHandler.Client(){

                            public void syncCompleted() {
                                IAdaptable[] iAdaptableArray = files;
                                int n = files.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    IAdaptable file = iAdaptableArray[n2];
                                    IResource resource = (IResource)file.getAdapter(IResource.class);
                                    if (resource != null) {
                                        try {
                                            resource.refreshLocal(2, monitor);
                                        }
                                        catch (CoreException coreException) {
                                            // empty catch block
                                        }
                                    }
                                    ++n2;
                                }
                                if (!(this).DownloadAction.this.fSelectedFromSource) {
                                    IOUIPlugin.refreshNavigatorView((Object)sourceRoot);
                                }
                                DownloadAction.this.postAction(syncer);
                                syncer.setEventHandler(null);
                                syncer.disconnect();
                            }
                        }));
                        syncer.download(items, monitor);
                    }
                    catch (OperationCanceledException e) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        DownloadAction.this.sendEvent((AnalyticsEvent)new FeatureEvent("remote.download." + site.getDestination().getType(), null));
                        return iStatus;
                    }
                    catch (Exception e) {
                        IdeLog.logError((Plugin)SyncingUIPlugin.getDefault(), (String)Messages.DownloadAction_ERR_FailToDownload, (Throwable)e);
                        Status status = new Status(4, "com.aptana.syncing.ui", Messages.DownloadAction_ERR_FailToDownload, (Throwable)e);
                        DownloadAction.this.sendEvent((AnalyticsEvent)new FeatureEvent("remote.download." + site.getDestination().getType(), null));
                        return status;
                    }
                }
                finally {
                    DownloadAction.this.sendEvent((AnalyticsEvent)new FeatureEvent("remote.download." + site.getDestination().getType(), null));
                }
                return Status.OK_STATUS;
            }
        };
        if (this.jobListener != null) {
            job.addJobChangeListener(this.jobListener);
        }
        job.setUser(true);
        job.schedule();
    }

    public void addJobListener(IJobChangeListener listener) {
        this.jobListener = listener;
    }

    protected String getMessageTitle() {
        return MESSAGE_TITLE;
    }

    private void postAction(final Synchronizer syncer) {
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                DialogUtils.openIgnoreMessageDialogInformation((Shell)DownloadAction.this.getShell(), (String)MESSAGE_TITLE, (String)MessageFormat.format(Messages.DownloadAction_PostMessage, syncer.getServerFileTransferedCount(), syncer.getClientDirectoryCreatedCount()), (IPreferenceStore)SyncingUIPlugin.getDefault().getPreferenceStore(), (String)"IGNORE_DIALOG_FILE_DOWNLOAD");
            }
        });
    }
}

