/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.syncing.ui.actions;

import com.aptana.core.CoreStrings;
import com.aptana.ide.core.io.IConnectionPoint;
import com.aptana.ide.syncing.core.old.VirtualFileSyncPair;
import com.aptana.ide.syncing.core.old.handlers.SyncEventHandlerAdapterWithProgressMonitor;
import com.aptana.ui.util.UIUtils;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;

class SyncActionEventHandler
extends SyncEventHandlerAdapterWithProgressMonitor {
    private String fTaskTitle;
    private int fItemCount;
    private IProgressMonitor fMonitor;
    private Client fClient;
    private int fSyncDoneCount;
    private boolean fContinue;

    SyncActionEventHandler(String taskTitle, int itemCount, IProgressMonitor monitor, Client client) {
        super(monitor);
        this.fTaskTitle = taskTitle;
        this.fItemCount = itemCount;
        this.fMonitor = monitor;
        this.fClient = client;
    }

    public void syncDone(VirtualFileSyncPair item, IProgressMonitor monitor) {
        super.syncDone(item, monitor);
        ++this.fSyncDoneCount;
        this.checkDone();
    }

    public boolean syncErrorEvent(VirtualFileSyncPair item, Exception e, IProgressMonitor monitor) {
        this.showError(e.getLocalizedMessage(), e);
        ++this.fSyncDoneCount;
        this.checkDone();
        return this.fContinue && super.syncErrorEvent(item, e, monitor);
    }

    public boolean getFilesEvent(IConnectionPoint manager, String path) {
        this.fMonitor.subTask(MessageFormat.format("{0} {1}", this.fTaskTitle, path));
        return super.getFilesEvent(manager, path);
    }

    private void checkDone() {
        if (this.fSyncDoneCount == this.fItemCount && this.fClient != null) {
            this.fClient.syncCompleted();
        }
    }

    private void showError(final String message, Exception e) {
        this.fContinue = false;
        UIUtils.getDisplay().syncExec(new Runnable(){

            public void run() {
                MessageDialog md = new MessageDialog(UIUtils.getActiveShell(), String.valueOf(CoreStrings.ERROR) + " " + SyncActionEventHandler.this.fTaskTitle, null, message, 4, new String[]{CoreStrings.CONTINUE, CoreStrings.CANCEL}, 1);
                SyncActionEventHandler.this.fContinue = md.open() == 0;
            }
        });
    }

    public static interface Client {
        public void syncCompleted();
    }
}

