/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.syncing.ui.dialogs;

import com.aptana.core.CoreStrings;
import com.aptana.core.util.StringUtil;
import com.aptana.ide.core.io.IConnectionPoint;
import com.aptana.ide.syncing.core.DefaultSiteConnection;
import com.aptana.ide.syncing.core.ISiteConnection;
import com.aptana.ide.syncing.core.SyncingPlugin;
import com.aptana.ide.syncing.ui.dialogs.Messages;
import com.aptana.ide.syncing.ui.internal.SiteConnectionPropertiesWidget;
import com.aptana.ide.syncing.ui.internal.SyncUtils;
import com.aptana.ui.IDialogConstants;
import com.aptana.ui.UIPlugin;
import com.aptana.ui.util.SWTUtils;
import com.aptana.ui.util.UIUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class SiteConnectionsEditorDialog
extends TitleAreaDialog
implements SiteConnectionPropertiesWidget.Client {
    private ISiteConnection initialSelection;
    private ListViewer sitesViewer;
    private Button addButton;
    private Button removeButton;
    private SiteConnectionPropertiesWidget sitePropertiesWidget;
    private List<ISiteConnection> sites = new ArrayList<ISiteConnection>();

    public SiteConnectionsEditorDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.setHelpAvailable(false);
        this.sites.add((ISiteConnection)DefaultSiteConnection.getInstance());
        this.sites.addAll(Arrays.asList(SyncingPlugin.getSiteConnectionManager().getSiteConnections()));
        this.setSelection((ISiteConnection)DefaultSiteConnection.getInstance());
    }

    public void setCreateNew(String name, IAdaptable source, IAdaptable destination) {
        IConnectionPoint sourceConnection = SyncUtils.findOrCreateConnectionPointFor(source);
        IConnectionPoint destinationConnection = SyncUtils.findOrCreateConnectionPointFor(destination);
        ISiteConnection siteConnection = SyncingPlugin.getSiteConnectionManager().createSiteConnection();
        siteConnection.setName(SiteConnectionsEditorDialog.createUniqueSiteName(name));
        siteConnection.setSource(sourceConnection);
        siteConnection.setDestination(destinationConnection);
        this.sites.add(siteConnection);
        if (this.sitesViewer != null) {
            this.sitesViewer.refresh();
        }
        this.setSelection(siteConnection);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.SiteConnectionsEditorDialog_DialogTitle);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        this.setTitle(Messages.SiteConnectionsEditorDialog_Title);
        this.setMessage(Messages.SiteConnectionsEditorDialog_Message);
        Composite container = new Composite(dialogArea, 0);
        container.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        container.setLayout((Layout)GridLayoutFactory.swtDefaults().margins(this.convertHorizontalDLUsToPixels(7), this.convertVerticalDLUsToPixels(7)).spacing(this.convertHorizontalDLUsToPixels(4), this.convertVerticalDLUsToPixels(4)).create());
        SashForm sashForm = new SashForm(container, 256);
        sashForm.setLayoutData((Object)GridDataFactory.fillDefaults().hint(-1, 400).grab(true, true).create());
        Group group = new Group((Composite)sashForm, 0);
        group.setText(Messages.SiteConnectionsEditorDialog_LBL_ConnectionGroup);
        group.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        group.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(2).create());
        this.sitesViewer = new ListViewer((Composite)group, 2820);
        this.sitesViewer.getControl().setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).span(2, 1).create());
        this.sitesViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.sitesViewer.setLabelProvider((IBaseLabelProvider)new SitesLabelProvider());
        this.sitesViewer.setComparator((ViewerComparator)new SitesSorter());
        this.sitesViewer.setInput(this.sites);
        this.addButton = new Button((Composite)group, 8);
        this.addButton.setLayoutData((Object)GridDataFactory.swtDefaults().create());
        this.addButton.setImage(SWTUtils.getImage((AbstractUIPlugin)UIPlugin.getDefault(), (String)"/icons/add.gif"));
        this.addButton.setToolTipText(StringUtil.ellipsify((String)CoreStrings.ADD));
        this.removeButton = new Button((Composite)group, 8);
        this.removeButton.setLayoutData((Object)GridDataFactory.swtDefaults().create());
        this.removeButton.setImage(SWTUtils.getImage((AbstractUIPlugin)UIPlugin.getDefault(), (String)"/icons/delete.gif"));
        this.removeButton.setToolTipText(CoreStrings.REMOVE);
        Composite composite = new Composite((Composite)sashForm, 0);
        composite.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        this.sitePropertiesWidget = new SiteConnectionPropertiesWidget(composite, 0, this);
        this.sitePropertiesWidget.setLayoutData(GridDataFactory.fillDefaults().grab(true, true).create());
        this.sitePropertiesWidget.setSource(null);
        sashForm.setWeights(new int[]{30, 70});
        this.sitesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISiteConnection selection = (ISiteConnection)((IStructuredSelection)event.getSelection()).getFirstElement();
                if (selection != SiteConnectionsEditorDialog.this.sitePropertiesWidget.getSource()) {
                    if (SiteConnectionsEditorDialog.this.doSelectionChange()) {
                        SiteConnectionsEditorDialog.this.sitePropertiesWidget.setSource(selection);
                    } else {
                        SiteConnectionsEditorDialog.this.sitesViewer.setSelection((ISelection)new StructuredSelection((Object)SiteConnectionsEditorDialog.this.sitePropertiesWidget.getSource()), true);
                    }
                }
                SiteConnectionsEditorDialog.this.removeButton.setEnabled(!event.getSelection().isEmpty() && selection != DefaultSiteConnection.getInstance());
            }
        });
        MenuManager menuManager = new MenuManager();
        this.createActions((IMenuManager)menuManager);
        this.sitesViewer.getControl().setMenu(menuManager.createContextMenu(this.sitesViewer.getControl()));
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SiteConnectionsEditorDialog.this.doSelectionChange()) {
                    SiteConnectionsEditorDialog.this.setCreateNew(Messages.SiteConnectionsEditorDialog_LBL_NewConnection, null, null);
                } else {
                    SiteConnectionsEditorDialog.this.sitesViewer.setSelection((ISelection)new StructuredSelection((Object)SiteConnectionsEditorDialog.this.sitePropertiesWidget.getSource()), true);
                }
            }
        });
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!SiteConnectionsEditorDialog.this.sitesViewer.getSelection().isEmpty() && MessageDialog.openConfirm((Shell)SiteConnectionsEditorDialog.this.getShell(), (String)Messages.SiteConnectionsEditorDialog_DeleteConfirm_Title, (String)Messages.SiteConnectionsEditorDialog_DeleteConfirm_Message)) {
                    ISiteConnection selection = (ISiteConnection)((IStructuredSelection)SiteConnectionsEditorDialog.this.sitesViewer.getSelection()).getFirstElement();
                    int newSelectionIndex = SiteConnectionsEditorDialog.this.sitesViewer.getList().getSelectionIndex() - 1;
                    SyncingPlugin.getSiteConnectionManager().removeSiteConnection(selection);
                    SiteConnectionsEditorDialog.this.sites.remove(selection);
                    SiteConnectionsEditorDialog.this.sitePropertiesWidget.setSource(null);
                    SiteConnectionsEditorDialog.this.sitesViewer.refresh();
                    if (newSelectionIndex > -1 && newSelectionIndex < SiteConnectionsEditorDialog.this.sitesViewer.getList().getItemCount()) {
                        SiteConnectionsEditorDialog.this.setSelection((ISiteConnection)(newSelectionIndex == 0 ? DefaultSiteConnection.getInstance() : (ISiteConnection)SiteConnectionsEditorDialog.this.sites.get(newSelectionIndex - 1)));
                    }
                }
            }
        });
        return dialogArea;
    }

    protected Control createContents(Composite parent) {
        try {
            Control control = super.createContents(parent);
            return control;
        }
        finally {
            if (this.initialSelection != null) {
                this.sitesViewer.setSelection((ISelection)new StructuredSelection((Object)this.initialSelection), true);
            }
        }
    }

    protected void createActions(IMenuManager menuManager) {
        menuManager.add((IAction)new Action(Messages.SiteConnectionsEditorDialog_LBL_Duplicate){

            public void run() {
                ISiteConnection siteConnection = (ISiteConnection)((IStructuredSelection)SiteConnectionsEditorDialog.this.sitesViewer.getSelection()).getFirstElement();
                if (siteConnection != null && SiteConnectionsEditorDialog.this.doSelectionChange()) {
                    try {
                        ISiteConnection newSite = SyncingPlugin.getSiteConnectionManager().cloneSiteConnection(siteConnection);
                        newSite.setName(MessageFormat.format("Copy of {0}", siteConnection.getName()));
                        SiteConnectionsEditorDialog.this.sites.add(newSite);
                        SiteConnectionsEditorDialog.this.sitesViewer.refresh();
                        SiteConnectionsEditorDialog.this.sitesViewer.setSelection((ISelection)new StructuredSelection((Object)newSite), true);
                    }
                    catch (CoreException e) {
                        UIUtils.showErrorMessage((String)Messages.SiteConnectionsEditorDialog_ERR_Duplicate, (Throwable)e);
                    }
                }
            }
        });
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 31, IDialogConstants.APPLY_LABEL, false);
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected boolean doSelectionChange() {
        if (this.sitePropertiesWidget.isChanged()) {
            MessageDialog dlg = new MessageDialog(this.getShell(), Messages.SiteConnectionsEditorDialog_SaveConfirm_Title, null, MessageFormat.format(Messages.SiteConnectionsEditorDialog_SaveConfirm_Message, this.sitePropertiesWidget.getSource().getName()), 3, new String[]{IDialogConstants.NO_LABEL, IDialogConstants.YES_LABEL, IDialogConstants.CANCEL_LABEL}, 1);
            switch (dlg.open()) {
                case 1: {
                    if (this.sitePropertiesWidget.applyChanges()) break;
                    MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.SiteConnectionsEditorDialog_UnresolvedWarning_Title, (String)Messages.SiteConnectionsEditorDialog_UnresolvedWarning_Message);
                }
                case 2: {
                    return false;
                }
            }
        }
        return true;
    }

    public void setErrorMessage(String newErrorMessage) {
        super.setErrorMessage(newErrorMessage);
        boolean hasError = newErrorMessage != null;
        Button button = this.getButton(31);
        if (button != null) {
            button.setEnabled(!hasError);
        }
        if ((button = this.getButton(0)) != null) {
            button.setEnabled(!hasError);
        }
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 31) {
            this.applyPressed();
        }
        super.buttonPressed(buttonId);
    }

    protected void cancelPressed() {
        this.sitePropertiesWidget.cancelChanges();
        super.cancelPressed();
    }

    protected void okPressed() {
        if (this.applyPressed()) {
            super.okPressed();
        }
    }

    protected boolean applyPressed() {
        ISiteConnection siteConnection;
        boolean applied;
        boolean bl = applied = !this.sitePropertiesWidget.isChanged() || this.sitePropertiesWidget.applyChanges();
        if (applied) {
            this.sitesViewer.refresh();
        }
        if ((siteConnection = this.sitePropertiesWidget.getSource()) != null) {
            if (siteConnection != DefaultSiteConnection.getInstance()) {
                SyncingPlugin.getSiteConnectionManager().addSiteConnection(siteConnection);
            }
            SyncingPlugin.getSiteConnectionManager().siteConnectionChanged(siteConnection);
        }
        return applied;
    }

    public void setSelection(ISiteConnection selection) {
        this.initialSelection = selection;
        if (this.sitesViewer != null) {
            this.sitesViewer.setSelection((ISelection)new StructuredSelection((Object)selection), true);
        }
    }

    private static String createUniqueSiteName(String baseName) {
        Pattern pattern = Pattern.compile("^(.*) (\\d+)$");
        Matcher matcher = pattern.matcher(baseName);
        if (matcher.matches()) {
            baseName = matcher.group(1);
        }
        int lastIndex = Integer.MIN_VALUE;
        ISiteConnection[] iSiteConnectionArray = SyncingPlugin.getSiteConnectionManager().getSiteConnections();
        int n = iSiteConnectionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISiteConnection i = iSiteConnectionArray[n2];
            String siteName = i.getName();
            if (siteName.startsWith(baseName)) {
                if (siteName.equals(baseName) && lastIndex == Integer.MIN_VALUE) {
                    lastIndex = 1;
                }
                if ((matcher = pattern.matcher(siteName)).matches()) {
                    try {
                        lastIndex = Math.max(lastIndex, Integer.parseInt(matcher.group(2)));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            ++n2;
        }
        if (lastIndex == Integer.MIN_VALUE) {
            return baseName;
        }
        return MessageFormat.format("{0} {1}", baseName, lastIndex + 1);
    }

    private static class SitesLabelProvider
    extends LabelProvider {
        private SitesLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof ISiteConnection) {
                return ((ISiteConnection)element).getName();
            }
            return super.getText(element);
        }
    }

    private static class SitesSorter
    extends ViewerComparator {
        private SitesSorter() {
        }

        public int category(Object element) {
            if (element == DefaultSiteConnection.getInstance()) {
                return 0;
            }
            return 1;
        }
    }
}

