/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.syncing.ui.handlers;

import com.aptana.ide.syncing.core.SiteConnectionUtils;
import com.aptana.ide.ui.io.IUniformFileStoreEditorInput;
import java.net.URI;
import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IURIEditorInput;

public abstract class BaseSyncHandler
extends AbstractHandler {
    private IAdaptable[] fSelectedResources;
    private boolean fSelectedFromSource = true;

    public boolean isEnabled() {
        if (this.fSelectedResources == null || this.fSelectedResources.length == 0) {
            return false;
        }
        IAdaptable[] iAdaptableArray = this.fSelectedResources;
        int n = this.fSelectedResources.length;
        int n2 = 0;
        while (n2 < n) {
            IAdaptable resource = iAdaptableArray[n2];
            if (SiteConnectionUtils.findSitesForSource((IAdaptable)resource).length > 0) {
                this.fSelectedFromSource = true;
                return true;
            }
            if (SiteConnectionUtils.findSitesWithDestination((IAdaptable)resource).length > 0) {
                this.fSelectedFromSource = false;
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void setEnabled(Object evaluationContext) {
        Object value;
        this.fSelectedResources = null;
        if (evaluationContext instanceof IEvaluationContext && (value = ((IEvaluationContext)evaluationContext).getVariable("selection")) instanceof ISelection) {
            ISelection selections = (ISelection)value;
            if (!selections.isEmpty() && selections instanceof IStructuredSelection) {
                Object[] resources = ((IStructuredSelection)selections).toArray();
                ArrayList<IAdaptable> list = new ArrayList<IAdaptable>();
                Object[] objectArray = resources;
                int n = resources.length;
                int n2 = 0;
                while (n2 < n) {
                    Object resource = objectArray[n2];
                    if (resource instanceof IAdaptable) {
                        list.add((IAdaptable)resource);
                    }
                    ++n2;
                }
                this.fSelectedResources = list.toArray(new IAdaptable[list.size()]);
            } else {
                value = ((IEvaluationContext)evaluationContext).getVariable("activeEditor");
                if (value instanceof IEditorPart) {
                    IFile resource = null;
                    IEditorInput editorInput = ((IEditorPart)value).getEditorInput();
                    if (editorInput instanceof IFileEditorInput) {
                        resource = ((IFileEditorInput)editorInput).getFile();
                    } else if (editorInput instanceof IUniformFileStoreEditorInput) {
                        try {
                            resource = EFS.getStore((URI)((IUniformFileStoreEditorInput)editorInput).getFileStore().toURI());
                        }
                        catch (CoreException coreException) {}
                    } else if (editorInput instanceof IURIEditorInput) {
                        try {
                            resource = EFS.getStore((URI)((IURIEditorInput)editorInput).getURI());
                        }
                        catch (CoreException coreException) {}
                    } else if (editorInput instanceof IPathEditorInput) {
                        try {
                            resource = EFS.getStore((URI)URIUtil.toURI((IPath)((IPathEditorInput)editorInput).getPath()));
                        }
                        catch (CoreException coreException) {
                            // empty catch block
                        }
                    }
                    if (resource != null) {
                        this.fSelectedResources = new IAdaptable[1];
                        this.fSelectedResources[0] = resource;
                    }
                }
            }
        }
    }

    protected IAdaptable[] getSelectedResources() {
        return this.fSelectedResources;
    }

    protected boolean isSelectionFromSource() {
        return this.fSelectedFromSource;
    }
}

