/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.syncing.ui.internal;

import com.aptana.core.io.efs.EFSUtils;
import com.aptana.ide.core.io.ConnectionPointUtils;
import com.aptana.ide.core.io.IConnectionPoint;
import com.aptana.ide.syncing.core.ISiteConnection;
import com.aptana.ide.ui.io.Utils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyncUtils {
    public static Set<ISiteConnection> getIntersection(Set<ISiteConnection>[] sets) {
        Set<ISiteConnection> set;
        HashSet<ISiteConnection> intersectionSet = new HashSet<ISiteConnection>();
        Set<ISiteConnection>[] setArray = sets;
        int n = sets.length;
        int n2 = 0;
        while (n2 < n) {
            set = setArray[n2];
            intersectionSet.addAll(set);
            ++n2;
        }
        setArray = sets;
        n = sets.length;
        n2 = 0;
        while (n2 < n) {
            set = setArray[n2];
            intersectionSet.retainAll(set);
            ++n2;
        }
        return intersectionSet;
    }

    public static IFileStore[] getFileStores(IAdaptable[] adaptable) {
        IFileStore[] fileStores = new IFileStore[adaptable.length];
        int i = 0;
        while (i < fileStores.length) {
            fileStores[i] = Utils.getFileStore((Object)adaptable[i]);
            ++i;
        }
        return fileStores;
    }

    public static IConnectionPoint findOrCreateConnectionPointFor(IAdaptable adaptable) {
        if (adaptable == null) {
            return null;
        }
        IConnectionPoint connectionPoint = (IConnectionPoint)adaptable.getAdapter(IConnectionPoint.class);
        if (connectionPoint != null) {
            return connectionPoint;
        }
        IResource resource = (IResource)adaptable.getAdapter(IResource.class);
        if (resource == null) {
            resource = (IResource)adaptable.getAdapter(IContainer.class);
        }
        if (resource instanceof IContainer) {
            return ConnectionPointUtils.findOrCreateWorkspaceConnectionPoint((IContainer)((IContainer)resource));
        }
        if (resource != null) {
            return ConnectionPointUtils.findOrCreateWorkspaceConnectionPoint((IContainer)resource.getParent());
        }
        File file = (File)adaptable.getAdapter(File.class);
        if (file != null) {
            return ConnectionPointUtils.findOrCreateLocalConnectionPoint((IPath)Path.fromOSString((String)file.getAbsolutePath()));
        }
        return null;
    }

    public static IFileStore[] getUploadFiles(IConnectionPoint sourceManager, IConnectionPoint destManager, IFileStore[] files, IProgressMonitor monitor) throws IOException, CoreException {
        HashSet<IFileStore> newFiles = new HashSet<IFileStore>();
        int i = 0;
        while (i < files.length) {
            IFileStore newFile;
            IFileStore file = files[i];
            IFileStore[] parents = SyncUtils.getParentDirectories(file, sourceManager);
            int j = 0;
            while (j < parents.length) {
                IFileStore file2 = parents[j];
                IFileStore newFile2 = EFSUtils.createFile((IFileStore)sourceManager.getRoot(), (IFileStore)file2, (IFileStore)destManager.getRoot());
                if (!newFiles.contains(newFile2)) {
                    newFiles.add(newFile2);
                }
                ++j;
            }
            if (file.fetchInfo().isDirectory()) {
                newFile = EFSUtils.createFile((IFileStore)sourceManager.getRoot(), (IFileStore)file, (IFileStore)destManager.getRoot());
                if (!newFiles.contains(newFile)) {
                    newFiles.add(newFile);
                }
                if (newFile.fetchInfo().exists()) {
                    newFiles.addAll(Arrays.asList(EFSUtils.getFiles((IFileStore)newFile, (boolean)true, (boolean)false, null)));
                }
            } else {
                newFile = EFSUtils.createFile((IFileStore)sourceManager.getRoot(), (IFileStore)file, (IFileStore)destManager.getRoot());
                if (!newFiles.contains(newFile)) {
                    newFiles.add(newFile);
                }
            }
            ++i;
        }
        return newFiles.toArray(new IFileStore[newFiles.size()]);
    }

    public static IFileStore[] getDownloadFiles(IConnectionPoint sourceManager, IConnectionPoint destManager, IFileStore[] files, boolean ignoreError, IProgressMonitor monitor) {
        return SyncUtils.getDownloadFiles(sourceManager, destManager, files, true, ignoreError, monitor);
    }

    public static IFileStore[] getDownloadFiles(IConnectionPoint sourceManager, IConnectionPoint destManager, IFileStore[] files, boolean fromSource, boolean ignoreError, IProgressMonitor monitor) {
        HashSet<IFileStore> newFiles = new HashSet<IFileStore>();
        IFileStore[] iFileStoreArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            IFileStore file = iFileStoreArray[n2];
            IFileStore newFile = null;
            try {
                if (file.fetchInfo().isDirectory()) {
                    newFile = fromSource ? EFSUtils.createFile((IFileStore)sourceManager.getRoot(), (IFileStore)file, (IFileStore)destManager.getRoot()) : file;
                    if (newFile.fetchInfo().exists()) {
                        IFileStore[] f = EFSUtils.getFiles((IFileStore)newFile, (boolean)true, (boolean)false, null);
                        if (!newFiles.contains(newFile)) {
                            newFiles.add(newFile);
                        }
                        newFiles.addAll(Arrays.asList(f));
                    }
                } else {
                    newFile = fromSource ? EFSUtils.createFile((IFileStore)sourceManager.getRoot(), (IFileStore)file, (IFileStore)destManager.getRoot()) : file;
                    if (newFile.fetchInfo().exists() && !newFiles.contains(newFile)) {
                        newFiles.add(newFile);
                    }
                }
            }
            catch (CoreException e) {
                if (newFile != null) {
                    // empty if block
                }
            }
            ++n2;
        }
        return newFiles.toArray(new IFileStore[newFiles.size()]);
    }

    public static IFileStore[] getParentDirectories(IFileStore file, IConnectionPoint sourceManager) throws CoreException {
        ArrayList<IFileStore> parentDirs = new ArrayList<IFileStore>();
        if (sourceManager.getRoot().isParentOf(file)) {
            IFileStore currentFile = file;
            while (currentFile != null) {
                if (currentFile.equals(sourceManager.getRoot())) break;
                parentDirs.add(0, currentFile);
                currentFile = currentFile.getParent();
            }
        }
        return parentDirs.toArray(new IFileStore[parentDirs.size()]);
    }
}

