/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.syncing.ui.navigator.actions;

import com.aptana.ide.syncing.core.SiteConnectionUtils;
import com.aptana.ide.syncing.ui.SyncingUIPlugin;
import com.aptana.ide.syncing.ui.navigator.actions.NavigatorBaseSyncAction;
import com.aptana.ide.syncing.ui.navigator.actions.NavigatorDownloadAction;
import com.aptana.ide.syncing.ui.navigator.actions.NavigatorSynchronizeAction;
import com.aptana.ide.syncing.ui.navigator.actions.NavigatorUploadAction;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;

public class SyncingActionProvider
extends CommonActionProvider {
    private static final String SYNC_IMAGE = "icons/full/elcl16/arrow_up_down.png";
    private static final String UPLOAD_IMAGE = "icons/full/elcl16/arrow_up.png";
    private static final String DOWNLOAD_IMAGE = "icons/full/elcl16/arrow_down.png";
    private static final String GROUP_SYNCING = "syncing";
    private NavigatorSynchronizeAction fSynchronizeAction;
    private NavigatorUploadAction fUploadAction;
    private NavigatorDownloadAction fDownloadAction;
    private boolean isToolbarFilled;
    private List<IContributionItem> hiddenItems = new ArrayList<IContributionItem>();

    public void dispose() {
        this.hiddenItems.clear();
        super.dispose();
    }

    public void init(ICommonActionExtensionSite aSite) {
        super.init(aSite);
        ICommonViewerSite viewerSite = aSite.getViewSite();
        IWorkbenchPart activePart = viewerSite instanceof ICommonViewerWorkbenchSite ? ((ICommonViewerWorkbenchSite)viewerSite).getPart() : PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        this.fSynchronizeAction = new NavigatorSynchronizeAction(activePart);
        this.fSynchronizeAction.setImageDescriptor(SyncingUIPlugin.getImageDescriptor(SYNC_IMAGE));
        this.fUploadAction = new NavigatorUploadAction(activePart);
        this.fUploadAction.setImageDescriptor(SyncingUIPlugin.getImageDescriptor(UPLOAD_IMAGE));
        this.fDownloadAction = new NavigatorDownloadAction(activePart);
        this.fDownloadAction.setImageDescriptor(SyncingUIPlugin.getImageDescriptor(DOWNLOAD_IMAGE));
    }

    public void fillActionBars(IActionBars actionBars) {
        Object element;
        boolean hasSyncConnection = false;
        IStructuredSelection selection = this.getSelection();
        if (!selection.isEmpty() && (element = selection.getFirstElement()) instanceof IAdaptable) {
            hasSyncConnection = SyncingActionProvider.hasSyncConnection((IAdaptable)element);
        }
        IToolBarManager toolbar = actionBars.getToolBarManager();
        if (!this.isToolbarFilled) {
            if (hasSyncConnection) {
                this.fillToolBar(toolbar);
                actionBars.updateActionBars();
                this.isToolbarFilled = true;
            }
        } else if (this.updateToolbar(toolbar, hasSyncConnection)) {
            actionBars.updateActionBars();
        }
        this.updateSelection();
    }

    protected void fillToolBar(IToolBarManager toolBar) {
        toolBar.add((IContributionItem)new GroupMarker(GROUP_SYNCING));
        toolBar.add((IAction)this.fSynchronizeAction);
        toolBar.add((IAction)this.fUploadAction);
        toolBar.add((IAction)this.fDownloadAction);
    }

    private IStructuredSelection getSelection() {
        return (IStructuredSelection)this.getContext().getSelection();
    }

    private void updateSelection() {
        IStructuredSelection selection = this.getSelection();
        this.fSynchronizeAction.selectionChanged(selection);
        this.fUploadAction.selectionChanged(selection);
        this.fDownloadAction.selectionChanged(selection);
    }

    private boolean updateToolbar(IToolBarManager toolbar, boolean hasSyncConnection) {
        boolean updated = false;
        IContributionItem[] items = toolbar.getItems();
        if (hasSyncConnection) {
            for (IContributionItem hiddenItem : this.hiddenItems) {
                toolbar.appendToGroup(GROUP_SYNCING, hiddenItem);
            }
            updated = this.hiddenItems.size() > 0;
            this.hiddenItems.clear();
        } else {
            IContributionItem[] iContributionItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                IContributionItem item = iContributionItemArray[n2];
                if (item instanceof ActionContributionItem && ((ActionContributionItem)item).getAction() instanceof NavigatorBaseSyncAction) {
                    toolbar.remove(item);
                    this.hiddenItems.add(item);
                    updated = true;
                }
                ++n2;
            }
        }
        return updated;
    }

    private static boolean hasSyncConnection(IAdaptable element) {
        return SiteConnectionUtils.findSitesForSource((IAdaptable)element).length > 0 || SiteConnectionUtils.findSitesWithDestination((IAdaptable)element).length > 0;
    }
}

