/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.syncing.ui.old.views;

import com.aptana.ide.syncing.core.old.ISyncResource;
import com.aptana.ide.syncing.core.old.SyncFile;
import com.aptana.ide.syncing.core.old.SyncFolder;
import com.aptana.ide.syncing.core.old.VirtualFileSyncPair;
import com.aptana.ide.syncing.ui.SyncingUIPlugin;
import com.aptana.ide.syncing.ui.old.views.FileLabelProvider;
import com.aptana.ide.syncing.ui.old.views.Messages;
import java.text.DateFormat;
import java.util.Date;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class SmartSyncLabelProvider
implements ITableLabelProvider,
ITableColorProvider {
    private FileLabelProvider fImages;
    private Color fNewColor;
    private Color fOverwriteColor;
    private Color fUpdateColor;
    private Color fDeleteColor;
    private Color fMixedColor;
    private Display fDisplay;
    private int fSyncDirection;
    private int fPresentationType;
    private boolean fDeleteRemoteFiles;
    private boolean fDeleteLocalFiles;

    public SmartSyncLabelProvider(Display display) {
        this.fDisplay = display;
        this.fImages = new FileLabelProvider();
        this.fNewColor = new Color((Device)this.fDisplay, new RGB(96, 180, 247));
        this.fOverwriteColor = new Color((Device)this.fDisplay, new RGB(255, 165, 0));
        this.fUpdateColor = new Color((Device)this.fDisplay, new RGB(173, 216, 230));
        this.fDeleteColor = this.fDisplay.getSystemColor(3);
        this.fMixedColor = new Color((Device)this.fDisplay, new RGB(164, 164, 164));
    }

    public void setSyncDirection(int direction) {
        this.fSyncDirection = direction;
    }

    public void setPresentationType(int type) {
        this.fPresentationType = type;
    }

    public void setDeleteRemoteFiles(boolean delete) {
        this.fDeleteRemoteFiles = delete;
    }

    public void setDeleteLocalFiles(boolean delete) {
        this.fDeleteLocalFiles = delete;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void dispose() {
        this.fImages.dispose();
        SmartSyncLabelProvider.disposeColor(this.fNewColor);
        SmartSyncLabelProvider.disposeColor(this.fOverwriteColor);
        SmartSyncLabelProvider.disposeColor(this.fUpdateColor);
        SmartSyncLabelProvider.disposeColor(this.fMixedColor);
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof ISyncResource) {
            ISyncResource resource = (ISyncResource)element;
            switch (columnIndex) {
                case 0: {
                    if (this.fPresentationType == 1) {
                        return ((ISyncResource)element).getName();
                    }
                    if (this.fPresentationType == 0) {
                        return ((ISyncResource)element).getPath().toString();
                    }
                }
                case 2: {
                    if (resource.isSkipped()) {
                        return Messages.SmartSyncDialog_Skipped;
                    }
                    if (this.fSyncDirection == 3 || this.fSyncDirection == 1) {
                        return "";
                    }
                    switch (resource.getSyncState()) {
                        case 5: {
                            if (this.fSyncDirection == 4) {
                                return Messages.SmartSyncDialog_Overwrite;
                            }
                            return Messages.SmartSyncDialog_Update;
                        }
                        case -2: {
                            return Messages.SmartSyncDialog_Modified;
                        }
                        case 6: 
                        case 9: {
                            return this.fDeleteLocalFiles ? Messages.SmartSyncDialog_Delete : "";
                        }
                        case 7: {
                            if (this.fSyncDirection != 4 && this.fSyncDirection != 2 && this.fDeleteRemoteFiles) break;
                            return Messages.SmartSyncDialog_New;
                        }
                    }
                    return "";
                }
                case 3: {
                    if (resource.isSkipped()) {
                        return Messages.SmartSyncDialog_Skipped;
                    }
                    if (this.fSyncDirection == 4 || this.fSyncDirection == 2) {
                        return "";
                    }
                    switch (resource.getSyncState()) {
                        case 4: {
                            if (this.fSyncDirection == 3) {
                                return Messages.SmartSyncDialog_Overwrite;
                            }
                            return Messages.SmartSyncDialog_Update;
                        }
                        case -2: {
                            return Messages.SmartSyncDialog_Modified;
                        }
                        case 7: 
                        case 10: {
                            return this.fDeleteRemoteFiles ? Messages.SmartSyncDialog_Delete : "";
                        }
                        case 6: {
                            if (this.fSyncDirection != 3 && this.fSyncDirection != 1 && this.fDeleteLocalFiles) break;
                            return Messages.SmartSyncDialog_New;
                        }
                    }
                    return "";
                }
                case 4: {
                    VirtualFileSyncPair pair = resource.getPair();
                    return pair == null ? "" : SmartSyncLabelProvider.getModificationDate(pair.getSourceFileInfo());
                }
                case 5: {
                    VirtualFileSyncPair pair = resource.getPair();
                    return pair == null ? "" : SmartSyncLabelProvider.getModificationDate(pair.getDestinationFileInfo());
                }
            }
            return "";
        }
        return "";
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            if (element instanceof ISyncResource) {
                ISyncResource resource = (ISyncResource)element;
                int state = resource.getTransferState();
                if (state == 1) {
                    return SyncingUIPlugin.getImage("icons/full/obj16/no.png");
                }
                if (state == 0) {
                    return SyncingUIPlugin.getImage("icons/full/obj16/ok.png");
                }
                return SyncingUIPlugin.getImage("icons/full/obj16/empty.png");
            }
            if (element instanceof SyncFile) {
                SyncFile file = (SyncFile)element;
                if (file.getPair() != null) {
                    if (file.getPair().getSourceFile() != null) {
                        return this.fImages.getImage(file.getPair().getSourceFile());
                    }
                    if (file.getPair().getDestinationFile() != null) {
                        return this.fImages.getImage(file.getPair().getDestinationFile());
                    }
                }
            } else if (element instanceof SyncFolder) {
                return SyncingUIPlugin.getImage("icons/full/obj16/folder.gif");
            }
        } else if (columnIndex == 1 && element instanceof ISyncResource) {
            ISyncResource resource = (ISyncResource)element;
            if (resource.isSkipped()) {
                return SyncingUIPlugin.getImage("icons/full/obj16/checked.gif");
            }
            return SyncingUIPlugin.getImage("icons/full/obj16/unchecked.gif");
        }
        return null;
    }

    public Color getBackground(Object element, int columnIndex) {
        if (element instanceof ISyncResource) {
            ISyncResource resource = (ISyncResource)element;
            Color color = this.fDisplay.getSystemColor(25);
            switch (columnIndex) {
                case 2: {
                    if (resource.isSkipped()) {
                        return color;
                    }
                    if (this.fSyncDirection == 3 || this.fSyncDirection == 1) {
                        return null;
                    }
                    switch (resource.getSyncState()) {
                        case 6: 
                        case 9: {
                            return this.fDeleteLocalFiles ? this.fDeleteColor : null;
                        }
                        case 7: {
                            if (this.fSyncDirection == 4 || this.fSyncDirection == 2 || !this.fDeleteRemoteFiles) {
                                return this.fNewColor;
                            }
                            return null;
                        }
                        case 5: {
                            if (this.fSyncDirection == 4) {
                                return this.fOverwriteColor;
                            }
                            return this.fUpdateColor;
                        }
                        case -2: {
                            return this.fMixedColor;
                        }
                    }
                    return null;
                }
                case 3: {
                    if (resource.isSkipped()) {
                        return color;
                    }
                    if (this.fSyncDirection == 4 || this.fSyncDirection == 2) {
                        return null;
                    }
                    switch (resource.getSyncState()) {
                        case 7: 
                        case 10: {
                            return this.fDeleteRemoteFiles ? this.fDeleteColor : null;
                        }
                        case 6: {
                            if (this.fSyncDirection == 3 || this.fSyncDirection == 1 || !this.fDeleteLocalFiles) {
                                return this.fNewColor;
                            }
                            return null;
                        }
                        case 4: {
                            if (this.fSyncDirection == 3) {
                                return this.fOverwriteColor;
                            }
                            return this.fUpdateColor;
                        }
                        case -2: {
                            return this.fMixedColor;
                        }
                    }
                    return null;
                }
            }
            return null;
        }
        return null;
    }

    public Color getForeground(Object element, int columnIndex) {
        ISyncResource resource;
        if (element instanceof ISyncResource && !(resource = (ISyncResource)element).isSkipped()) {
            Color color = this.fDisplay.getSystemColor(1);
            if (columnIndex == 2 ? !(resource.getSyncState() != 6 && resource.getSyncState() != 9 || !this.fDeleteLocalFiles || this.fSyncDirection != 0 && this.fSyncDirection != 2 && this.fSyncDirection != 4) : !(columnIndex != 3 || resource.getSyncState() != 7 && resource.getSyncState() != 10 || !this.fDeleteRemoteFiles || this.fSyncDirection != 0 && this.fSyncDirection != 1 && this.fSyncDirection != 3)) {
                return color;
            }
        }
        return null;
    }

    private static void disposeColor(Color color) {
        if (color != null && !color.isDisposed()) {
            color.dispose();
        }
    }

    private static String getModificationDate(IFileInfo file) {
        if (file == null) {
            return "";
        }
        Date d = new Date(file.getLastModified());
        DateFormat df = DateFormat.getDateTimeInstance(2, 2);
        return df.format(d);
    }
}

