/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.syncing.ui.properties;

import com.aptana.ide.syncing.core.ISiteConnection;
import com.aptana.ide.syncing.core.ResourceSynchronizationUtils;
import com.aptana.ide.syncing.core.SiteConnectionUtils;
import com.aptana.ide.syncing.ui.properties.Messages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPropertyPage;

public class SynchronizationPropertyPage
extends PreferencePage
implements IWorkbenchPropertyPage {
    private IContainer fResource;
    private Combo fSitesCombo;
    private Button fUseAsDefaultButton;

    protected Control createContents(Composite parent) {
        ISiteConnection[] sites;
        Composite main = new Composite(parent, 0);
        main.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        main.setLayout((Layout)layout);
        Label label = new Label(main, 16384);
        label.setText(Messages.SynchronizationPropertyPage_lastSyncConnection);
        this.fSitesCombo = new Combo(main, 12);
        ISiteConnection[] iSiteConnectionArray = sites = SiteConnectionUtils.findSitesForSource((IAdaptable)this.fResource);
        int n = sites.length;
        int n2 = 0;
        while (n2 < n) {
            ISiteConnection site = iSiteConnectionArray[n2];
            this.fSitesCombo.add(site.getDestination().getName());
            ++n2;
        }
        this.fSitesCombo.select(0);
        String connection = ResourceSynchronizationUtils.getLastSyncConnection((IContainer)this.fResource);
        if (connection != null && !connection.equals("")) {
            this.fSitesCombo.setText(connection);
        }
        this.fUseAsDefaultButton = new Button(main, 32);
        this.fUseAsDefaultButton.setText(Messages.SynchronizationPropertyPage_useConnectionsAsDefault);
        this.fUseAsDefaultButton.setSelection(ResourceSynchronizationUtils.isRememberDecision((IContainer)this.fResource));
        GridData gridData = new GridData(4, 4, true, false);
        gridData.horizontalSpan = 2;
        this.fUseAsDefaultButton.setLayoutData((Object)gridData);
        return main;
    }

    protected void performDefaults() {
        this.fUseAsDefaultButton.setSelection(false);
        this.fSitesCombo.select(0);
        super.performDefaults();
    }

    public boolean performOk() {
        ResourceSynchronizationUtils.setRememberDecision((IContainer)this.fResource, (boolean)this.fUseAsDefaultButton.getSelection());
        ResourceSynchronizationUtils.setLastSyncConnection((IContainer)this.fResource, (String)this.fSitesCombo.getText());
        return super.performOk();
    }

    public IAdaptable getElement() {
        return this.fResource;
    }

    public void setElement(IAdaptable element) {
        IResource resource;
        this.fResource = (IContainer)element.getAdapter(IContainer.class);
        if (this.fResource == null && (resource = (IResource)element.getAdapter(IResource.class)) != null) {
            this.fResource = resource.getProject();
        }
    }
}

