/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.syncing.ui.views;

import com.aptana.core.CoreStrings;
import com.aptana.core.util.StringUtil;
import com.aptana.ide.core.io.IConnectionPoint;
import com.aptana.ide.syncing.core.DefaultSiteConnection;
import com.aptana.ide.syncing.core.ISiteConnection;
import com.aptana.ide.syncing.core.SyncingPlugin;
import com.aptana.ide.syncing.core.events.ISiteConnectionListener;
import com.aptana.ide.syncing.core.events.SiteConnectionEvent;
import com.aptana.ide.syncing.core.old.ConnectionPointSyncPair;
import com.aptana.ide.syncing.core.old.ISyncEventHandler;
import com.aptana.ide.syncing.core.old.VirtualFileSyncPair;
import com.aptana.ide.syncing.core.old.handlers.SyncEventHandlerAdapter;
import com.aptana.ide.syncing.ui.SyncingUIPlugin;
import com.aptana.ide.syncing.ui.actions.DownloadAction;
import com.aptana.ide.syncing.ui.actions.UploadAction;
import com.aptana.ide.syncing.ui.dialogs.SiteConnectionsEditorDialog;
import com.aptana.ide.syncing.ui.editors.EditorUtils;
import com.aptana.ide.syncing.ui.internal.SyncUtils;
import com.aptana.ide.syncing.ui.old.views.SmartSyncDialog;
import com.aptana.ide.syncing.ui.views.ConnectionPointComposite;
import com.aptana.ide.syncing.ui.views.Messages;
import com.aptana.ide.ui.io.IOUIPlugin;
import com.aptana.ide.ui.io.Utils;
import com.aptana.ui.util.UIUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class FTPManagerComposite
implements SelectionListener,
ISiteConnectionListener,
ConnectionPointComposite.Client {
    private Composite fMain;
    private ComboViewer fSitesViewer;
    private Button fEditButton;
    private Button fSaveAsButton;
    private ConnectionPointComposite fSource;
    private ConnectionPointComposite fTarget;
    private Button fTransferSyncButton;
    private Button fTransferRightButton;
    private Button fTransferLeftButton;
    private ISiteConnection fSelectedSite;
    private List<Listener> fListeners = new ArrayList<Listener>();

    public FTPManagerComposite(Composite parent) {
        this.fMain = this.createControl(parent);
        SyncingPlugin.getSiteConnectionManager().addListener((ISiteConnectionListener)this);
    }

    public void addListener(Listener listener) {
        if (!this.fListeners.contains(listener)) {
            this.fListeners.add(listener);
        }
    }

    public void removeListener(Listener listener) {
        this.fListeners.remove(listener);
    }

    public void dispose() {
        this.fSelectedSite = null;
        this.fListeners.clear();
        SyncingPlugin.getSiteConnectionManager().removeListener((ISiteConnectionListener)this);
    }

    public Control getControl() {
        return this.fMain;
    }

    public void setFocus() {
        this.fMain.setFocus();
    }

    public void setSelectedSite(ISiteConnection siteConnection) {
        if (siteConnection == this.fSelectedSite) {
            return;
        }
        this.fSelectedSite = siteConnection;
        if (siteConnection == null) {
            this.fSitesViewer.setSelection((ISelection)StructuredSelection.EMPTY);
            this.fSource.setConnectionPoint(null);
            this.fTarget.setConnectionPoint(null);
        } else {
            if (siteConnection == DefaultSiteConnection.getInstance()) {
                this.fSitesViewer.setInput((Object)new ISiteConnection[]{siteConnection});
            } else {
                this.fSitesViewer.setInput((Object)SyncingPlugin.getSiteConnectionManager().getSiteConnections());
            }
            this.fSitesViewer.setSelection((ISelection)new StructuredSelection((Object)siteConnection));
            this.fSource.setConnectionPoint(siteConnection.getSource());
            this.fTarget.setConnectionPoint(siteConnection.getDestination());
        }
        this.fireSiteConnectionChanged(this.fSelectedSite);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        Object source = e.getSource();
        if (source == this.fEditButton) {
            SiteConnectionsEditorDialog dlg = new SiteConnectionsEditorDialog(this.fMain.getShell());
            dlg.setSelection((ISiteConnection)((IStructuredSelection)this.fSitesViewer.getSelection()).getFirstElement());
            dlg.open();
        } else if (source == this.fSaveAsButton) {
            this.saveAs();
        } else if (source == this.fTransferSyncButton) {
            this.syncSourceToDestination();
        } else if (source == this.fTransferRightButton) {
            this.transferSourceToDestination();
        } else if (source == this.fTransferLeftButton) {
            this.transferDestinationToSource();
        }
    }

    public void siteConnectionChanged(final SiteConnectionEvent event) {
        switch (event.getKind()) {
            case 1: 
            case 2: {
                if (this.fMain.isDisposed()) {
                    return;
                }
                this.fMain.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (FTPManagerComposite.this.fSelectedSite != DefaultSiteConnection.getInstance()) {
                            ISelection selection = FTPManagerComposite.this.fSitesViewer.getSelection();
                            FTPManagerComposite.this.fSitesViewer.setInput((Object)SyncingPlugin.getSiteConnectionManager().getSiteConnections());
                            FTPManagerComposite.this.fSitesViewer.setSelection(selection);
                        }
                    }
                });
                break;
            }
            case 4: {
                if (this.fMain.isDisposed()) {
                    return;
                }
                this.fMain.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        ISiteConnection siteConnection = event.getSiteConnection();
                        FTPManagerComposite.this.fSource.setConnectionPoint(siteConnection.getSource());
                        FTPManagerComposite.this.fTarget.setConnectionPoint(siteConnection.getDestination());
                    }
                });
            }
        }
    }

    public void transfer(ConnectionPointComposite source) {
        if (source == this.fSource) {
            this.transferSourceToDestination();
        } else if (source == this.fTarget) {
            this.transferDestinationToSource();
        }
    }

    protected Composite createControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 0;
        main.setLayout((Layout)layout);
        Composite top = this.createSiteInfo(main);
        top.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite middle = this.createSitePresentation(main);
        middle.setLayoutData((Object)new GridData(4, 4, true, true));
        return main;
    }

    private Composite createSiteInfo(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridLayout layout = new GridLayout(4, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        main.setLayout((Layout)layout);
        Label label = new Label(main, 0);
        label.setText(Messages.FTPManagerComposite_LBL_Sites);
        this.fSitesViewer = new ComboViewer(main, 8);
        this.fSitesViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.fSitesViewer.setLabelProvider((IBaseLabelProvider)new SitesLabelProvider());
        this.fSitesViewer.setInput((Object)SyncingPlugin.getSiteConnectionManager().getSiteConnections());
        this.fSitesViewer.getControl().setLayoutData((Object)GridDataFactory.swtDefaults().hint(250, -1).create());
        this.fSitesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                FTPManagerComposite.this.setSelectedSite((ISiteConnection)((IStructuredSelection)event.getSelection()).getFirstElement());
            }
        });
        this.fEditButton = new Button(main, 8);
        this.fEditButton.setText(StringUtil.ellipsify((String)CoreStrings.EDIT));
        this.fEditButton.setToolTipText(Messages.FTPManagerComposite_TTP_Edit);
        this.fEditButton.addSelectionListener((SelectionListener)this);
        this.fSaveAsButton = new Button(main, 8);
        this.fSaveAsButton.setText(StringUtil.ellipsify((String)Messages.FTPManagerComposite_LBL_SaveAs));
        this.fSaveAsButton.setToolTipText(Messages.FTPManagerComposite_TTP_SaveAs);
        this.fSaveAsButton.addSelectionListener((SelectionListener)this);
        return main;
    }

    private Composite createSitePresentation(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        main.setLayout((Layout)layout);
        this.fSource = new ConnectionPointComposite(main, Messages.FTPManagerComposite_LBL_Source, this);
        this.fSource.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        Composite directions = new Composite(main, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        directions.setLayout((Layout)layout);
        directions.setLayoutData((Object)new GridData(0x1000000, 4, false, true));
        this.fTransferRightButton = new Button(directions, 0);
        this.fTransferRightButton.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_FORWARD"));
        this.fTransferRightButton.setToolTipText(Messages.FTPManagerComposite_TTP_TransferRight);
        this.fTransferRightButton.setLayoutData((Object)new GridData(0x1000000, 0x1000008, true, true));
        this.fTransferRightButton.addSelectionListener((SelectionListener)this);
        this.fTransferLeftButton = new Button(directions, 0);
        this.fTransferLeftButton.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_BACK"));
        this.fTransferLeftButton.setToolTipText(Messages.FTPManagerComposite_TTP_TransferLeft);
        this.fTransferLeftButton.setLayoutData((Object)new GridData(0x1000000, 1, true, true));
        this.fTransferLeftButton.addSelectionListener((SelectionListener)this);
        this.fTransferSyncButton = new Button(directions, 0);
        this.fTransferSyncButton.setImage(SyncingUIPlugin.getImage("icons/full/elcl16/arrow_up_down.png"));
        this.fTransferSyncButton.setToolTipText(Messages.FTPManagerComposite_TTP_Synchronize);
        this.fTransferSyncButton.setLayoutData((Object)new GridData(0x1000000, 1, true, true));
        this.fTransferSyncButton.addSelectionListener((SelectionListener)this);
        this.fTarget = new ConnectionPointComposite(main, Messages.FTPManagerComposite_LBL_Target, this);
        this.fTarget.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        return main;
    }

    private void saveAs() {
        InputDialog dialog;
        ISiteConnection selection = (ISiteConnection)((IStructuredSelection)this.fSitesViewer.getSelection()).getFirstElement();
        String initialValue = "";
        if (selection != null) {
            initialValue = "Copy of " + selection.getName();
        }
        if ((dialog = new InputDialog(this.fMain.getShell(), Messages.FTPManagerComposite_NameInput_Title, Messages.FTPManagerComposite_NameInput_Message, initialValue, new IInputValidator(){

            public String isValid(String newText) {
                if (newText.length() == 0) {
                    return Messages.FTPManagerComposite_ERR_EmptyName;
                }
                ISiteConnection[] iSiteConnectionArray = SyncingPlugin.getSiteConnectionManager().getSiteConnections();
                int n = iSiteConnectionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ISiteConnection i = iSiteConnectionArray[n2];
                    if (newText.equals(i.getName())) {
                        return MessageFormat.format(Messages.FTPManagerComposite_ERR_NameExists, newText);
                    }
                    ++n2;
                }
                return null;
            }
        })).open() != 0) {
            return;
        }
        String name = dialog.getValue();
        ISiteConnection newSite = null;
        if (this.fSelectedSite != null) {
            try {
                newSite = SyncingPlugin.getSiteConnectionManager().cloneSiteConnection(this.fSelectedSite);
            }
            catch (CoreException e) {
                UIUtils.showErrorMessage((String)Messages.FTPManagerComposite_ERR_CreateNewSiteFailed, (Throwable)e);
                return;
            }
        } else {
            newSite = SyncingPlugin.getSiteConnectionManager().createSiteConnection();
        }
        newSite.setName(name);
        SyncingPlugin.getSiteConnectionManager().addSiteConnection(newSite);
        EditorUtils.openConnectionEditor(newSite);
    }

    private void syncSourceToDestination() {
        IConnectionPoint source = this.fSelectedSite.getSource();
        IConnectionPoint dest = this.fSelectedSite.getDestination();
        ConnectionPointSyncPair cpsp = new ConnectionPointSyncPair(source, dest);
        try {
            SmartSyncDialog dialog;
            IAdaptable[] sourceSelectedElements = this.fSource.getSelectedElements();
            IAdaptable[] targetSelectedElements = this.fTarget.getSelectedElements();
            IFileStore sourceStore = Utils.getFileStore((Object)this.fSource.getCurrentInput());
            IFileStore targetStore = Utils.getFileStore((Object)this.fTarget.getCurrentInput());
            if (sourceSelectedElements.length == 0 || targetSelectedElements.length == 0) {
                dialog = new SmartSyncDialog(UIUtils.getActiveShell(), source, dest, sourceStore, targetStore, source.getName(), dest.getName());
            } else {
                IFileStore[] iFileStoreArray;
                IFileStore[] sourceStores;
                IFileStore[] iFileStoreArray2;
                if (sourceSelectedElements.length == 0) {
                    IFileStore[] iFileStoreArray3 = new IFileStore[1];
                    iFileStoreArray2 = iFileStoreArray3;
                    iFileStoreArray3[0] = sourceStore;
                } else {
                    iFileStoreArray2 = sourceStores = SyncUtils.getFileStores(sourceSelectedElements);
                }
                if (targetSelectedElements.length == 0) {
                    IFileStore[] iFileStoreArray4 = new IFileStore[1];
                    iFileStoreArray = iFileStoreArray4;
                    iFileStoreArray4[0] = targetStore;
                } else {
                    iFileStoreArray = SyncUtils.getFileStores(targetSelectedElements);
                }
                IFileStore[] targetStores = iFileStoreArray;
                dialog = new SmartSyncDialog(UIUtils.getActiveShell(), cpsp, sourceStores, targetStores);
            }
            dialog.open();
            dialog.setHandler((ISyncEventHandler)new SyncEventHandlerAdapter(){

                public void syncDone(VirtualFileSyncPair item, IProgressMonitor monitor) {
                    IOUIPlugin.refreshNavigatorView((Object)FTPManagerComposite.this.fSource.getCurrentInput());
                    IOUIPlugin.refreshNavigatorView((Object)FTPManagerComposite.this.fTarget.getCurrentInput());
                    UIUtils.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            FTPManagerComposite.this.fSource.refresh();
                            FTPManagerComposite.this.fTarget.refresh();
                        }
                    });
                }
            });
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)UIUtils.getActiveShell(), (String)Messages.FTPManagerComposite_SyncErrorDialog_Title, (String)Messages.FTPManagerComposite_SyncErrorDialog_Message, (IStatus)e.getStatus());
        }
    }

    private void transferSourceToDestination() {
        UploadAction action = new UploadAction();
        action.setActivePart(null, UIUtils.getActivePart());
        action.setSelectedSite(this.fSelectedSite);
        action.setSelection((ISelection)new StructuredSelection((Object[])this.fSource.getSelectedElements()));
        action.setSourceRoot(Utils.getFileStore((Object)this.fSource.getCurrentInput()));
        action.setDestinationRoot(Utils.getFileStore((Object)this.fTarget.getCurrentInput()));
        action.addJobListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult() == Status.CANCEL_STATUS) {
                    return;
                }
                UIUtils.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        FTPManagerComposite.this.fTarget.refresh();
                    }
                });
            }
        });
        action.run(null);
    }

    private void transferDestinationToSource() {
        DownloadAction action = new DownloadAction();
        action.setActivePart(null, UIUtils.getActivePart());
        action.setSelectedSite(this.fSelectedSite);
        action.setSelection((ISelection)new StructuredSelection((Object[])this.fTarget.getSelectedElements()), false);
        action.setSourceRoot(Utils.getFileStore((Object)this.fSource.getCurrentInput()));
        action.setDestinationRoot(Utils.getFileStore((Object)this.fTarget.getCurrentInput()));
        action.addJobListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult() == Status.CANCEL_STATUS) {
                    return;
                }
                UIUtils.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        FTPManagerComposite.this.fSource.refresh();
                    }
                });
            }
        });
        action.run(null);
    }

    private void fireSiteConnectionChanged(ISiteConnection site) {
        for (Listener listener : this.fListeners) {
            listener.siteConnectionChanged(site);
        }
    }

    public static interface Listener {
        public void siteConnectionChanged(ISiteConnection var1);
    }

    private static class SitesLabelProvider
    extends LabelProvider {
        private SitesLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof ISiteConnection) {
                return ((ISiteConnection)element).getName();
            }
            return super.getText(element);
        }
    }
}

