/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core;

import com.aptana.core.IUserAgentManager;
import com.aptana.core.Messages;
import com.aptana.core.diagnostic.IDiagnosticManager;
import com.aptana.core.internal.UserAgentManager;
import com.aptana.core.internal.diagnostic.DiagnosticManager;
import com.aptana.core.internal.sourcemap.SourceMapRegistry;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.sourcemap.ISourceMapRegistry;
import com.aptana.core.util.EclipseUtil;
import com.eaio.uuid.MACAddress;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Formatter;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.framework.BundleContext;

public class CorePlugin
extends Plugin
implements IEclipsePreferences.IPreferenceChangeListener {
    public static final String PLUGIN_ID = "com.aptana.core";
    private static final String MID_SEPARATOR = "-";
    private static String mid;
    private static CorePlugin plugin;
    private BundleContext context;
    private UserAgentManager fUserAgentManager;
    private ISourceMapRegistry sourceMapRegistry;
    private IDiagnosticManager diagnosticManager;
    private ObjectMapper fJsonMapper;

    public void start(BundleContext context) throws Exception {
        this.context = context;
        super.start(context);
        plugin = this;
        Job job = new Job("Enable debugging and flush log cache"){

            protected IStatus run(IProgressMonitor monitor) {
                CorePlugin.this.enableDebugging();
                IdeLog.flushCache();
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    private void enableDebugging() {
        InstanceScope.INSTANCE.getNode(PLUGIN_ID).addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        IdeLog.StatusLevel currentSeverity = IdeLog.getSeverityPreference();
        IdeLog.setCurrentSeverity(currentSeverity);
        if (!Platform.inDebugMode()) {
            Boolean checked = Platform.getPreferencesService().getBoolean(PLUGIN_ID, "pref_enable_component_debugging", false, null);
            EclipseUtil.setPlatformDebugging(checked);
            if (checked.booleanValue()) {
                String[] components = EclipseUtil.getCurrentDebuggableComponents();
                EclipseUtil.setBundleDebugOptions(components, true);
            }
        }
    }

    public void stop(BundleContext context) throws Exception {
        this.sourceMapRegistry = null;
        this.diagnosticManager = null;
        try {
            InstanceScope.INSTANCE.getNode(PLUGIN_ID).removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
            this.fUserAgentManager = null;
            this.fJsonMapper = null;
        }
        finally {
            plugin = null;
            super.stop(context);
        }
    }

    public static CorePlugin getDefault() {
        return plugin;
    }

    public synchronized ISourceMapRegistry getSourceMapRegistry() {
        if (this.sourceMapRegistry == null) {
            this.sourceMapRegistry = new SourceMapRegistry();
        }
        return this.sourceMapRegistry;
    }

    public synchronized IDiagnosticManager getDiagnosticManager() {
        if (this.diagnosticManager == null) {
            this.diagnosticManager = new DiagnosticManager();
        }
        return this.diagnosticManager;
    }

    @Deprecated
    public static String getAptanaStudioVersion() {
        return EclipseUtil.getStudioVersion();
    }

    public BundleContext getContext() {
        return this.context;
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if ("pref_debug_level".equals(event.getKey())) {
            IdeLog.setCurrentSeverity(IdeLog.getSeverityPreference());
        }
    }

    public static String getMID() {
        if (mid == null) {
            mid = CorePlugin.generateMID();
        }
        return mid;
    }

    private static String generateMID() {
        Formatter formatter = new Formatter();
        try {
            byte[] result;
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] byArray = result = md.digest(MACAddress.getMACAddress().getBytes("UTF-8"));
            int n = result.length;
            int n2 = 0;
            while (n2 < n) {
                byte b = byArray[n2];
                formatter.format("%02x", b);
                ++n2;
            }
            String value = formatter.toString();
            StringBuilder buildMe = new StringBuilder();
            buildMe.append(value.substring(0, 8));
            buildMe.append(MID_SEPARATOR);
            buildMe.append(value.substring(8, 12));
            buildMe.append(MID_SEPARATOR);
            buildMe.append(value.substring(12, 16));
            buildMe.append(MID_SEPARATOR);
            buildMe.append(value.substring(16, 20));
            buildMe.append(MID_SEPARATOR);
            buildMe.append(value.substring(20, 32));
            String string = buildMe.toString();
            return string;
        }
        catch (NoSuchAlgorithmException e) {
            IdeLog.logWarning((Plugin)CorePlugin.getDefault(), Messages.CorePlugin_MD5_generation_error, e);
        }
        catch (UnsupportedEncodingException e) {
            IdeLog.logWarning((Plugin)CorePlugin.getDefault(), e);
        }
        finally {
            if (formatter != null) {
                formatter.close();
            }
        }
        return null;
    }

    public synchronized ObjectMapper getJsonMapper() {
        if (this.fJsonMapper == null) {
            this.fJsonMapper = new ObjectMapper();
            this.fJsonMapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        }
        return this.fJsonMapper;
    }

    public synchronized IUserAgentManager getUserAgentManager() {
        if (this.fUserAgentManager == null) {
            this.fUserAgentManager = new UserAgentManager();
        }
        return this.fUserAgentManager;
    }
}

