/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.build;

import com.aptana.core.Messages;
import com.aptana.core.util.StringUtil;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface IProblem {
    public static final String ID = "id";
    public static final String FLAGS = "flags";
    public static final String ARGUMENTS = "arguments";
    public static final String MARKER_PROBLEM_ID = "id";

    public int getOffset();

    public int getLength();

    public int getLineNumber();

    public String getMessage();

    public Severity getSeverity();

    public int getPriority();

    public String getSourcePath();

    public Map<String, Object> createMarkerAttributes();

    public Map<String, Object> getAttributes();

    public void setAttribute(String var1, Object var2);

    public boolean isWarning();

    public boolean isError();

    public boolean isTask();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Severity {
        IGNORE(-1, "ignore", Messages.IProblem_Ignore),
        INFO(0, "info", Messages.IProblem_Info),
        WARNING(1, "warning", Messages.IProblem_Warning),
        ERROR(2, "error", Messages.IProblem_Error);

        private final int num;
        private final String label;
        private final String id;

        private Severity(int num, String idenitifer, String label) {
            this.num = num;
            this.id = idenitifer;
            this.label = label;
        }

        public int intValue() {
            return this.num;
        }

        public String id() {
            return this.id;
        }

        public static Severity create(int value) {
            Severity[] severityArray = Severity.values();
            int n = severityArray.length;
            int n2 = 0;
            while (n2 < n) {
                Severity s = severityArray[n2];
                if (s.num == value) {
                    return s;
                }
                ++n2;
            }
            return WARNING;
        }

        public static Severity create(String value) {
            if (StringUtil.isEmpty(value)) {
                return IGNORE;
            }
            Severity[] severityArray = Severity.values();
            int n = severityArray.length;
            int n2 = 0;
            while (n2 < n) {
                Severity s = severityArray[n2];
                if (s.id.equalsIgnoreCase(value)) {
                    return s;
                }
                ++n2;
            }
            return IGNORE;
        }

        public String label() {
            return this.label;
        }
    }
}

