/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.internal;

import com.aptana.core.IMap;
import com.aptana.core.IUserAgent;
import com.aptana.core.IUserAgentManager;
import com.aptana.core.internal.LazyUserAgent;
import com.aptana.core.util.ArrayUtil;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.IConfigurationElementProcessor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;

public class UserAgentManager
implements IUserAgentManager {
    private static final String USERAGENT_ID = "userAgent";
    private static final String ELEMENT_USER_AGENT = "user-agent";
    private static final String ELEMENT_DEFAULT_USER_AGENTS = "default-user-agents";
    private static final String ELEMENT_USER_AGENT_REF = "user-agent-ref";
    private static final String ATTR_NATURE_ID = "nature-id";
    private static final String ATTR_USER_AGENT_ID = "user-agent-id";
    private static final String OTHER_NATURE_ID = "<other>";
    private static final Set<String> LAST_RESORT_DEFAULT_USER_AGENTS = CollectionsUtil.newSet("IE", "Mozilla", "Chrome");
    private Map<String, IUserAgent> fUserAgents;
    private HashMap<String, Set<String>> fDefaultUserAgents;

    public IUserAgent[] getAllUserAgents() {
        this.lazyLoad();
        return this.fUserAgents.values().toArray(new IUserAgent[this.fUserAgents.size()]);
    }

    private synchronized void lazyLoad() {
        if (this.fUserAgents == null || this.fDefaultUserAgents == null) {
            final HashSet userAgents = new HashSet();
            this.fDefaultUserAgents = new HashMap();
            EclipseUtil.processConfigurationElements("com.aptana.core", USERAGENT_ID, new IConfigurationElementProcessor(){

                @Override
                public void processElement(IConfigurationElement element) {
                    String elementName = element.getName();
                    if (UserAgentManager.ELEMENT_USER_AGENT.equals(elementName)) {
                        userAgents.add(new LazyUserAgent(element));
                    } else if (UserAgentManager.ELEMENT_DEFAULT_USER_AGENTS.equals(elementName)) {
                        String natureID = element.getAttribute(UserAgentManager.ATTR_NATURE_ID);
                        Object[] children = element.getChildren(UserAgentManager.ELEMENT_USER_AGENT_REF);
                        if (!ArrayUtil.isEmpty(children)) {
                            HashSet<String> userAgentIds = new HashSet<String>(children.length);
                            Object[] objectArray = children;
                            int n = children.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Object ref = objectArray[n2];
                                String userAgentID = ref.getAttribute(UserAgentManager.ATTR_USER_AGENT_ID);
                                userAgentIds.add(userAgentID);
                                ++n2;
                            }
                            UserAgentManager.this.fDefaultUserAgents.put(natureID, userAgentIds);
                        }
                    }
                }

                @Override
                public Set<String> getSupportElementNames() {
                    return CollectionsUtil.newSet(UserAgentManager.ELEMENT_USER_AGENT, UserAgentManager.ELEMENT_DEFAULT_USER_AGENTS);
                }
            });
            this.fUserAgents = CollectionsUtil.mapFromValues(userAgents, new IMap<IUserAgent, String>(){

                @Override
                public String map(IUserAgent item) {
                    return item.getID();
                }
            });
        }
    }

    public IUserAgent[] getDefaultUserAgents(String natureID) {
        this.lazyLoad();
        Set<String> ids = this.fDefaultUserAgents.containsKey(natureID) ? this.fDefaultUserAgents.get(natureID) : (this.fDefaultUserAgents.containsKey(OTHER_NATURE_ID) ? this.fDefaultUserAgents.get(OTHER_NATURE_ID) : LAST_RESORT_DEFAULT_USER_AGENTS);
        if (CollectionsUtil.isEmpty(ids)) {
            return NO_USER_AGENTS;
        }
        List<IUserAgent> result = CollectionsUtil.map(ids, new IMap<String, IUserAgent>(){

            @Override
            public IUserAgent map(String id) {
                return UserAgentManager.this.getUserAgentById(id);
            }
        });
        return result.toArray(new IUserAgent[result.size()]);
    }

    public IUserAgent getUserAgentById(String id) {
        this.lazyLoad();
        return this.fUserAgents.get(id);
    }

    public boolean addUserAgent(IUserAgent agent) {
        this.lazyLoad();
        this.fUserAgents.put(agent.getID(), agent);
        return true;
    }
}

