/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.util;

import com.aptana.core.CorePlugin;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.IOUtil;
import com.aptana.core.util.PlatformUtil;
import com.aptana.core.util.ZipUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class FirefoxUtil {
    private static final String VALUE_PATTERN = "^(.[^=]*)=(.*)$";
    private static final String SECTION_PATTERN = "^\\x5B(.*)\\x5D$";
    private static final String[] WIN32_PROFILES_LOCATIONS = new String[]{"%APPDATA%\\Mozilla\\Firefox\\"};
    private static final String[] LINUX_PROFILES_LOCATIONS = new String[]{"~/.mozilla/firefox/"};
    private static final String[] MACOSX_PROFILES_LOCATIONS = new String[]{"~/Library/Application Support/Firefox/", "~/Library/Mozilla/Firefox/"};
    private static final Map<String, String[]> LOCATIONS = new HashMap<String, String[]>();

    static {
        LOCATIONS.put("win32", WIN32_PROFILES_LOCATIONS);
        LOCATIONS.put("linux", LINUX_PROFILES_LOCATIONS);
        LOCATIONS.put("macosx", MACOSX_PROFILES_LOCATIONS);
    }

    private FirefoxUtil() {
    }

    public static IPath findDefaultProfileLocation() {
        return FirefoxUtil.findDefaultProfileLocation(LOCATIONS.get(Platform.getOS()));
    }

    protected static IPath findDefaultProfileLocation(String[] locations) {
        if (locations != null) {
            int i = 0;
            while (i < locations.length) {
                String location = PlatformUtil.expandEnvironmentStrings(locations[i]);
                File dir = new File(location);
                if (dir.isDirectory()) {
                    IdeLog.logInfo(CorePlugin.getDefault(), MessageFormat.format("Check location {0} for default profile", location), "com.aptana.core/debug/firefox");
                    File[] profiles = FirefoxUtil.readProfiles(dir);
                    if (profiles.length == 0) {
                        File dirProfiles = new File(dir, "Profiles");
                        if (!dirProfiles.exists() || !dirProfiles.isDirectory()) {
                            dirProfiles = dir;
                        }
                        profiles = dirProfiles.listFiles(new FilenameFilter(){

                            public boolean accept(File dir, String name) {
                                return name.endsWith(".default");
                            }
                        });
                    }
                    StringBuffer sb = new StringBuffer();
                    int j = 0;
                    while (j < profiles.length) {
                        if (j != 0) {
                            sb.append(',');
                        }
                        sb.append(profiles[j].toString());
                        ++j;
                    }
                    IdeLog.logInfo(CorePlugin.getDefault(), MessageFormat.format("Profiles found: {0}", sb.toString()), "com.aptana.core/debug/firefox");
                    File[] fileArray = profiles;
                    int n = profiles.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File profile = fileArray[n2];
                        if (profile.isDirectory()) {
                            IdeLog.logInfo(CorePlugin.getDefault(), MessageFormat.format("Default profile was found at {0}", profile.toString()), "com.aptana.core/debug/firefox");
                            return Path.fromOSString((String)profile.getAbsolutePath());
                        }
                        ++n2;
                    }
                }
                ++i;
            }
        }
        return null;
    }

    protected static File[] readProfiles(File dir) {
        ArrayList<File> list;
        block19: {
            list = new ArrayList<File>();
            File profilesIni = new File(dir, "profiles.ini");
            if (profilesIni.exists()) {
                BufferedReader r = null;
                try {
                    try {
                        String line;
                        r = new LineNumberReader(new FileReader(profilesIni));
                        LinkedHashMap sections = new LinkedHashMap();
                        HashMap<String, String> last = null;
                        Pattern sectionPattern = Pattern.compile(SECTION_PATTERN);
                        Pattern valuePattern = Pattern.compile(VALUE_PATTERN);
                        while ((line = ((LineNumberReader)r).readLine()) != null) {
                            Matcher matcher = sectionPattern.matcher(line);
                            if (matcher.find()) {
                                last = new HashMap<String, String>();
                                sections.put(matcher.group(1), last);
                                continue;
                            }
                            if (last == null || !(matcher = valuePattern.matcher(line)).find()) continue;
                            last.put(matcher.group(1), matcher.group(2));
                        }
                        for (Map.Entry entry : sections.entrySet()) {
                            if (!((String)entry.getKey()).startsWith("Profile")) continue;
                            Map properties = (Map)entry.getValue();
                            String path = (String)properties.get("Path");
                            String isRelative = (String)properties.get("IsRelative");
                            File profile = isRelative != null && "1".equals(isRelative) ? new File(dir, path) : new File(path);
                            boolean def = properties.containsKey("Default");
                            if (def) {
                                list.add(0, profile);
                                continue;
                            }
                            list.add(profile);
                        }
                    }
                    catch (IOException e) {
                        IdeLog.logWarning(CorePlugin.getDefault(), MessageFormat.format("Reading '{0}' fails", profilesIni.getAbsolutePath()), e, "com.aptana.core/debug/firefox");
                        if (r != null) {
                            try {
                                r.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block19;
                    }
                }
                catch (Throwable throwable) {
                    if (r != null) {
                        try {
                            r.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                if (r != null) {
                    try {
                        r.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
        return list.toArray(new File[list.size()]);
    }

    public static String getExtensionVersion(String extensionID, IPath profileDir) {
        try {
            IPath dir = profileDir.append("extensions").append(extensionID);
            InputStream rdfInputStream = null;
            if (dir.toFile().isFile()) {
                dir = Path.fromOSString((String)IOUtil.read(new FileInputStream(dir.toFile())));
            }
            if (dir.toFile().isDirectory()) {
                File installRdf = dir.append("install.rdf").toFile();
                if (installRdf.exists()) {
                    rdfInputStream = new FileInputStream(installRdf);
                }
            } else if (dir.addFileExtension("xpi").toFile().isFile()) {
                rdfInputStream = ZipUtil.openEntry(dir.addFileExtension("xpi").toFile(), Path.fromPortableString((String)"install.rdf"));
            }
            if (rdfInputStream != null) {
                NamedNodeMap attrs;
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder parser = factory.newDocumentBuilder();
                Document document = parser.parse(rdfInputStream);
                Node node = document.getDocumentElement().getFirstChild();
                while (node != null) {
                    if ("description".equals(node.getNodeName().toLowerCase()) || "rdf:description".equals(node.getNodeName().toLowerCase())) {
                        attrs = node.getAttributes();
                        Node about = attrs.getNamedItem("about");
                        if (about == null) {
                            about = attrs.getNamedItem("RDF:about");
                        }
                        if (about != null && "urn:mozilla:install-manifest".equals(about.getNodeValue())) break;
                    }
                    node = node.getNextSibling();
                }
                if (node != null) {
                    attrs = node.getAttributes();
                    Node version = attrs.getNamedItem("em:version");
                    if (version != null) {
                        return version.getNodeValue();
                    }
                    node = node.getFirstChild();
                }
                while (node != null) {
                    if ("em:version".equals(node.getNodeName().toLowerCase())) break;
                    node = node.getNextSibling();
                }
                if (node != null) {
                    return node.getTextContent();
                }
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)CorePlugin.getDefault(), e, "com.aptana.core/debug/firefox");
        }
        return null;
    }

    public static boolean installLinkedExtension(URL extensionURL, String extensionID, File dir) {
        boolean result;
        block14: {
            File file = new File(dir, extensionID);
            if (file.exists() && file.isDirectory()) {
                return true;
            }
            IPath base = CorePlugin.getDefault().getStateLocation().addTrailingSeparator();
            result = FirefoxUtil.installExtension(extensionURL, extensionID, base.toFile());
            if (result) {
                String linkedPath = base.append(extensionID).toOSString();
                FileOutputStream out = null;
                try {
                    try {
                        out = new FileOutputStream(file);
                        out.write(linkedPath.getBytes());
                    }
                    catch (IOException e) {
                        IdeLog.logError((Plugin)CorePlugin.getDefault(), e, "com.aptana.core/debug/firefox");
                        if (out == null) break block14;
                        try {
                            out.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                finally {
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
        return result;
    }

    public static boolean installExtension(URL extensionURL, String extensionID, File dir) {
        if ((dir = new File(dir, extensionID)).exists()) {
            return true;
        }
        if (!dir.mkdirs()) {
            return false;
        }
        File file = null;
        InputStream in = null;
        FileOutputStream out = null;
        try {
            try {
                int n;
                file = File.createTempFile("ffe", ".zip");
                in = extensionURL.openStream();
                out = new FileOutputStream(file);
                byte[] buffer = new byte[4096];
                while ((n = in.read(buffer)) > 0) {
                    out.write(buffer, 0, n);
                }
            }
            catch (IOException e) {
                IdeLog.logError((Plugin)CorePlugin.getDefault(), e, "com.aptana.core/debug/firefox");
                if (file != null && !file.delete()) {
                    file.deleteOnExit();
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return false;
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
        try {
            try {
                ZipUtil.extract(file, dir, null);
            }
            catch (IOException e) {
                IdeLog.logError((Plugin)CorePlugin.getDefault(), e, "com.aptana.core/debug/firefox");
                if (!file.delete()) {
                    file.deleteOnExit();
                }
                return false;
            }
        }
        finally {
            if (!file.delete()) {
                file.deleteOnExit();
            }
        }
        return dir.list().length > 0;
    }
}

