/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.util;

import com.aptana.core.util.StringUtil;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ProcessStatus
extends Status {
    private String stdout;
    private String stderr;

    ProcessStatus(String stdout, String stderr, Throwable t) {
        super(4, "com.aptana.core", t.getMessage(), t);
        this.stdout = stdout;
        this.stderr = stderr;
    }

    public ProcessStatus(int exitCode, String stdout, String stderr) {
        super(exitCode == 0 ? 0 : 4, "com.aptana.core", exitCode, ProcessStatus.generateMessage(exitCode, stdout, stderr), null);
        this.stdout = stdout;
        this.stderr = stderr;
    }

    private static String generateMessage(int exitCode, String stdOut, String stderr) {
        if (exitCode != 0 && StringUtil.isEmpty(stdOut)) {
            return stderr;
        }
        if (stdOut != null && stdOut.endsWith("\n")) {
            return stdOut.substring(0, stdOut.length() - 1);
        }
        if (!StringUtil.isEmpty(stderr)) {
            String[] lines = stderr.split("[\n\r]+");
            int i = lines.length - 1;
            while (i >= 0) {
                String line = lines[i];
                if (line.startsWith("[ERROR] :")) {
                    stdOut = String.valueOf(line.substring(9).trim()) + '\n' + stdOut;
                    break;
                }
                --i;
            }
        }
        return stdOut;
    }

    public String getStdErr() {
        return this.stderr;
    }

    public String getStdOut() {
        return this.stdout;
    }

    public IStatus getStdErrStatus() {
        return new Status(this.getSeverity(), this.getPlugin(), this.getCode(), this.getStdErr(), null);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("ProcessStatus");
        buf.append(" exitcode=");
        buf.append(this.getCode());
        buf.append(" stdout='");
        buf.append(this.getStdOut());
        buf.append("' stderr='");
        buf.append(this.getStdErr());
        buf.append('\'');
        return buf.toString();
    }
}

