/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.util;

import com.aptana.core.util.ProcessRunner;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessUtil {
    public static final String TEXT_TO_OBFUSCATE = "textToObfuscate";

    private ProcessUtil() {
    }

    public static String outputForCommand(String command, IPath workingDir, String ... args) {
        return ProcessUtil.outputForCommand(command, workingDir, null, args);
    }

    public static String outputForCommand(String command, IPath workingDir, Map<String, String> env, String ... args) {
        IStatus result = ProcessUtil.runInBackground(command, workingDir, env, args);
        if (result == null) {
            return null;
        }
        return result.getMessage();
    }

    public static IStatus runInBackground(String command, IPath workingDir, String ... args) {
        ArrayList<String> arguments = new ArrayList<String>(Arrays.asList(args));
        arguments.add(0, command);
        return new ProcessRunner().runInBackground(workingDir, arguments.toArray(new String[arguments.size()]));
    }

    public static IStatus runInBackground(String command, IPath workingDir, Map<String, String> env, String ... args) {
        ArrayList<String> arguments = new ArrayList<String>(Arrays.asList(args));
        arguments.add(0, command);
        return new ProcessRunner().runInBackground(workingDir, env, arguments.toArray(new String[arguments.size()]));
    }

    public static String outputForProcess(Process process) {
        return new ProcessRunner().outputForProcess(process);
    }

    public static IStatus processResult(Process process) {
        return new ProcessRunner().processResult(process);
    }

    public static Process run(String command, IPath workingDirectory, Map<String, String> environment, String ... arguments) throws IOException, CoreException {
        ArrayList<String> args = new ArrayList<String>(Arrays.asList(arguments));
        args.add(0, command);
        return new ProcessRunner().run(workingDirectory, environment, args.toArray(new String[args.size()]));
    }

    public static int waitForProcess(Process process, final long timeout, boolean forceKillAfterTimeout) {
        final Thread waitingThread = Thread.currentThread();
        Thread timeoutThread = new Thread(){

            public void run() {
                try {
                    Thread.sleep(timeout);
                    waitingThread.interrupt();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        int exitcode = -1;
        if (timeout > 0L) {
            block9: {
                try {
                    try {
                        timeoutThread.start();
                        exitcode = process.waitFor();
                    }
                    catch (InterruptedException e) {
                        Thread.interrupted();
                        timeoutThread.interrupt();
                        break block9;
                    }
                }
                catch (Throwable throwable) {
                    timeoutThread.interrupt();
                    throw throwable;
                }
                timeoutThread.interrupt();
            }
            if (forceKillAfterTimeout) {
                process.destroy();
            }
        }
        try {
            exitcode = process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return exitcode;
    }
}

