/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.util;

import com.aptana.core.CorePlugin;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.ArrayUtil;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.Messages;
import com.aptana.core.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNatureDescriptor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceUtil {
    private static final String UNC_PREFIX = "//";
    private static final String SCHEME_FILE = "file";
    private static final String APTANA_NATURE_PREFIX = "com.aptana.";
    private static final String RAILS_NATURE_PREFIX = "org.radrails.rails.";
    private static final String APPCELERATOR_NATURE_PREFIX = "com.appcelerator.";

    private ResourceUtil() {
    }

    public static File resourcePathToFile(URL url) {
        URI fileURI = ResourceUtil.resourcePathToURI(url);
        return fileURI == null ? null : new File(fileURI);
    }

    public static String resourcePathToString(URL url) {
        File file = ResourceUtil.resourcePathToFile(url);
        return file == null ? null : file.getAbsolutePath();
    }

    public static URI resourcePathToURI(URL url) {
        if (url == null) {
            return null;
        }
        try {
            URL fileURL = FileLocator.toFileURL((URL)url);
            return ResourceUtil.toURI(fileURL);
        }
        catch (IOException e) {
            String message = MessageFormat.format(Messages.ResourceUtils_URL_To_File_URL_Conversion_Error, url);
            IdeLog.logError((Plugin)CorePlugin.getDefault(), message, e);
        }
        catch (URISyntaxException e) {
            String message = MessageFormat.format(Messages.ResourceUtils_File_URL_To_URI_Conversion_Error, url);
            IdeLog.logError((Plugin)CorePlugin.getDefault(), message, e);
        }
        return null;
    }

    public static URI toURI(URL url) throws URISyntaxException {
        if (url == null) {
            return null;
        }
        if (SCHEME_FILE.equals(url.getProtocol())) {
            String pathString = url.toExternalForm().substring(5);
            if (pathString.indexOf(47) != 0) {
                pathString = String.valueOf('/') + pathString;
            } else if (pathString.startsWith(UNC_PREFIX) && !pathString.startsWith(UNC_PREFIX, 2)) {
                pathString = ResourceUtil.ensureUNCPath(pathString);
            }
            return new URI(SCHEME_FILE, null, pathString, null);
        }
        try {
            return new URI(url.toExternalForm());
        }
        catch (URISyntaxException e) {
            return new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getRef());
        }
    }

    private static String ensureUNCPath(String path) {
        int len = path.length();
        StringBuilder result = new StringBuilder(len);
        int i = 0;
        while (i < 4) {
            if (i >= len || path.charAt(i) != '/') {
                result.append('/');
            }
            ++i;
        }
        result.append(path);
        return result.toString();
    }

    public static String getLineSeparatorValue(IProject project) {
        Object scope = project != null ? new ProjectScope(project) : InstanceScope.INSTANCE;
        IScopeContext[] scopeContext = new IScopeContext[]{scope};
        IEclipsePreferences node = scopeContext[0].getNode("org.eclipse.core.runtime");
        return node.get("line.separator", System.getProperty("line.separator"));
    }

    public static boolean addBuilder(IProject project, String id) throws CoreException {
        if (project == null) {
            return false;
        }
        IProjectDescription desc = project.getDescription();
        if (ResourceUtil.addBuilder(desc, id)) {
            project.setDescription(desc, null);
            return true;
        }
        return false;
    }

    public static boolean addBuilder(IProjectDescription description, String builderId) {
        ICommand command;
        ICommand[] commands = description.getBuildSpec();
        boolean addBuilder = true;
        ICommand[] iCommandArray = commands;
        int n = commands.length;
        int n2 = 0;
        while (n2 < n) {
            String configHandler;
            Object value;
            command = iCommandArray[n2];
            if (command.getBuilderName().equals(builderId)) {
                addBuilder = false;
                break;
            }
            Map arguments = command.getArguments();
            if (arguments != null && (value = arguments.get("LaunchConfigHandle")) != null && (configHandler = value.toString()) != null && configHandler.indexOf(builderId) > -1) {
                addBuilder = false;
                break;
            }
            ++n2;
        }
        if (addBuilder) {
            command = description.newCommand();
            command.setBuilderName(builderId);
            ICommand[] nc = new ICommand[commands.length + 1];
            System.arraycopy(commands, 0, nc, 1, commands.length);
            nc[0] = command;
            description.setBuildSpec(nc);
        }
        return addBuilder;
    }

    public static boolean removeBuilder(IProject project, String id) throws CoreException {
        IProjectDescription desc = project.getDescription();
        if (ResourceUtil.removeBuilder(desc, id)) {
            project.setDescription(desc, null);
            return true;
        }
        return false;
    }

    public static boolean removeBuilder(IProjectDescription description, String builderId) {
        ICommand[] commands = description.getBuildSpec();
        boolean removeBuilder = false;
        ArrayList<ICommand> builders = new ArrayList<ICommand>();
        ICommand[] iCommandArray = commands;
        int n = commands.length;
        int n2 = 0;
        while (n2 < n) {
            ICommand command = iCommandArray[n2];
            if (!command.getBuilderName().equals(builderId)) {
                builders.add(command);
            } else {
                removeBuilder = true;
            }
            ++n2;
        }
        description.setBuildSpec(builders.toArray(new ICommand[builders.size()]));
        return removeBuilder;
    }

    public static boolean addNature(IProject project, String id) throws CoreException {
        IProjectDescription desc = project.getDescription();
        if (ResourceUtil.addNature(desc, id)) {
            project.setDescription(desc, null);
            return true;
        }
        return false;
    }

    public static boolean addNature(IProjectDescription description, String natureId) {
        String[] natures = description.getNatureIds();
        boolean addNature = true;
        String[] stringArray = natures;
        int n = natures.length;
        int n2 = 0;
        while (n2 < n) {
            String nature = stringArray[n2];
            if (nature.equals(natureId)) {
                addNature = false;
                break;
            }
            ++n2;
        }
        if (addNature) {
            String[] newNatures = new String[natures.length + 1];
            System.arraycopy(natures, 0, newNatures, 0, natures.length);
            newNatures[natures.length] = natureId;
            description.setNatureIds(newNatures);
        }
        return addNature;
    }

    public static boolean removeNature(IProject project, String id) throws CoreException {
        IProjectDescription desc = project.getDescription();
        if (ResourceUtil.removeNature(desc, id)) {
            project.setDescription(desc, null);
            return true;
        }
        return false;
    }

    public static boolean removeNature(IProjectDescription description, String natureId) {
        String[] natures = description.getNatureIds();
        boolean removeNature = false;
        ArrayList<String> newNatures = new ArrayList<String>();
        String[] stringArray = natures;
        int n = natures.length;
        int n2 = 0;
        while (n2 < n) {
            String nature = stringArray[n2];
            if (!nature.equals(natureId)) {
                newNatures.add(nature);
            } else {
                removeNature = true;
            }
            ++n2;
        }
        description.setNatureIds(newNatures.toArray(new String[newNatures.size()]));
        return removeNature;
    }

    public static boolean isAptanaNature(String natureId) {
        return natureId != null && (natureId.startsWith(APTANA_NATURE_PREFIX) || natureId.startsWith(RAILS_NATURE_PREFIX) || natureId.startsWith(APPCELERATOR_NATURE_PREFIX));
    }

    public static String[] getAptanaNatures(IProjectDescription description) {
        String[] natures = description.getNatureIds();
        ArrayList<String> newNatures = new ArrayList<String>();
        String[] stringArray = natures;
        int n = natures.length;
        int n2 = 0;
        while (n2 < n) {
            String nature = stringArray[n2];
            if (ResourceUtil.isAptanaNature(nature)) {
                newNatures.add(nature);
            }
            ++n2;
        }
        return newNatures.toArray(new String[newNatures.size()]);
    }

    public static Map<String, String> getAptanaNaturesMap() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProjectNatureDescriptor[] natureDescriptors = workspace.getNatureDescriptors();
        HashMap<String, String> result = new HashMap<String, String>();
        IProjectNatureDescriptor[] iProjectNatureDescriptorArray = natureDescriptors;
        int n = natureDescriptors.length;
        int n2 = 0;
        while (n2 < n) {
            IProjectNatureDescriptor natureDescriptor = iProjectNatureDescriptorArray[n2];
            if (ResourceUtil.isAptanaNature(natureDescriptor.getNatureId())) {
                result.put(natureDescriptor.getLabel(), natureDescriptor.getNatureId());
            }
            ++n2;
        }
        return result;
    }

    public static boolean removeBuilderIfOrphaned(IProject project, String builderId) throws CoreException {
        String[] natures = ResourceUtil.getAptanaNatures(project.getDescription());
        if (natures.length == 0) {
            return ResourceUtil.removeBuilder(project, builderId);
        }
        return false;
    }

    public static boolean shouldIgnore(IFile file) {
        return file == null || !file.exists() || file.isTeamPrivateMember(512) || file.isDerived(512);
    }

    public static boolean isAccessible(IProject project) {
        return project != null && project.isAccessible();
    }

    public static IProjectDescription getProjectDescription(IPath projectPath, String[] natureIds, String[] builderIds) {
        if (projectPath == null) {
            return null;
        }
        IProjectDescription description = null;
        IPath dotProjectPath = projectPath.append(".project");
        File dotProjectFile = dotProjectPath.toFile();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (dotProjectFile.exists()) {
            try {
                description = workspace.loadProjectDescription(dotProjectPath);
                if (Platform.getLocation().isPrefixOf(projectPath)) {
                    description.setLocation(null);
                }
            }
            catch (CoreException e) {
                IdeLog.logWarning((Plugin)CorePlugin.getDefault(), "Failed to load the existing .project file.", e);
            }
        }
        if (description == null) {
            description = workspace.newProjectDescription(projectPath.lastSegment());
            if (Platform.getLocation().isPrefixOf(projectPath)) {
                description.setLocation(null);
            } else {
                description.setLocation(projectPath);
            }
        }
        if (!ArrayUtil.isEmpty(natureIds)) {
            Set<String> natures = CollectionsUtil.newInOrderSet(natureIds);
            CollectionsUtil.addToSet(natures, description.getNatureIds());
            description.setNatureIds(natures.toArray(new String[natures.size()]));
        }
        if (!ArrayUtil.isEmpty(builderIds)) {
            ICommand[] existingBuilders = description.getBuildSpec();
            List<ICommand> builders = CollectionsUtil.newList(existingBuilders);
            String[] stringArray = builderIds;
            int n = builderIds.length;
            int n2 = 0;
            while (n2 < n) {
                String builderId = stringArray[n2];
                if (!ResourceUtil.hasBuilder(builderId, existingBuilders)) {
                    ICommand newBuilder = description.newCommand();
                    newBuilder.setBuilderName(builderId);
                    builders.add(newBuilder);
                }
                ++n2;
            }
            description.setBuildSpec(builders.toArray(new ICommand[builders.size()]));
        }
        return description;
    }

    private static boolean hasBuilder(String builderName, ICommand[] builders) {
        if (StringUtil.isEmpty(builderName)) {
            return false;
        }
        ICommand[] iCommandArray = builders;
        int n = builders.length;
        int n2 = 0;
        while (n2 < n) {
            ICommand builder = iCommandArray[n2];
            if (builderName.equals(builder.getBuilderName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

