/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;

public class StreamUtil {
    private static final int DEFAULT_SIZE = 15360;

    private StreamUtil() {
    }

    public static String readContent(InputStream stream) throws IOException {
        return StreamUtil.readContent(stream, null);
    }

    public static String readContent(InputStream stream, String charset) throws IOException {
        if (stream == null) {
            return null;
        }
        BufferedReader reader = StreamUtil.getBufferedReader(stream, charset);
        try {
            StringBuilder buffer = new StringBuilder();
            char[] readBuffer = new char[2048];
            int n = reader.read(readBuffer);
            while (n > 0) {
                buffer.append(readBuffer, 0, n);
                n = reader.read(readBuffer);
            }
            String string = buffer.toString();
            return string;
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static BufferedReader getBufferedReader(InputStream stream, String charset) throws UnsupportedEncodingException {
        InputStreamReader inputReader = charset == null ? new InputStreamReader(stream) : new InputStreamReader(stream, charset);
        return new BufferedReader(inputReader, 15360);
    }
}

