/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public class WriterOutputStream
extends OutputStream {
    protected Writer writer;
    protected String charset;
    private byte[] buff;

    public WriterOutputStream(Writer writer) {
        this(writer, null);
    }

    public WriterOutputStream(Writer writer, String charset) {
        this.writer = writer;
        this.charset = charset;
        this.buff = new byte[1];
    }

    public void close() throws IOException {
        this.writer.flush();
        this.writer.close();
        this.writer = null;
        this.charset = null;
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public void write(int b) throws IOException {
        this.buff[0] = (byte)b;
        this.write(this.buff);
    }

    public void write(byte[] b) throws IOException {
        if (this.charset == null) {
            this.writer.write(new String(b));
        } else {
            this.writer.write(new String(b, this.charset));
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.charset == null) {
            this.writer.write(new String(b, off, len));
        } else {
            this.writer.write(new String(b, off, len, this.charset));
        }
    }
}

