/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.json;

import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonContentAssistProcessor;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.CommonUtil;
import com.aptana.editor.common.IPartitioningConfiguration;
import com.aptana.editor.common.ISourceViewerConfiguration;
import com.aptana.editor.common.scripting.IContentTypeTranslator;
import com.aptana.editor.common.scripting.QualifiedContentType;
import com.aptana.editor.common.text.rules.ISubPartitionScanner;
import com.aptana.editor.common.text.rules.SubPartitionScanner;
import com.aptana.editor.common.text.rules.ThemeingDamagerRepairer;
import com.aptana.editor.json.JSONEscapeSequenceScanner;
import com.aptana.editor.json.JSONSourceScanner;
import com.aptana.editor.json.text.rules.JSONPropertyRule;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;

public class JSONSourceConfiguration
implements IPartitioningConfiguration,
ISourceViewerConfiguration {
    public static final String PREFIX = "__json__";
    public static final String DEFAULT = "__json__dftl_partition_content_type";
    public static final String STRING_DOUBLE = "__json__string_double";
    public static final String STRING_SINGLE = "__json__string_single";
    public static final String PROPERTY = "__json__property";
    public static final String[] CONTENT_TYPES = new String[]{"__json__dftl_partition_content_type", "__json__string_double", "__json__string_single", "__json__property"};
    private static final String[][] TOP_CONTENT_TYPES = new String[][]{{"com.aptana.contenttype.json"}};
    private IPredicateRule[] partitioningRules = new IPredicateRule[]{new JSONPropertyRule(JSONSourceConfiguration.getToken("__json__string_single"), JSONSourceConfiguration.getToken("__json__string_double"), JSONSourceConfiguration.getToken("__json__property"))};
    private static JSONSourceConfiguration instance;

    private JSONSourceConfiguration() {
    }

    public static JSONSourceConfiguration getDefault() {
        if (instance == null) {
            IContentTypeTranslator c = CommonEditorPlugin.getDefault().getContentTypeTranslator();
            c.addTranslation(new QualifiedContentType(new String[]{"com.aptana.contenttype.json"}), new QualifiedContentType(new String[]{"source.json"}));
            c.addTranslation(new QualifiedContentType(new String[]{PROPERTY}), new QualifiedContentType(new String[]{"property.json"}));
            c.addTranslation(new QualifiedContentType(new String[]{STRING_DOUBLE}), new QualifiedContentType(new String[]{"string.quoted.double.json"}));
            c.addTranslation(new QualifiedContentType(new String[]{STRING_SINGLE}), new QualifiedContentType(new String[]{"string.quoted.single.json"}));
            instance = new JSONSourceConfiguration();
        }
        return instance;
    }

    public ISubPartitionScanner createSubPartitionScanner() {
        return new SubPartitionScanner(this.partitioningRules, CONTENT_TYPES, JSONSourceConfiguration.getToken(DEFAULT));
    }

    public String[] getContentTypes() {
        return CONTENT_TYPES;
    }

    public String getDocumentContentType(String contentType) {
        if (contentType.startsWith(PREFIX)) {
            return "com.aptana.contenttype.json";
        }
        return null;
    }

    private ITokenScanner getCodeScanner() {
        return new JSONSourceScanner();
    }

    public IPredicateRule[] getPartitioningRules() {
        return this.partitioningRules;
    }

    private static IToken getToken(String tokenName) {
        return CommonUtil.getToken((String)tokenName);
    }

    public String[][] getTopContentTypes() {
        return TOP_CONTENT_TYPES;
    }

    public void setupPresentationReconciler(PresentationReconciler reconciler, ISourceViewer sourceViewer) {
        ThemeingDamagerRepairer dr = new ThemeingDamagerRepairer(this.getCodeScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        reconciler.setDamager((IPresentationDamager)dr, DEFAULT);
        reconciler.setRepairer((IPresentationRepairer)dr, DEFAULT);
        ThemeingDamagerRepairer p = new ThemeingDamagerRepairer((ITokenScanner)new JSONEscapeSequenceScanner("property.json"));
        reconciler.setDamager((IPresentationDamager)p, PROPERTY);
        reconciler.setRepairer((IPresentationRepairer)p, PROPERTY);
        ThemeingDamagerRepairer dqs = new ThemeingDamagerRepairer((ITokenScanner)new JSONEscapeSequenceScanner("string.quoted.double.json"));
        reconciler.setDamager((IPresentationDamager)dqs, STRING_DOUBLE);
        reconciler.setRepairer((IPresentationRepairer)dqs, STRING_DOUBLE);
        ThemeingDamagerRepairer sqs = new ThemeingDamagerRepairer((ITokenScanner)new JSONEscapeSequenceScanner("string.quoted.single.json"));
        reconciler.setDamager((IPresentationDamager)sqs, STRING_SINGLE);
        reconciler.setRepairer((IPresentationRepairer)sqs, STRING_SINGLE);
    }

    public IContentAssistProcessor getContentAssistProcessor(AbstractThemeableEditor editor, String contentType) {
        return new CommonContentAssistProcessor(editor);
    }
}

