/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.json.outline;

import com.aptana.editor.common.outline.CommonOutlineItem;
import com.aptana.editor.json.JSONPlugin;
import com.aptana.json.core.parsing.ast.JSONEntryNode;
import com.aptana.json.core.parsing.ast.JSONNode;
import com.aptana.parsing.ast.IParseNode;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class JSONOutlineLabelProvider
extends LabelProvider {
    private static final Image ARRAY = JSONPlugin.getImage("icons/array-literal.png");
    private static final Image BOOLEAN = JSONPlugin.getImage("icons/boolean.png");
    private static final Image NULL = JSONPlugin.getImage("icons/null.png");
    private static final Image NUMBER = JSONPlugin.getImage("icons/number.png");
    private static final Image OBJECT = JSONPlugin.getImage("icons/object-literal.png");
    private static final Image STRING = JSONPlugin.getImage("icons/string.png");

    public Image getImage(Object element) {
        Image result = null;
        if (element instanceof JSONNode) {
            JSONNode node = (JSONNode)element;
            switch (node.getType()) {
                case ARRAY: {
                    result = ARRAY;
                    break;
                }
                case TRUE: 
                case FALSE: {
                    result = BOOLEAN;
                    break;
                }
                case NULL: {
                    result = NULL;
                    break;
                }
                case NUMBER: {
                    result = NUMBER;
                    break;
                }
                case OBJECT: {
                    result = OBJECT;
                    break;
                }
                case STRING: {
                    result = STRING;
                }
            }
        } else if (element instanceof CommonOutlineItem) {
            CommonOutlineItem item = (CommonOutlineItem)element;
            result = this.getImage(item.getReferenceNode());
        }
        return result == null ? super.getImage(element) : result;
    }

    public String getText(Object element) {
        String result = null;
        if (element instanceof JSONNode) {
            JSONNode node = (JSONNode)element;
            IParseNode parent = node.getParent();
            result = parent instanceof JSONEntryNode ? parent.getFirstChild().getText() : node.getText();
        } else if (element instanceof CommonOutlineItem) {
            CommonOutlineItem item = (CommonOutlineItem)element;
            result = this.getText(item.getReferenceNode());
        }
        return result == null ? super.getText(element) : result;
    }
}

