/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.webserver.ui.internal.actions;

import com.aptana.core.Identifiable;
import com.aptana.core.logging.IdeLog;
import com.aptana.ui.ImageAssociations;
import com.aptana.ui.util.UIUtils;
import com.aptana.webserver.core.IServer;
import com.aptana.webserver.core.IServerType;
import com.aptana.webserver.core.WebServerCorePlugin;
import com.aptana.webserver.ui.WebServerUIPlugin;
import com.aptana.webserver.ui.internal.actions.EditServerHandler;
import com.aptana.webserver.ui.preferences.Messages;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.dialogs.ListDialog;

public class AddServerHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ListDialog dlg = new ListDialog(UIUtils.getActiveShell());
        dlg.setContentProvider((IStructuredContentProvider)ArrayContentProvider.getInstance());
        dlg.setLabelProvider((ILabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                if (element instanceof Identifiable) {
                    Identifiable identifiable = (Identifiable)element;
                    String id = identifiable.getId();
                    ImageRegistry imageRegistry = WebServerUIPlugin.getDefault().getImageRegistry();
                    Image image = imageRegistry.get(id);
                    if (image != null) {
                        return image;
                    }
                    ImageDescriptor desc = ImageAssociations.getInstance().getImageDescriptor(id);
                    if (desc != null) {
                        imageRegistry.put(id, desc);
                        return imageRegistry.get(id);
                    }
                }
                return WebServerUIPlugin.getImage("icons/obj16/server.png");
            }

            public String getText(Object element) {
                if (element instanceof IServerType) {
                    return ((IServerType)element).getName();
                }
                return super.getText(element);
            }
        });
        dlg.setInput((Object)WebServerCorePlugin.getDefault().getServerManager().getServerTypes());
        dlg.setTitle(Messages.ServersPreferencePage_Title);
        if (dlg.open() != 0) {
            return null;
        }
        Object[] result = dlg.getResult();
        if (result != null && result.length == 1) {
            String typeId = ((IServerType)result[0]).getId();
            AddServerHandler.createServer(typeId);
        }
        return null;
    }

    static boolean createServer(String serverTypeId) {
        try {
            IServer newServer = WebServerCorePlugin.getDefault().getServerManager().createServer(serverTypeId);
            if (newServer != null && EditServerHandler.editServerConfiguration(newServer)) {
                WebServerCorePlugin.getDefault().getServerManager().add(newServer);
                return true;
            }
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)WebServerUIPlugin.getDefault(), (Throwable)e);
        }
        return false;
    }
}

