/*
 * Decompiled with CFR 0.152.
 */
package net.contentobjects.jnotify.macosx;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import net.contentobjects.jnotify.IJNotify;
import net.contentobjects.jnotify.JNotifyException;
import net.contentobjects.jnotify.JNotifyListener;
import net.contentobjects.jnotify.macosx.FSEventListener;
import net.contentobjects.jnotify.macosx.JNotifyException_macosx;
import net.contentobjects.jnotify.macosx.JNotify_macosx;

public class JNotifyAdapterMacOSX
implements IJNotify {
    private Hashtable<Integer, WatchData> _id2Data;

    public JNotifyAdapterMacOSX() {
        JNotify_macosx.setNotifyListener(new FSEventListener(){

            public void notifyChange(int wd, String rootPath, String filePath, boolean recurse) {
                JNotifyAdapterMacOSX.this.notifyChangeEvent(wd, rootPath, filePath, recurse);
            }

            public void batchStart(int wd) {
                JNotifyAdapterMacOSX.this.batchStartEvent(wd);
            }

            public void batchEnd(int wd) {
                JNotifyAdapterMacOSX.this.batchEndEvent(wd);
            }
        });
        this._id2Data = new Hashtable();
    }

    public int addWatch(String path, int mask, boolean watchSubtree, boolean recursive, JNotifyListener listener) throws JNotifyException {
        File f;
        try {
            f = new File(path).getCanonicalFile();
        }
        catch (IOException e) {
            throw new JNotifyException_macosx("Could not resolve canonical path for " + path);
        }
        int wd = JNotify_macosx.addWatch(f.getPath());
        this._id2Data.put(wd, new WatchData(wd, mask, listener, path, f, watchSubtree, recursive));
        return wd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeWatch(int wd) throws JNotifyException {
        Hashtable<Integer, WatchData> hashtable = this._id2Data;
        synchronized (hashtable) {
            boolean removed;
            boolean bl = removed = this._id2Data.remove(wd) != null;
            if (removed) {
                JNotify_macosx.removeWatch(wd);
            }
            return removed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyChangeEvent(int wd, String rootPath, String filePath, boolean recurse) {
        Hashtable<Integer, WatchData> hashtable = this._id2Data;
        synchronized (hashtable) {
            WatchData watchData = this._id2Data.get(wd);
            if (watchData != null) {
                watchData.toScan.add(new ScanJob(filePath, recurse));
            }
        }
    }

    void batchStartEvent(int wd) {
        WatchData watchData = this._id2Data.get(wd);
        if (watchData != null) {
            watchData.toScan.clear();
        }
    }

    void batchEndEvent(int wd) {
        WatchData watchData = this._id2Data.get(wd);
        if (watchData != null) {
            ScanJob job;
            JNEvents e = new JNEvents(watchData._mask);
            while ((job = watchData.toScan.poll()) != null) {
                if (!watchData.watchSubtree && !watchData.fullpath.equals(job.path)) continue;
                watchData.scan(job, e);
            }
            if (e.created != null && e.deleted != null && e.renamed != null) {
                Iterator<Map.Entry<JNFile, TreeSet<String>>> iterator = e.created.entrySet().iterator();
                Iterator<Map.Entry<JNFile, TreeSet<String>>> deletedIt = e.deleted.entrySet().iterator();
                Map.Entry<JNFile, TreeSet<String>> created = null;
                if (iterator.hasNext()) {
                    created = iterator.next();
                }
                Map.Entry<JNFile, TreeSet<String>> deleted = null;
                if (deletedIt.hasNext()) {
                    deleted = deletedIt.next();
                }
                while (created != null && deleted != null) {
                    int compare = created.getKey().compareTo(deleted.getKey());
                    if (compare < 0) {
                        if (!iterator.hasNext()) break;
                        created = iterator.next();
                        continue;
                    }
                    if (compare > 0) {
                        if (!deletedIt.hasNext()) break;
                        deleted = deletedIt.next();
                        continue;
                    }
                    TreeSet<String> createdValue = created.getValue();
                    String newpath = createdValue.first();
                    createdValue.remove(newpath);
                    TreeSet<String> deletedValue = deleted.getValue();
                    String oldpath = deletedValue.first();
                    deletedValue.remove(oldpath);
                    e.renamed.put(oldpath, newpath);
                    if (createdValue.size() == 0) {
                        iterator.remove();
                        created = null;
                    }
                    if (deletedValue.size() == 0) {
                        deletedIt.remove();
                        deleted = null;
                    }
                    if (created == null) {
                        if (!iterator.hasNext()) break;
                        created = iterator.next();
                    }
                    if (deleted != null) continue;
                    if (!deletedIt.hasNext()) break;
                    deleted = deletedIt.next();
                }
            }
            if ((watchData._mask & 1) != 0) {
                for (TreeSet<String> treeSet : e.created.values()) {
                    for (String path : treeSet) {
                        watchData._notifyListener.fileCreated(wd, watchData.path, path.substring(watchData.fullpath.length()));
                    }
                }
            }
            if ((watchData._mask & 2) != 0) {
                for (TreeSet treeSet : e.deleted.values()) {
                    for (String path : treeSet) {
                        watchData._notifyListener.fileDeleted(wd, watchData.path, path.substring(watchData.fullpath.length()));
                    }
                }
            }
            if ((watchData._mask & 4) != 0) {
                for (String string : e.modified) {
                    watchData._notifyListener.fileModified(wd, watchData.path, string.substring(watchData.fullpath.length()));
                }
            }
            if ((watchData._mask & 8) != 0) {
                for (Map.Entry entry : e.renamed.entrySet()) {
                    watchData._notifyListener.fileRenamed(wd, watchData.path, ((String)entry.getKey()).substring(watchData.fullpath.length()), ((String)entry.getValue()).substring(watchData.fullpath.length()));
                }
            }
        }
    }

    private static class JNEvents {
        TreeMap<JNFile, TreeSet<String>> created;
        TreeSet<String> modified;
        TreeMap<JNFile, TreeSet<String>> deleted;
        TreeMap<String, String> renamed;

        JNEvents(int mask) {
            if ((mask & 4) != 0) {
                this.modified = new TreeSet();
            }
            if ((mask & 0xB) != 0) {
                this.created = new TreeMap();
                this.deleted = new TreeMap();
                this.renamed = new TreeMap();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JNFile
    implements Comparable<JNFile> {
        long mtime;
        int deviceid;
        long inode;

        static {
            System.loadLibrary("jnotify");
        }

        JNFile(File f) throws IOException {
            this.mtime = f.lastModified();
            this.stat(f.getAbsolutePath());
        }

        private native void stat(String var1) throws IOException;

        @Override
        public int compareTo(JNFile o) {
            if (o.deviceid != this.deviceid) {
                return this.deviceid - o.deviceid;
            }
            if (this.inode < o.inode) {
                return -1;
            }
            if (this.inode == o.inode) {
                return 0;
            }
            return 1;
        }

        public boolean equals(Object o) {
            if (!(o instanceof JNFile)) {
                return false;
            }
            JNFile j = (JNFile)o;
            return j.inode == this.inode && j.deviceid == this.deviceid;
        }

        public int hashCode() {
            return (String.valueOf(this.inode) + "," + this.deviceid).hashCode();
        }

        public String toString() {
            return String.format("%08x.%016x - %d", this.deviceid, this.inode, this.mtime);
        }
    }

    private static class ScanJob {
        String path;
        boolean recursive;

        ScanJob(String path, boolean recursive) {
            this.path = path;
            this.recursive = recursive;
        }

        public String toString() {
            return String.valueOf(this.path) + " " + this.recursive;
        }
    }

    private static class WatchData {
        int _wd;
        int _mask;
        JNotifyListener _notifyListener;
        TreeMap<JNFile, TreeSet<String>> paths;
        TreeMap<String, JNFile> jnfiles;
        LinkedList<ScanJob> toScan;
        String path;
        String fullpath;
        boolean watchSubtree;

        WatchData(int wd, int mask, JNotifyListener listener, String path, File pathFile, boolean watchSubtree, boolean recursive) {
            this._wd = wd;
            this._mask = mask;
            this._notifyListener = listener;
            this.path = path;
            this.fullpath = String.valueOf(pathFile.getPath()) + "/";
            this.watchSubtree = watchSubtree;
            this.paths = new TreeMap();
            this.jnfiles = new TreeMap();
            this.scan(pathFile, recursive, null);
            this.toScan = new LinkedList();
        }

        public String toString() {
            return "wd=" + this._wd;
        }

        private void scan(ScanJob job, JNEvents events) {
            this.scan(new File(job.path), job.recursive, events);
        }

        private void scan(File root, boolean recursive, JNEvents events) {
            File[] files = root.listFiles();
            Set<Map.Entry<String, JNFile>> existingfiles = this.jnfiles.tailMap(String.valueOf(root.getAbsolutePath()) + "\u0000").entrySet();
            TreeSet<String> stillAlive = null;
            String rootPath = root.getAbsolutePath();
            if (files != null) {
                stillAlive = new TreeSet<String>();
                int i = 0;
                while (i < files.length) {
                    String filePath = files[i].getAbsolutePath();
                    int slashindex = (filePath = filePath.substring(rootPath.length() + 1)).indexOf("/");
                    if (slashindex >= 0) {
                        filePath = filePath.substring(0, slashindex);
                    }
                    stillAlive.add(filePath);
                    try {
                        JNFile oldjnf;
                        TreeSet plist;
                        JNFile jnf = new JNFile(files[i]);
                        Iterator<Map.Entry<JNFile, TreeSet<String>>> iter = this.paths.entrySet().iterator();
                        Map.Entry<JNFile, TreeSet<String>> oldEntry = null;
                        while (iter.hasNext()) {
                            Map.Entry<JNFile, TreeSet<String>> currentEntry = iter.next();
                            if (currentEntry.getKey().compareTo(jnf) > 0) break;
                            oldEntry = currentEntry;
                        }
                        if (oldEntry == null || !jnf.equals(oldEntry.getKey())) {
                            plist = new TreeSet();
                            this.paths.put(jnf, plist);
                        } else {
                            plist = (TreeSet)oldEntry.getValue();
                            JNFile oldKey = oldEntry.getKey();
                            if (oldKey.mtime != jnf.mtime) {
                                oldKey.mtime = jnf.mtime;
                                if (events != null && events.modified != null && !files[i].isDirectory()) {
                                    for (String path : plist) {
                                        events.modified.add(path);
                                    }
                                }
                            }
                        }
                        String path = files[i].getAbsolutePath();
                        if (!plist.contains(path)) {
                            plist.add(path);
                            if (events != null && events.created != null) {
                                TreeSet<String> eplist = events.created.get(jnf);
                                if (eplist == null) {
                                    eplist = new TreeSet();
                                    events.created.put(jnf, eplist);
                                }
                                eplist.add(path);
                            }
                        }
                        if ((oldjnf = this.jnfiles.put(path, jnf)) != null && !jnf.equals(oldjnf)) {
                            TreeSet<String> oldPaths = this.paths.get(oldjnf);
                            if (oldPaths != null) {
                                oldPaths.remove(path);
                                if (oldPaths.size() == 0) {
                                    this.paths.remove(oldjnf);
                                }
                            }
                            if (events != null && events.deleted != null) {
                                TreeSet<String> eplist = events.deleted.get(oldjnf);
                                if (eplist == null) {
                                    eplist = new TreeSet();
                                    events.deleted.put(oldjnf, eplist);
                                }
                                eplist.add(path);
                            }
                        }
                        if (this.watchSubtree && recursive && files[i].isDirectory()) {
                            this.scan(files[i], recursive, events);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    ++i;
                }
            }
            Iterator<Map.Entry<String, JNFile>> entryit = existingfiles.iterator();
            Iterator stillAliveit = null;
            String lastAlive = null;
            if (stillAlive != null && (stillAliveit = stillAlive.iterator()).hasNext()) {
                lastAlive = (String)stillAliveit.next();
            }
            while (entryit.hasNext()) {
                JNFile jnf;
                TreeSet<String> oldPaths;
                Map.Entry<String, JNFile> entry = entryit.next();
                String jnp = entry.getKey();
                if (!jnp.startsWith(rootPath)) break;
                if (lastAlive != null) {
                    String oldFilePath = jnp;
                    int slashindex = (oldFilePath = oldFilePath.substring(rootPath.length() + 1)).indexOf("/");
                    if (slashindex >= 0) {
                        oldFilePath = oldFilePath.substring(0, slashindex);
                    }
                    int compare = -1;
                    while (lastAlive != null && (compare = oldFilePath.compareTo(lastAlive)) > 0) {
                        lastAlive = stillAliveit.hasNext() ? (String)stillAliveit.next() : null;
                    }
                    if (compare == 0 && lastAlive != null) continue;
                }
                if ((oldPaths = this.paths.get(jnf = entry.getValue())) != null) {
                    oldPaths.remove(jnp);
                    if (oldPaths.size() == 0) {
                        this.paths.remove(jnf);
                    }
                }
                entryit.remove();
                if (events == null || events.deleted == null) continue;
                TreeSet<String> eplist = events.deleted.get(jnf);
                if (eplist == null) {
                    eplist = new TreeSet();
                    events.deleted.put(jnf, eplist);
                }
                eplist.add(jnp);
            }
        }
    }
}

