/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.deploy.heroku.ui.wizard;

import com.aptana.deploy.heroku.HerokuPlugin;
import com.aptana.deploy.heroku.ui.wizard.HerokuDeployWizard;
import com.aptana.deploy.heroku.ui.wizard.Messages;
import com.aptana.git.core.GitPlugin;
import com.aptana.git.core.model.GitRepository;
import com.aptana.ui.util.SWTUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class HerokuDeployWizardPage
extends WizardPage {
    public static final String NAME = "HerokuDeploy";
    private Text appName;
    private Button publishButton;

    protected HerokuDeployWizardPage() {
        super(NAME, Messages.HerokuDeployWizardPage_Title, null);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        this.setControl((Control)composite);
        this.initializeDialogUnits((Control)parent);
        Composite appSettings = new Composite(composite, 0);
        appSettings.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(appSettings, 0);
        label.setText(Messages.HerokuDeployWizardPage_ApplicationNameLabel);
        this.appName = new Text(appSettings, 2052);
        this.appName.setLayoutData((Object)new GridData(250, -1));
        this.appName.setText(this.getProjectName());
        this.appName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                HerokuDeployWizardPage.this.getContainer().updateButtons();
            }
        });
        this.publishButton = new Button(composite, 32);
        this.publishButton.setText(Messages.HerokuDeployWizardPage_PublishApplicationLabel);
        this.publishButton.setSelection(Platform.getPreferencesService().getBoolean(HerokuPlugin.getPluginIdentifier(), "HerokuAutoPublish", true, null));
        if (this.doesntHaveGitRepo()) {
            Label note = new Label(composite, 64);
            Font dialogFont = JFaceResources.getDialogFont();
            FontData[] data = SWTUtils.italicizedFont((Font)JFaceResources.getDialogFont());
            final Font italic = new Font(dialogFont.getDevice(), data);
            note.setFont(italic);
            note.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (!italic.isDisposed()) {
                        italic.dispose();
                    }
                }
            });
            note.setLayoutData((Object)new GridData(400, -1));
            note.setText(Messages.HerokuDeployWizardPage_NoGitRepoNote);
        }
        Dialog.applyDialogFont((Control)composite);
    }

    protected String getProjectName() {
        IProject project = this.getProject();
        if (project == null) {
            return "";
        }
        return project.getName();
    }

    protected boolean doesntHaveGitRepo() {
        IProject project = this.getProject();
        if (project == null) {
            return false;
        }
        GitRepository repo = GitPlugin.getDefault().getGitRepositoryManager().getUnattachedExisting(project.getLocationURI());
        return repo == null;
    }

    protected IProject getProject() {
        HerokuDeployWizard wizard = (HerokuDeployWizard)this.getWizard();
        return wizard.getProject();
    }

    public IWizardPage getNextPage() {
        return null;
    }

    public boolean isPageComplete() {
        String app = this.appName.getText();
        if (app == null || app.trim().length() < 1) {
            this.setErrorMessage(Messages.HerokuDeployWizardPage_EmotyApplicationNameError);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public String getAppName() {
        return this.appName.getText();
    }

    public boolean publishImmediately() {
        return this.publishButton.getSelection();
    }
}

