/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.formatter.nodes;

import com.aptana.formatter.IFormatterContext;
import com.aptana.formatter.IFormatterDocument;
import com.aptana.formatter.IFormatterWriter;
import com.aptana.formatter.nodes.FormatterTextNode;

public abstract class FormatterCommentNode
extends FormatterTextNode {
    public FormatterCommentNode(IFormatterDocument document, int startOffset, int endOffset) {
        super(document, startOffset, endOffset);
    }

    public void accept(IFormatterContext context, IFormatterWriter visitor) throws Exception {
        boolean beginWithNewLine = this.isAddingBeginNewLine();
        if (beginWithNewLine && !visitor.endsWithNewLine() && !this.shouldConsumePreviousWhiteSpaces()) {
            visitor.writeLineBreak(context);
        }
        boolean currentCommentState = context.isComment();
        context.setComment(true);
        if (this.getDocument().getBoolean(this.getWrappingKey())) {
            boolean savedWrapping = context.isWrapping();
            context.setWrapping(true);
            visitor.write(context, this.getStartOffset(), this.getEndOffset());
            context.setWrapping(savedWrapping);
        } else {
            visitor.write(context, this.getStartOffset(), this.getEndOffset());
        }
        context.setComment(currentCommentState);
        boolean endWithNewLine = this.isAddingEndNewLine();
        if (endWithNewLine && !visitor.endsWithNewLine()) {
            visitor.writeLineBreak(context);
        }
    }

    public boolean isAddingEndNewLine() {
        return false;
    }

    public boolean isAddingBeginNewLine() {
        return false;
    }

    public abstract String getWrappingKey();
}

